<?
/*
Autor: Lic. Carlos Alberto Vaca Coronado
Version: 3.4.0
Cambio: Clase nueva (archivo nuevo)
*/

Class WSSAT{


	var $wsdlSAT = "https://consultaqr.facturaelectronica.sat.gob.mx/ConsultaCFDIService.svc?WSDL";
	//var $wsdlSAT = "https://consultaqrfacturaelectronicatest.sw.com.mx/ConsultaCFDIService.svc?WSDL";
	var $endPoint = "https://consultaqr.facturaelectronica.sat.gob.mx/ConsultaCFDIService.svc";
	var $expresionImpresa="";  //?re=RFC Emisor&rr=RFC Receptor&tt=Total con 6 decimales&id=UUID
	var $ws_sat;
	var $estadoCFDI;
	var $codigoStatus;
	var $mensaje;
	var $mensajeCompleto;
	var $request;
	var $response;

	function verificaCFDI_anterior(){
		$this->ws_sat = new nusoap_client($this->wsdlSAT,'wsdl');
		$this->ws_sat->soap_defencoding = 'UTF-8';
		$this->ws_sat->decode_utf8 = false;
		$this->ws_sat->setEndpoint($this->endPoint);

		$parametros = array("expresionImpresa" => $this->expresionImpresa);


		$resultado = $this->ws_sat->call("Consulta",$parametros);
		// echo $this->ws_sat->getError();exit;
		// var_dump($resultado);exit;
		$arrCodigoEstatus = explode("-",$resultado['ConsultaResult']['CodigoEstatus']);
		$this->codigoStatus=str_replace(" ","",$arrCodigoEstatus[0]);
		$this->mensaje=trim(str_replace("602:","",str_replace("601:","",$arrCodigoEstatus[1])));
		$this->mensajeCompleto=$resultado['ConsultaResult']['CodigoEstatus'];
		$this->estadoCFDI=trim($resultado['ConsultaResult']['Estado']);
		$this->request = $this->ws_sat->request;
		echo $this->response = $this->ws_sat->response;exit;
	}

	function verificaCFDI(){
        $soapUrl = $this->endPoint;
        $xml_post_string = '<?xml version="1.0" encoding="UTF-8" ?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:tem="http://tempuri.org/">
    <soapenv:Header/>
    <soapenv:Body>
        <tem:Consulta>
            <tem:expresionImpresa><![CDATA['.$this->expresionImpresa.']]></tem:expresionImpresa>
        </tem:Consulta>
    </soapenv:Body>
</soapenv:Envelope>';

           $headers = array(
                        "Content-type: text/xml;charset=\"utf-8\"",
                        "Accept: text/xml",
                        "Cache-Control: no-cache",
                        "Pragma: no-cache",
                        "SOAPAction: http://tempuri.org/IConsultaCFDIService/Consulta",
                        "Content-length: ".strlen($xml_post_string),
                    );

            $url = $soapUrl;

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $xml_post_string);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $response = curl_exec($ch);

			$httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			$xml = simplexml_load_string(str_replace("s:","",str_replace("a:","",$response)));

			$this->request = $xml_post_string;

			$err = curl_error($ch);

			if ($err)
			{
				$this->CODEHTTP=-1;
				throw new Exception("cURL Error #:" . $err);
				$this->ERROR_MESSAGE = $err;
				return $response;
			} else if($httpcode!='200') {
				$this->CODEHTTP=$httpcode;
				$this->ERROR_MESSAGE = $this->RESPONSE->message;
				return $response;
			}
			else{

				$this->CODEHTTP=200;
				$arrCodigoEstatus = explode("-",$xml->Body->ConsultaResponse->ConsultaResult->CodigoEstatus);
				$this->codigoStatus=str_replace(" ","",$arrCodigoEstatus[0]);
				$this->mensaje=trim(str_replace("602:","",str_replace("601:","",$arrCodigoEstatus[1])));
				$this->mensajeCompleto=$xml->Body->ConsultaResponse->ConsultaResult->CodigoEstatus;
				$this->estadoCFDI=trim($xml->Body->ConsultaResponse->ConsultaResult->Estado);
				$this->request = $xml_post_string;
				$this->response = $response;
				return $response;
			}
	}
}

?>
