<?php
date_default_timezone_set('America/Mexico_City');
set_time_limit(0);

require_once('../../clases/wsUtil.class.php');
require_once('../../libs/funciones.php');
require_once('../../clases/datosbd.class.php');
require_once('../../MandaCorreos/FuncionSendMail.php');

/*echo Encripta("ZGlqbQ==",1);
exit;*/

$PROVISION_DE_PAGOS=getINI("PROVISION_DE_PAGOS=","../../config.ini");

$datosbd = new datosbd();
$datosbd->conectar();
try{
	$xml = simplexml_load_string(file_get_contents("rechazaCancelacionAutomatico.xml"));
	$noConfig=0;
	$tipoCancelacion="T";
	if(trim($xml->TipoConsulta) !== ""){
		$tipoCancelacion=trim($xml->TipoConsulta);
	}
	foreach($xml->ConfigRFC as $child) {
		$noConfig++;
		$receptor="";
		$body="";
		$asunto="";
		$correos="";
		$RechazoAutomaticoHrs = "";
		$ban=false;
		debug("Inicia Proceso $noConfig",$xml->Debug);
		debug("Validando configuración",$xml->Debug);
		if(trim($child->RFCConsultar) === ""){
			writeLog("No existe RFC a consultar");
			debug("No existe RFC a consultar",$xml->Debug);
			$ban=true;
		}
		if(trim($child->RechazoAutomaticoHrs) === ""){
			writeLog("No esta configurado el numero de horas de rechazo automático");
			debug("No esta configurado el numero de horas de rechazo automático",$xml->Debug);
			$ban=true;
		}
		if(!is_file($child->Correo->Cuerpo)){
			writeLog("El cuerpo del correo no existe.");
			debug("El cuerpo del correo no existe.",$xml->Debug);
			$ban=true;
		}
		if(trim($child->Correo->AsuntoCorreo) === ""){
			writeLog("El asunto del correo no existe.");
			debug("El asunto del correo no existe.",$xml->Debug);
			$ban=true;
		}
		if(trim($child->Correo->CorreosEnviar) === ""){
			writeLog("No existen correos a enviar.");
			debug("No existen correos a enviar.",$xml->Debug);
			$ban=true;
		}
		
		debug("RFC: ".$child->RFCConsultar,$xml->Debug);
		debug("Cuerpo de correo: ".$child->Correo->Cuerpo,$xml->Debug);
		debug("Asunto de correo: ".$child->Correo->AsuntoCorreo,$xml->Debug);
		debug("Correos: ".$child->Correo->CorreosEnviar,$xml->Debug);
		debug("Termina validar configuración",$xml->Debug);
		
		if($ban===true){
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: Faltan parametros en la configuración."),"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		
		$receptor = $child->RFCConsultar;
		$body = file_get_contents($child->Correo->Cuerpo);
		$asunto = $child->Correo->AsuntoCorreo;
		$correos = $child->Correo->CorreosEnviar;
		$RechazoAutomaticoHrs = $child->RechazoAutomaticoHrs;
		if($datosbd->getUUIDPendientesCancelacion($receptor) === false){
			writeLog("Ocurrio un error al consultar los uuids pendientes de cancelación. Error: ".mysqli_error($datosbd->CONEXION));
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: Al consultar los uuids pendientes de cancelación".$datosbd->mensajeerror),"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		if($datosbd->cUUIDPendientesCancelacion == null){
			debug("No hay pendientes de cancelación.",$xml->Debug);
			continue;
		}
		debug("Consultando información del RFC $receptor.",$xml->Debug);
		if($datosbd->getReceptor($receptor) === false){
			writeLog("Ocurrio un error al consultar los datos del receptor. Error: ".mysqli_error($datosbd->CONEXION));
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: Al consultar los datos del receptor. ".$datosbd->mensajeerror),"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		debug("Consulta ejecutada correctamente.",$xml->Debug);
		if($datosbd->cReceptor == null){
			writeLog("No se encontro la configuración del receptor.");
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: no se encontro la configuración del receptor."),"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		
		debug("Creando encabezado del cuerpo del correo",$xml->Debug);
		$bodyNuevo = encabezado($body,$receptor);
		if($bodyNuevo === false){
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: Al crear el encabezado del cuerpo del correo. ".$datosbd->mensajeerror),"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		
		debug("Inicia iteración de uuids",$xml->Debug);
		$detalleCompleto="";
		while($tmp = mysqli_fetch_assoc($datosbd->cUUIDPendientesCancelacion)){
			$uuid = $tmp["uuid"];
			$bloqueadoPP = $tmp["bloqueadoPP"];
			$fechaHoy = date("YmdHis");
			$fechaMasHrs = strtotime ( '+'.$RechazoAutomaticoHrs.' hour' , strtotime ( $tmp["fechaInsercion"] ) ) ;
			
			$fechaMasHrs = date("YmdHis",str_replace(" ","",str_replace(":","",str_replace("-","",$fechaMasHrs))));
			
			debug("Validando fecha de vencimiento para rechazar automaticamente el uuid $uuid",$xml->Debug);
			
			if(strtoupper(trim($PROVISION_DE_PAGOS)) == "SI"){
				if($bloqueadoPP == "1"){
					debug("El uuid $uuid sera rechazado automaticamente por su estado bloqueadoPP",$xml->Debug);
					goto RECHAZAR;
				}
			}
			
			if($fechaMasHrs > $fechaHoy ){
				debug("El uuid aún no se debe de rechazar automaticamente",$xml->Debug);
				continue;
			}
			debug("El uuid $uuid ya debe de ser rechazado automaticamente",$xml->Debug);

			// ------------------------ INICIA RECHAZO AUTOMATICO ------------------------
			RECHAZAR:

			debug("Iniciando proceso de rechazo",$xml->Debug);
			$wsUtil = new wsUtil($tipoCancelacion);
			debug("Ejecutando webservice de rechazo de cancelación.",$xml->Debug);
			// echo $uuid."<br/>";continue;
			if($wsUtil->aceptarRechazarCancelacion($receptor,$uuid,"Rechazo",Encripta($datosbd->cReceptor["cerPass"],1),$datosbd->cReceptor["cerB64"],$datosbd->cReceptor["keyB64"]) !== false){
				if($wsUtil->RESPONSE->statusWS != 200){
					writeLog("El WS de cancelación regreso un error. Error: ".$wsUtil->RESPONSE->errorWS);
					debug("El WS de cancelación regreso un error. Error: ".$wsUtil->RESPONSE->errorWS,$xml->Debug);
					/*$pos = strpos($wsUtil->RESPONSE->errorWS,"CACFDI33");
					if($pos !== false){
						updateBD($uuid);
						continue;
					}*/
					debug("Enviando correo de error",$xml->Debug);
					if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: El WS de cancelación regreso un error al rechazar cancelación del uuid $uuid. ".$wsUtil->RESPONSE->errorWS),"","","")){
						writeLog("Ocurrio un error al notificar el error.");
						debug("Ocurrio un error al notificar el error.",$xml->Debug);
					}else{
						debug("Correo de error enviado.",$xml->Debug);
					}
					continue;
				}
		
				if($wsUtil->RESPONSE->codStatusSAT == "1000" || $wsUtil->RESPONSE->statusSAT == "success"){
					$q = "insert into acuses_cancelacion_cfdi set uuid='$uuid', rfc='$rfcreceptor', acuse='".mysqli_real_escape_string($datosbd->CONEXION,$wsUtil->RESPONSE->acuseSAT)."' on duplicate key update acuse='".mysqli_real_escape_string($datosbd->CONEXION,$wsUtil->RESPONSE->acuseSAT)."'";
					
					debug("Guardando acuse de recházo",$xml->Debug);
					if(!mysqli_query($datosbd->CONEXION,$q)){
						writeLog("Ocurrio un error al guardar el acuse.");
						debug("Ocurrio un error al guardar el acuse.",$xml->Debug);
						if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: No se guardo el acuse de cancelación del uuid $uuid."),"","","")){
							writeLog("Ocurrio un error al notificar el error.");
							debug("Ocurrio un error al notificar el error.",$xml->Debug);
						}
					}else{
						debug("Acuse guardado correctamente.",$xml->Debug);
					}
					
					$status="";
					debug("Validando estatus UUID SAT",$xml->Debug);
					if($wsUtil->RESPONSE->estatusUUIDSAT == "1000"){
						$status="Petición de respuesta exitosa.";
						updateBD($uuid);
						debug($status,$xml->Debug);
					}elseif($wsUtil->RESPONSE->estatusUUIDSAT == "1001"){
						$status="Petición de respuesta exitosa. No existen peticiones de cancelación en espera de respuesta para el uuid.";
						updateBD($uuid);
						debug($status,$xml->Debug);
					}elseif($wsUtil->RESPONSE->estatusUUIDSAT == "1002"){
						$status="Ya se recibió una respuesta para la petición de cancelación del uuid.";
						updateBD($uuid);
						writeLog($status);
						debug($status,$xml->Debug);
					}elseif($wsUtil->RESPONSE->estatusUUIDSAT == "1003"){
						$status="Sello No Corresponde al RFC Receptor.";
						writeLog($status);
						debug($status,$xml->Debug);
					}elseif($wsUtil->RESPONSE->estatusUUIDSAT == "1004"){
						$status="Existen más de una petición de cancelación para el mismo uuid.";
						writeLog($status);
						debug($status,$xml->Debug);
					}elseif($wsUtil->RESPONSE->estatusUUIDSAT == "1005"){
						$status="El uuid es nulo no posee el formato correcto.";
						writeLog($status);
						debug($status,$xml->Debug);
					}elseif($wsUtil->RESPONSE->estatusUUIDSAT == "1006"){
						$status="Se rebaso el número máximo de solicitudes permitidas.";
						writeLog($status);
						debug($status,$xml->Debug);
					}
					debug("Termina validación de UUID SAT",$xml->Debug);
					
					$resultDetalle = detalle($uuid,$body,$xml->Debug,$status);
					if($resultDetalle !== false){
						$detalleCompleto.=$resultDetalle;
					}
					
				}else{
					writeLog("Error: ".$wsUtil->RESPONSE->mensajeErrorSAT." -> ".$wsUtil->RESPONSE->descripcionEstatusUUIDSAT);
					debug("Error: ".$wsUtil->RESPONSE->mensajeErrorSAT." -> ".$wsUtil->RESPONSE->descripcionEstatusUUIDSAT,$xml->Debug);
					if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: El status del uuid $uuid regreso un codigo de error. ".$wsUtil->RESPONSE->mensajeErrorSAT." -> ".$wsUtil->RESPONSE->descripcionEstatusUUIDSAT),"","","")){
						writeLog("Ocurrio un error al notificar el error.");
						debug("Ocurrio un error al notificar el error.",$xml->Debug);
					}else{
						debug("Correo de error enviado correctamente.",$xml->Debug);
					}
					continue;
				}
			}else{
				writeLog("Ocurrio un error al ejecutar la petición: ".$wsUtil->RESPONSE->errorWS);
				debug("Ocurrio un error al ejecutar la petición: ".$wsUtil->RESPONSE->errorWS,$xml->Debug);
				if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en rechazaCancelacionAutomatico - RecibeCFD",utf8_decode("Error: Al ejecutar la petición de rechazo del uuid $uuid. ".$wsUtil->RESPONSE->errorWS),"","","")){
					writeLog("Ocurrio un error al notificar el error.");
					debug("Ocurrio un error al notificar el error.",$xml->Debug);
				}else{
					debug("Correo de error enviado correctamente.",$xml->Debug);
				}
				continue;
			}
		}//while
		
		if(trim($detalleCompleto) !== ""){
			$bodyNuevo = str_replace("<<DETALLE>>",$detalleCompleto,$bodyNuevo);
			echo $bodyNuevo;
			debug("Enviando correo de notificación de recházo",$xml->Debug);
			
			if($datosbd->cReceptor != null){
				$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHARECHAZO;;");
				$arrVal = array($datosbd->cReceptor["nombre"],$receptor,date("Y-m-d H:i:s"));
			}else{
				$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHARECHAZO;;");
				$arrVal = array("",$receptor,date("Y-m-d H:i:s"));
			}
			$asunto = str_replace($arrLbl,$arrVal,$asunto);
			
			if(!SendMail($correos,$correos,utf8_decode($asunto),utf8_decode($bodyNuevo),"","","")){
				writeLog("Ocurrio un error al enviar el correo de rechazo de cancelación.");
				debug("Ocurrio un error al enviar el correo de rechazo de cancelación.",$xml->Debug);
			}else{
				debug("Termina envio de correo correctamente.",$xml->Debug);
			}
		}else{
			debug("Nada que enviar.",$xml->Debug);
		}
		
	}//ConfigRFC
}catch(Exception $e){
	writeLog($e->getMessage);
	$xml = simplexml_load_string(file_get_contents("rechazaCancelacionAutomatico.xml"));
	if(!SendMail($xml->CorreosError,$xml->CorreosError,utf8_decode("Ocurrio una excepción en rechazaCancelacionAutomatico - RecibeCFD"),utf8_decode("Error: ".$e->getMessage),"","","")){
		writeLog("Ocurrio un error al notificar el error.");
	}
	writeLog("Ocurrio un error al rechazar cancelaciones.");
	
}
function encabezado($body,$receptor){
	global $datosbd;
	$arrI = explode("--INICIADETALLE--",$body);
	$arrF = explode("--TERMINADETALLE--",$body);
	$enc = $arrI[0];
	$fin = $arrF[1];
	debug("Consultando receptor $receptor en la base de datos de recibedoce",$xml->Debug);
	if($datosbd->getReceptor($receptor) === true){
		debug("Consulta ejecutada correctamente.",$xml->Debug);
		if($datosbd->cReceptor != null){
			$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHARECHAZO;;");
			$arrVal = array($datosbd->cReceptor["nombre"],$receptor,date("Y-m-d H:i:s"));
		}else{
			$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHARECHAZO;;");
			$arrVal = array("",$receptor,date("Y-m-d H:i:s"));
		}
		$enc = str_replace($arrLbl,$arrVal,$enc);
	}else{
		writeLog("Ocurrio un error al consultar el RFC Receptor $receptor. Error: ".$datosbd->mensajeerror);
		return false;
	}
	$enc.="<<DETALLE>>".$fin;
	return $enc;
}

function writeLog($mensaje){
	$date = date("Ymd");
	$dateFull = date("Y-m-d H:i:s");
	if(!is_dir("log")){
		mkdir("log",775);
	}
	$fp = fopen("log/rechazaCancelacionAutomatico_$date.log","a+");
	fwrite($fp,$dateFull." -> ".$mensaje."\r\n");
	fclose($fp);
}
function debug($mensaje,$ban){
	if($ban=="1"){
		$date = date("Ymd");
		$dateFull = date("Y-m-d H:i:s");
		if(!is_dir("log")){
			mkdir("log",775);
		}
		$fp = fopen("log/rechazaCancelacionAutomatico_$date.debug","a+");
		fwrite($fp,$dateFull." -> ".$mensaje."\r\n");
		fclose($fp);
	}
}

function detalle($uuid,$body,$debug,$status){
	global $datosbd;
	debug("Ejecutando consulta de uuid $uuid en la base de datos de recibedoce",$debug);
	if($datosbd->getRecibeDoce($uuid) === true){
		// if($datosbd->getRecibeDoce("8AC24A22-17B4-45A3-82E9-7F0D2884F3D7") === true){
		//Termina codigo pruebas
		debug("uuid $uuid consultado correctamente en la base de datos de recibedoce",$debug);
		debug("Agregando $uuid al detalle del reporte",$debug);
		$arr = explode("--INICIADETALLE--",$body);
		$arrF = explode("--TERMINADETALLE--",$arr[1]);
		if($datosbd->cRecibeDoce != null){
			$arrLbl = array(";;RFCEMISOR;;",";;RAZONSOCIALEMISOR;;",";;TDOCTO;;",";;SERIE;;",";;FOLIO;;",";;UUID;;",";;STATUS;;");
			$arrVal = array($datosbd->cRecibeDoce["rfcEmisor"],$datosbd->cRecibeDoce["nombreemi"],$datosbd->cRecibeDoce["tipoDocto"],$datosbd->cRecibeDoce["serie"],$datosbd->cRecibeDoce["folio"],$uuid,$status);
			debug("El uuid $uuid se encontro en la base de datos de recibedoce",$debug);
		}else{
			$arrLbl = array(";;RFCEMISOR;;",";;RAZONSOCIALEMISOR;;",";;TDOCTO;;",";;SERIE;;",";;FOLIO;;",";;UUID;;",";;STATUS;;");
			$arrVal = array("","","","","",$uuid,$status);
			debug("El uuid $uuid no se encontro en la base de datos de recibedoce",$debug);
		}
		$detalle = str_replace($arrLbl,$arrVal,$arrF[0]);
		debug("$uuid agregado al detalle del reporte",$debug);
	}else{
		writeLog("Ocurrio un error al consultar el uuid $uuid en recibedoce. Error: ".$datosbd->mensajeerror);
		return false;
	}
	return $detalle;
}

function updateBD($uuid){
	global $datosbd;
	$qI = "update uuid_pendientes_cancelacion set status='1' where uuid='$uuid'";
	if(!mysqli_query($datosbd->CONEXION,$qI)){
		writeLog("Ocurrio un error al insertar el uuid en la base de datos");
		return false;
	}
	return true;
}

?>
