<!DOCTYPE html>

<html lang="es">

<head>

	 <title id='Description'>FAQ</title>

    <link rel="stylesheet" href="grid/styles/jqx.base.css" type="text/css" />

    <link rel="stylesheet" href="grid/styles/jqx.classic.css" type="text/css" />

    <link rel="stylesheet" href="grid/styles/jqx.web.css" type="text/css" />

	

	<script type="text/javascript" src="scripts/jquery-1.11.1.min.js"></script>  

	<script type="text/javascript" src="grid/jqx-all.js"></script>

	

	



	

	<script type="text/javascript">

        $(document).ready(function () 

		{

            var theme = 'classic'; //tema del grid

      var generaterow = function (id) {

                var row = {};

                // var firtnameindex = Math.floor(Math.random() * firstNames.length);

                // var lastnameindex = Math.floor(Math.random() * lastNames.length);

                // var k = firtnameindex;

                row["id"] = id;

                row["error"] = 'error';

                row["descripcion"] = 'descricpcion';

                row["solucion"] = 'solucion';

                return row;

            }

            var source =		//inicializo variable para los datos del grid

            {

                 datatype: "json",

                 datafields: [

					{ name: 'id', type: 'string'},

					{ name: 'error' },

					{ name: 'descripcion' },

					{ name: 'solucion' },

                ],

				id: 'id',

			    url: 'data.php',		

				pagesize: 10,

				cache: false,

				filter: function()			//funcion para filtrar grid

				{

					$("#faq").jqxGrid('updatebounddata', 'filter');

				},

				sort: function()			//funcion para filtrar grid

				{

					$("#faq").jqxGrid('updatebounddata', 'sort');

				},

				root: 'Rows',

				beforeprocessing: function(data)		//funcion antes de procesar datos

				{		

					if (data != null)

					{

						source.totalrecords = data[0].TotalRows;					

					}

				},

				addrow: function (rowid, rowdata, position, commit) {

					// synchronize with the server - send insert command

					var data = "insert=true&;" + $.param(rowdata);

						$.ajax({

							dataType: 'json',

							url: 'data.php',

							data: data,

							cache: false,

							success: function (data, status, xhr) {

								// insert command is executed.

								commit(true);

							},

							error: function(jqXHR, textStatus, errorThrown)

							{

								commit(false);

							}

						});							

				},

				deleterow: function (rowid, commit) {

					// synchronize with the server - send delete command

						var data = "delete=true&amp;" + $.param({EmployeeID: rowid});

						$.ajax({

							dataType: 'json',

							url: 'data.php',

							cache: false,

							data: data,

							success: function (data, status, xhr) {

								// delete command is executed.

								commit(true);

							},

							error: function(jqXHR, textStatus, errorThrown)

							{

								commit(false);

							}

						});							

				},

				updaterow: function (rowid, rowdata, commit) {

					// synchronize with the server - send update command

						var data = "update=true&amp;" + $.param(rowdata);

							$.ajax({

							dataType: 'json',

							url: 'data.php',

							cache: false,

							data: data,

							success: function (data, status, xhr) {

								// update command is executed.

								commit(true);

							},

							error: function(jqXHR, textStatus, errorThrown)

							{

								commit(false);

							}							

						});		

				}

            };		

			

	

			var dataAdapter = new $.jqx.dataAdapter(source, {		//adapto datos json para grid

					loadError: function(xhr, status, error)

					{

						alert(error);

					}

				}

			);

	

            $("#faq").jqxGrid(			// inicializo el grid

            {		

				width: "80%",

				// height: 300,

                source: dataAdapter,

                theme: theme,

				filterable: false,

				sortable: false,

				autoheight: true,

				// autowidth: true,

				autorowheight: true,

				pageable: true,

				virtualmode: false,

				altrows: true,

				editable: false,

				showstatusbar: true,

				renderstatusbar: function (statusbar) {statusbar.append($("<span style='margin: 5px;'>Status Bar</span>"));},

				rendergridrows: function(obj)

				{

					 return obj.data;    

				},

				//aplico datos alas columnas

			    columns: [

					{ text: 'ID', columngroup: 'faq', datafield: 'id',  columntype: 'number', cellsalign: 'center', align: 'center',width: 20},

					{ text: 'Error', columngroup: 'faq', datafield: 'error', align: 'center',  },

					{ text: 'Descripcion', columngroup: 'faq', datafield: 'descripcion', align: 'center',},

					{ text: 'Solucion', columngroup: 'faq', datafield: 'solucion', align: 'center',  },

				],

				columngroups: [

                    { text: 'Errores Comunes RecibeCFD', align: 'center', name: 'faq' }

                ]

			});

			

			$("#addrowbutton").jqxButton({ theme: theme });

            $("#deleterowbutton").jqxButton({ theme: theme });

            $("#updaterowbutton").jqxButton({ theme: theme });

            // update row.

            $("#updaterowbutton").bind('click', function () {

                var datarow = generaterow();

                var selectedrowindex = $("#faq").jqxGrid('getselectedrowindex');

                var rowscount = $("#faq").jqxGrid('getdatainformation').rowscount;

                if (selectedrowindex >= 0 && selectedrowindex < rowscount) {

                    var id = $("#faq").jqxGrid('getrowid', selectedrowindex);

                    $("#faq").jqxGrid('updaterow', id, datarow);

                }

            });

            // create new row.

            $("#addrowbutton").bind('click', function () {

                var rowscount = $("#faq").jqxGrid('getdatainformation').rowscount;

                var datarow = generaterow(rowscount + 1);

                $("#faq").jqxGrid('addrow', null, datarow);

            });

            // delete row.

            $("#deleterowbutton").bind('click', function () {

                var selectedrowindex = $("#faq").jqxGrid('getselectedrowindex');

                var rowscount = $("#faq").jqxGrid('getdatainformation').rowscount;

                if (selectedrowindex >= 0 && selectedrowindex < rowscount) {

                    var id = $("#faq").jqxGrid('getrowid', selectedrowindex);

                    $("#faq").jqxGrid('deleterow', id);

                }

            });		

			

			// Para exportas datos

			// $("#excelExport").jqxButton({ theme: theme });

            // $("#xmlExport").jqxButton({ theme: theme });

            // $("#csvExport").jqxButton({ theme: theme });

            // $("#tsvExport").jqxButton({ theme: theme });

            // $("#htmlExport").jqxButton({ theme: theme });

            // $("#jsonExport").jqxButton({ theme: theme });

            // $("#excelExport").click(function () {

                // $("#faq").jqxGrid('exportdata', 'xls', 'jqxGrid');           

            // });

            // $("#xmlExport").click(function () {

                // $("#faq").jqxGrid('exportdata', 'xml', 'jqxGrid');

            // });

            // $("#csvExport").click(function () {

                // $("#faq").jqxGrid('exportdata', 'csv', 'jqxGrid');

            // });

            // $("#tsvExport").click(function () {

                // $("#faq").jqxGrid('exportdata', 'tsv', 'jqxGrid');

            // });

            // $("#htmlExport").click(function () {

                // $("#faq").jqxGrid('exportdata', 'html', 'jqxGrid');

            // });

            // $("#jsonExport").click(function () {

                // $("#faq").jqxGrid('exportdata', 'json', 'jqxGrid');

            // });

        

		});

    </script>

</head>



<body class='default' >

    <div id='grid'>

        <div id="faq"></div>



    </div>

	

	<div id='jqxWidget' style="font-size: 13px; font-family: Verdana; float: left;">

        <div style="float: left;" id="faq">

        </div>

       

    </div>

	

	

</body>



</html>

