<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require_once 'conexion/Conexion.php';
class Config extends Conexion {

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt))
            $stmt->closeCursor();
    }

    public function get_config($data)
    {
        try {
            $sql = 'SELECT 
                   *
                FROM
                    configuracion_sistema';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();
            
            $config = $stmt->fetch(PDO::FETCH_ASSOC);

            $sql = 'SELECT 
                   id, clave, descripcion, fisica, moral, regimenFiscalReceptor
                FROM
                    uso_cfdi';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $usos_cfdi = array();
            while ($uso_cfdi = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $usos_cfdi[] = $uso_cfdi;
            }

            $sql = 'SELECT 
                   id, clave, descripcion, fisica, moral, fecha_inicio_vigencia, fecha_fin_de_vigencia
                FROM
                    regimenes_fiscales';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $regimenes_fiscales = array();
            while ($regimen_fiscal = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $regimenes_fiscales[] = $regimen_fiscal;
            }
			
            $sql = 'SELECT 
                   *
                FROM
                    c_usocfdi';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_usocfdi = array();
            while ($usocfdi = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_usocfdi[] = $usocfdi;
            }

            $sql = 'SELECT 
                   *
                FROM
                    c_formapago';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_formapago = array();
            while ($formapago = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_formapago[] = $formapago;
            }
            
            echo json_encode(array('status'=> TRUE, 'config' => $config, 'regimenesFiscales' => $regimenes_fiscales, 'usosCFDI' => $usos_cfdi, 'c_usocfdi' => $c_usocfdi, 'c_formapago' => $c_formapago));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al obtener la configuración', 'error' => $e->getMessage(), 'line' => $e->getLine()));
            die();
        }
    }

    public function get_catalogos_facturar($usuario)
    {
        try {
            /*$sql = 'SELECT 
                        id, rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario, fecha_insercion, fecha_modificacion, regimen_fiscal
                    FROM
                        datos_facturacion
                    WHERE 
                        usuario = :usuario
                    ';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute(array( ':usuario' => $usuario ));

            $dataUsuario = $stmt->fetch(PDO::FETCH_ASSOC);
            
            /*$condicionMoralFisica = '';
            if (strlen($dataUsuario['rfc']) === 12) {
                $condicionMoralFisica = ' AND moral = 1';
            } else if (strlen($dataUsuario['rfc']) === 13) {
                $condicionMoralFisica = ' AND fisica = 1';
            }
            
            $sql = 'SELECT 
						id, clave, descripcion, fisica, moral, regimenFiscalReceptor, Estatus
                    FROM
                        uso_cfdi
                    WHERE 
                        Estatus = "Activo"
                    ';

            $sql .= $condicionMoralFisica; 

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_usocfdi = array();
            while ($usocfdi = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_usocfdi[] = $usocfdi;
            }*/
			

            $sql = 'SELECT 
                   *
                FROM
                    c_formapago
                WHERE 
                    Estatus = "Activo"
                ';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_formapago = array();
            while ($formapago = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_formapago[] = $formapago;
            }
            
            // echo json_encode(array('status'=> TRUE,'c_usocfdi' => $c_usocfdi, 'c_formapago' => $c_formapago));
            echo json_encode(array('status'=> TRUE, 'c_formapago' => $c_formapago));

        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al obtener formas de pago', 'error' => $e->getMessage(), 'line' => $e->getLine()));
            die();
        }
    }
	
	public function getRegimenesFiscales($rfc)
    {
        try {
            
            $condicionMoralFisica = '';
			
			if (strlen($rfc) <= 12) {
                $condicionMoralFisica = " AND moral = '1'";
            } else if (strlen($rfc) === 13) {
                $condicionMoralFisica = " AND fisica = '1'";
            }
            
			$fechaHoy = date("Y-m-d");
			$sql = "SELECT 
						id, clave, descripcion, fisica, moral, fecha_inicio_vigencia, fecha_fin_de_vigencia
                    FROM
                        regimenes_fiscales
                    WHERE 
						fecha_inicio_vigencia <= '".$fechaHoy."' and ifnull(fecha_fin_de_vigencia,current_timestamp) >= '".$fechaHoy."' ".$condicionMoralFisica;

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_regimenFiscal = array();
            while ($rf = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_regimenFiscal[] = $rf;
            }
			
            echo json_encode(array('status'=> TRUE, 'c_regimenFiscal' => $c_regimenFiscal));

        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al obtener los régimenes fiscales', 'error' => $e->getMessage(), 'line' => $e->getLine()));
            die();
        }
    }
	
	public function getUsoCFDI($usuario)
    {
        try {
			
			$sql = 'SELECT 
                        id, rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario, fecha_insercion, fecha_modificacion, regimen_fiscal
                    FROM
                        datos_facturacion
                    WHERE 
                        usuario = :usuario
                    ';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute(array( ':usuario' => $usuario ));

            $dataUsuario = $stmt->fetch(PDO::FETCH_ASSOC);
			// print_r($dataUsuario);exit;
			
			
			$fechaHoy = date("Y-m-d");
			$sql = "SELECT 
						count(*) as numReg
                    FROM
                        regimenes_fiscales
                    WHERE 
						fecha_inicio_vigencia <= '".$fechaHoy."' and ifnull(fecha_fin_de_vigencia,current_timestamp) >= '".$fechaHoy."' and clave = '".$dataUsuario["regimen_fiscal"]."'";

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();
			
			$regimenFiscalValido = $stmt->fetch(PDO::FETCH_ASSOC);

            if($regimenFiscalValido["numReg"] == 0){
				throw new Exception("Régimen fiscal inválido", 300);
			}
			
			$sql = "SELECT 
						id, clave, descripcion, fisica, moral, regimenFiscalReceptor, Estatus
                    FROM
                        uso_cfdi
                    WHERE 
						Estatus = 'Activo' and regimenFiscalReceptor like '%".$dataUsuario["regimen_fiscal"]."%'";

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_usocfdi = array();
            while ($uc = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_usocfdi[] = $uc;
            }

            echo json_encode(array('status'=> TRUE, 'c_usoCFDI' => $c_usocfdi));

        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al obtener los usos de cfdi, indique su régimen fiscal nuevamente de sus datos de facturación', 'error' => $e->getMessage(), 'line' => $e->getLine()));
            die();
        }
    }
	
	public function getUsoCFDIConfig()
    {
        try {
			
			
			$sql = "SELECT 
						id, clave, descripcion, fisica, moral, regimenFiscalReceptor, Estatus
                    FROM
                        uso_cfdi";

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $c_usocfdi = array();
            while ($uc = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $c_usocfdi[] = $uc;
            }

            echo json_encode(array('status'=> TRUE, 'c_usoCFDI' => $c_usocfdi));

        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al obtener los usos de cfdi', 'error' => $e->getMessage(), 'line' => $e->getLine()));
            die();
        }
    }
	

    public function valida_rfc1($valor){
        $valor = str_replace("-", "", $valor); 
        $cuartoValor = substr($valor, 3, 1);
        //RFC sin homoclave
        if(strlen($valor)==10){
            $letras = substr($valor, 0, 4); 
            $numeros = substr($valor, 4, 6);
            if (ctype_alpha($letras) && ctype_digit($numeros)) { 
                return true;
            }
            return false;          
        }
        // Sólo la homoclave
        /* else if (strlen($valor) == 3) {
            $homoclave = $valor;
            if(ctype_alnum($homoclave)){
                return true;
            }
            return false;
        } */
        //RFC Persona Moral.
        else if (ctype_digit($cuartoValor) && strlen($valor) == 12) { 
            $letras = substr($valor, 0, 3); 
            $numeros = substr($valor, 3, 6); 
            $homoclave = substr($valor, 9, 3); 
            if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
                return true; 
            } 
            return false;
        //RFC Persona Física. 
        } else if (ctype_alpha($cuartoValor) && strlen($valor) == 13) { 
            $letras = substr($valor, 0, 4); 
            $numeros = substr($valor, 4, 6);
            $homoclave = substr($valor, 10, 3); 
            if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
                return true; 
            }
            return false; 
        }else { 
            return false; 
        }  
    }//fin validaRFC

    public function set_config($data, $cFormaPago, $cUsoCFDI)
    {
		/*var_dump($cFormaPago); exit;
		var_dump($cUsoCFDI);exit;*/
		// var_dump($data);exit;
		
        // validar RFC
        if (!$this->valida_rfc1($data['datosEmisor']['RFC'])) {
            echo json_encode(array('status'=> FALSE, 'msg'=> 'Formato de RFC no válido'));
            die();
        }

        try {
            $sql = 'insert into configuracion_sistema (`serie`, `folio_siguiente`, `correo`, `tls`, `ssl`, puerto, smtp, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, RegimenFiscal, RFCEmisor, NombreEmisor, timbrado_cer, timbrado_cer_nombre, timbrado_cer_serie, timbrado_key_nombre, timbrado_key, timbrado_pass, timbrado_usuario, timbrado_password) value (:serie, 1, :correo, :tls, :ssl, :puerto, :smtp, :calle, :noExt, :noInt, :colonia, :codigoPostal, :municipio, :estado, :regimenFiscal, :RFCEmisor, :NombreEmisor, :timbrado_cer, :timbrado_cer_nombre, :timbrado_cer_serie, :timbrado_key_nombre, :timbrado_key, :timbrado_pass, :timbrado_usuario, :timbrado_password) ON DUPLICATE KEY UPDATE 
                        `serie` = :serie,
                        `correo` = :correo,
                        `tls` = :tls,
                        `ssl` = :ssl,
                        puerto = :puerto,
                        smtp = :smtp,
                        calle = :calle,
                        noExt = :noExt,
                        noInt = :noInt,
                        colonia = :colonia,
                        codigoPostal = :codigoPostal,
                        municipio = :municipio,
                        estado = :estado,
                        regimenFiscal = :regimenFiscal,
                        RFCEmisor = :RFCEmisor,
                        NombreEmisor = :NombreEmisor,
						timbrado_cer = :timbrado_cer,
						timbrado_cer_nombre = :timbrado_cer_nombre,
                        timbrado_cer_serie = :timbrado_cer_serie,
						timbrado_key_nombre = :timbrado_key_nombre,
						timbrado_key = :timbrado_key,
                        timbrado_pass = :timbrado_pass,
                        timbrado_usuario = :timbrado_usuario,
                        timbrado_password = :timbrado_password';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array ( 
                ':serie' => $data['foliador']['serie'],
                ':correo' => $data['correoSalida']['correo'],
                ':tls' => strtoupper($data['correoSalida']['TLS']),
                ':ssl' => strtoupper($data['correoSalida']['SSL']),
                ':puerto' => $data['correoSalida']['puerto'],
                ':smtp' => $data['correoSalida']['SMTP'],
                ':calle' => $data['datosEmisor']['calle'],
                ':noExt' => $data['datosEmisor']['noExt'],
                ':noInt' => $data['datosEmisor']['noInt'],
                ':colonia' => $data['datosEmisor']['colonia'],
                ':codigoPostal' => $data['datosEmisor']['CP'],
                ':municipio' => $data['datosEmisor']['municipio'],
                ':estado' => $data['datosEmisor']['estado'],
                ':regimenFiscal' => $data['datosEmisor']['regimenFiscal'],
                ':RFCEmisor' => $data['datosEmisor']['RFC'],
                ':NombreEmisor' => $data['datosEmisor']['razonSocial'],
                ':timbrado_cer' => $data['timbrado']['timbrado_cer'],
                ':timbrado_cer_nombre' => $data['datosEmisor']['RFC'].".cer",
                ':timbrado_cer_serie' => $data['timbrado']['timbrado_cer_serie'],
				':timbrado_key_nombre' => $data['datosEmisor']['RFC'].".key",
				':timbrado_key' => $data['timbrado']['timbrado_key'],
                ':timbrado_pass' => $data['timbrado']['timbrado_pass'],
                ':timbrado_usuario' => $data['timbrado']['timbrado_usuario'],
                ':timbrado_password' => $data['timbrado']['timbrado_password']));
				
				if($stmt->errorCode() != 0){
					$error = $stmt->errorInfo();
					echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar la configuración', 'error' => $error[2]));
					die();
				}
			
            $sql = '
                    UPDATE 
                        c_formapago
                    SET 
                        Estatus = "Activo"
                    WHERE
                        c_FormaPago IN (';

            $i = 0;
            $datos = '';
            foreach($cFormaPago as $key => $value) {
                $datos .= "'$value'";
                $i++;
                if ($i < sizeof( $cFormaPago)) {
                    $datos .= ',';
                }
            }
            $sql .= $datos . ')';
			
			
            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            $sql = '
                    UPDATE 
                        c_formapago
                    SET 
                        Estatus = "Inactivo"
                    WHERE
                        c_FormaPago NOT IN ('.$datos.')';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

			$sql = '
                    UPDATE 
                        uso_cfdi
                    SET 
                        Estatus = "Activo"
                    WHERE
                        clave IN (';

            $i = 0;
            $datos = '';
            foreach($cUsoCFDI as $key => $value) {
                $datos .= "'$value'";
                $i++;
                if ($i < sizeof( $cUsoCFDI)) {
                    $datos .= ',';
                }
            }
            $sql .= $datos . ')';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();
			
			$sql = '
                    UPDATE 
                        uso_cfdi
                    SET 
                        Estatus = "Inactivo"
                    WHERE
                        clave NOT IN ('.$datos.')';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Configuración actualizada'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar la configuración', 'error' => $e->getMessage()));
            die();
        }
    }
	
	public function set_config_old($data, $cFormaPago, $cUsoCFDI)
    {
		/*var_dump($cFormaPago); exit;
		var_dump($cUsoCFDI);exit;*/
		// var_dump($data);exit;
		
        // validar RFC
        if (!$this->valida_rfc1($data['datosEmisor']['RFC'])) {
            echo json_encode(array('status'=> FALSE, 'msg'=> 'Formato de RFC no válido'));
            die();
        }

        try {
            $sql = 'insert into configuracion_sistema (`serie`, `folio_siguiente`, `correo`, `pass`, `tls`, `ssl`, puerto, smtp, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, RegimenFiscal, RFCEmisor, NombreEmisor, timbrado_cer, timbrado_cer_nombre, timbrado_cer_serie, timbrado_key_nombre, timbrado_key, timbrado_pass, timbrado_usuario, timbrado_password) value (:serie, 1, :correo, :pass, :tls, :ssl, :puerto, :smtp, :calle, :noExt, :noInt, :colonia, :codigoPostal, :municipio, :estado, :regimenFiscal, :RFCEmisor, :NombreEmisor, :timbrado_cer, :timbrado_cer_nombre, :timbrado_cer_serie, :timbrado_key_nombre, :timbrado_key, :timbrado_pass, :timbrado_usuario, :timbrado_password) ON DUPLICATE KEY UPDATE 
                        `serie` = :serie,
                        `correo` = :correo,
                        `pass` = :pass,
                        `tls` = :tls,
                        `ssl` = :ssl,
                        puerto = :puerto,
                        smtp = :smtp,
                        calle = :calle,
                        noExt = :noExt,
                        noInt = :noInt,
                        colonia = :colonia,
                        codigoPostal = :codigoPostal,
                        municipio = :municipio,
                        estado = :estado,
                        regimenFiscal = :regimenFiscal,
                        RFCEmisor = :RFCEmisor,
                        NombreEmisor = :NombreEmisor,
						timbrado_cer = :timbrado_cer,
						timbrado_cer_nombre = :timbrado_cer_nombre,
                        timbrado_cer_serie = :timbrado_cer_serie,
						timbrado_key_nombre = :timbrado_key_nombre,
						timbrado_key = :timbrado_key,
                        timbrado_pass = :timbrado_pass,
                        timbrado_usuario = :timbrado_usuario,
                        timbrado_password = :timbrado_password';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array ( 
                ':serie' => $data['foliador']['serie'],
                ':correo' => $data['correoSalida']['correo'],
                ':pass' => $this->Encripta($data['correoSalida']['contra']),
                ':tls' => strtoupper($data['correoSalida']['TLS']),
                ':ssl' => strtoupper($data['correoSalida']['SSL']),
                ':puerto' => $data['correoSalida']['puerto'],
                ':smtp' => $data['correoSalida']['SMTP'],
                ':calle' => $data['datosEmisor']['calle'],
                ':noExt' => $data['datosEmisor']['noExt'],
                ':noInt' => $data['datosEmisor']['noInt'],
                ':colonia' => $data['datosEmisor']['colonia'],
                ':codigoPostal' => $data['datosEmisor']['CP'],
                ':municipio' => $data['datosEmisor']['municipio'],
                ':estado' => $data['datosEmisor']['estado'],
                ':regimenFiscal' => $data['datosEmisor']['regimenFiscal'],
                ':RFCEmisor' => $data['datosEmisor']['RFC'],
                ':NombreEmisor' => $data['datosEmisor']['razonSocial'],
                ':timbrado_cer' => $data['timbrado']['timbrado_cer'],
                ':timbrado_cer_nombre' => $data['datosEmisor']['RFC'].".cer",
                ':timbrado_cer_serie' => $data['timbrado']['timbrado_cer_serie'],
				':timbrado_key_nombre' => $data['datosEmisor']['RFC'].".key",
				':timbrado_key' => $data['timbrado']['timbrado_key'],
                ':timbrado_pass' => $data['timbrado']['timbrado_pass'],
                ':timbrado_usuario' => $data['timbrado']['timbrado_usuario'],
                ':timbrado_password' => $data['timbrado']['timbrado_password']));
				
				if($stmt->errorCode() != 0){
					$error = $stmt->errorInfo();
					echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar la configuración', 'error' => $error[2]));
					die();
				}

				// if($stmt->rowCount() == 0){
					// echo json_encode(array('status'=> FALSE, 'msg' => 'No se inserto la configuración', 'error' => 'Desconocido'));
					// die();
				// }
           
				// $stmt->conexion_db->lastInsertId();
				
            // Forma de Pago
			/*$stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array ( 
                ':serie' => $data['foliador']['serie'],
                ':correo' => $data['correoSalida']['correo'],
                ':pass' => $this->Encripta($data['correoSalida']['contra']),
                ':tls' => strtoupper($data['correoSalida']['TLS']),
                ':ssl' => strtoupper($data['correoSalida']['SSL']),
                ':puerto' => $data['correoSalida']['puerto'],
                ':smtp' => $data['correoSalida']['SMTP'],
                ':calle' => $data['datosEmisor']['calle'],
                ':noExt' => $data['datosEmisor']['noExt'],
                ':noInt' => $data['datosEmisor']['noInt'],
                ':colonia' => $data['datosEmisor']['colonia'],
                ':codigoPostal' => $data['datosEmisor']['CP'],
                ':municipio' => $data['datosEmisor']['municipio'],
                ':estado' => $data['datosEmisor']['estado'],
                ':regimenFiscal' => $data['datosEmisor']['regimenFiscal'],
                'RFCEmisor' => $data['datosEmisor']['RFC'],
                'NombreEmisor' => $data['datosEmisor']['razonSocial'],
                'timbrado_cer' => $data['timbrado']['timbrado_cer'],
                'timbrado_key' => $data['timbrado']['timbrado_key'],
                'timbrado_cer_serie' => $data['timbrado']['timbrado_cer_serie'],
                'timbrado_pass' => $data['timbrado']['timbrado_pass'],
                'timbrado_usuario' => $data['timbrado']['timbrado_usuario'],
                'timbrado_password' => $data['timbrado']['timbrado_password']));*/
			
            $sql = '
                    UPDATE 
                        c_formapago
                    SET 
                        Estatus = "Activo"
                    WHERE
                        c_FormaPago IN (';

            $i = 0;
            $datos = '';
            foreach($cFormaPago as $key => $value) {
                $datos .= "'$value'";
                $i++;
                if ($i < sizeof( $cFormaPago)) {
                    $datos .= ',';
                }
            }
            $sql .= $datos . ')';
			
			
            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();
			
			
			// $sql = 'call sp_i_';

            // $sql = '
                    // UPDATE 
                        // c_formapago
                    // SET 
                        // Estatus = "Inactivo"
                    // WHERE
                        // c_FormaPago NOT IN ('.$datos.')';

            // $stmt = $this->conexion_db->prepare($sql);
            // $stmt->execute();

            // UsoCFDI

            // $sql = '
                    // UPDATE 
                        // c_usocfdi
                    // SET 
                        // Estatus = "Activo"
                    // WHERE
                        // c_UsoCFDI IN (';
			$sql = '
                    UPDATE 
                        uso_cfdi
                    SET 
                        Estatus = "Activo"
                    WHERE
                        clave IN (';

            $i = 0;
            $datos = '';
            foreach($cUsoCFDI as $key => $value) {
                $datos .= "'$value'";
                $i++;
                if ($i < sizeof( $cUsoCFDI)) {
                    $datos .= ',';
                }
            }
            $sql .= $datos . ')';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();

            // $sql = '
                    // UPDATE 
                        // c_usocfdi
                    // SET 
                        // Estatus = "Inactivo"
                    // WHERE
                        // c_UsoCFDI NOT IN ('.$datos.')';
			
			$sql = '
                    UPDATE 
                        uso_cfdi
                    SET 
                        Estatus = "Inactivo"
                    WHERE
                        clave NOT IN ('.$datos.')';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute();
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Configuración actualizada'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar la configuración', 'error' => $e->getMessage()));
            die();
        }
    }

    public function save_files(){

        $cer64 = base64_encode(file_get_contents(addslashes($_FILES['fileCer']['tmp_name'])));
        $key64 = base64_encode(file_get_contents(addslashes($_FILES['fileKey']['tmp_name'])));

        try {
            $sql = 'UPDATE 
                        configuracion_sistema
                    SET 
                        timbrado_cer = :timbrado_cer,
                        timbrado_cer_nombre = :timbrado_cer_nombre,
                        timbrado_key = :timbrado_key,
                        timbrado_key_nombre = :timbrado_key_nombre';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array ( 
                'timbrado_cer' => $cer64,
                'timbrado_cer_nombre' => $_FILES['fileCer']['name'],
                'timbrado_key' => $key64,
                'timbrado_key_nombre' => $_FILES['fileKey']['name']));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Archivos guardados'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al guardar los archivos', 'error' => $e->getMessage()));
            die();
        }
    }

    public function Encripta($cadena, $tipo = 0){
        $salida = "";
        if ($tipo === 0) {
            $cadInv = strrev(str_replace(" ", "--SPACE--", $cadena));
            for($i=0; $i < strlen($cadInv); $i++) {
                    $asc = ord($cadInv[$i]);
                    $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));
                }
            $salida = base64_encode($salida);
        } else {
            $cadInv = base64_decode($cadena);
            for($i=0; $i < strlen($cadInv); $i++) {
                $asc = ord($cadInv[$i]);
                $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));            
            }
            $salida = str_replace("--SPACE--"," ",strrev($salida));
        }
        return $salida;
    }

}

if (isset($_POST['method'])) {
    $objConfig = new Config();
    if ($_POST['method'] === 'save_files'){
		$objConfig->save_files();
	}
	if ($_POST['method'] === 'get_catalogos_facturar'){
		$objConfig->get_catalogos_facturar($_POST['username']);
	}
	if ($_POST['method'] === 'getRegimenesFiscales'){
		$objConfig->getRegimenesFiscales($_POST['rfc']);
	}
            
    die();
} else {
    $data = json_decode(file_get_contents("php://input"), true);
    $objConfig = new Config();
	if(isset($data['method'])){
		if ($data['method'] === 'get_config') {
			$objConfig->get_config($data);
		} else if ($data['method'] === 'set_config') {
			$objConfig->set_config($data['config'], $data['cFormaPago'], $data['cUsoCFDI']);
		} else if ($data['method'] === 'save_files') {
			$objConfig->save_files($data);
		} else if ($data['method'] === 'get_catalogos_facturar') {
			$objConfig->get_catalogos_facturar($data['username']);
		} else if ($data['method'] === 'getUsoCFDI') {
			$objConfig->getUsoCFDI($data['username']);
		} else if ($data['method'] === 'getUsoCFDIConfig') {
			$objConfig->getUsoCFDIConfig();
		} else if ($data['method'] === 'getRegimenesFiscales') {
			$objConfig->getRegimenesFiscales($data['rfc']);
		} 
	}
    
}
?>