﻿<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require 'conexion/Conexion.php';
Class DisXIIWS extends Conexion{
	public $ERROR_NO = 0;
	public $MENSAJE_ERROR = "";
	public $RESPONSE = "";
	public $CODEHTTP = "";
	protected $USUARIOWS;
	protected $PASSWORDWS;
	protected $TIPO_TIMBRADO;

	public $xml;
	public $cer64;
	public $key64;
	public $keyPass;
	public $usuario;
	public $password;

	public $usuarioPortal;

	public $idticket;
	public $rfcemisor;
	public $serie;
	public $folio;
	public $rfcreceptor;
	public $nombrereceptor;
	public $regimen_fiscal;

	public $direccionreceptor;
	public $DomicilioFiscalReceptor;
	public $RegimenFiscalReceptor;
	

	public $configuracion_sistema;
	public $datos_facturacion;
	public $ticket;

	public $fechaFactura;
	
	// datos comerciales
	public $lugarEntrega_nombre;
	public $lugarEntrega_calle;
	public $lugarEntrega_noExterior;
	public $lugarEntrega_noInterior;
	public $lugarEntrega_colonia;
	public $lugarEntrega_localidad;
	public $lugarEntrega_referencia;
	public $lugarEntrega_municipio;
	public $lugarEntrega_estado;
	public $lugarEntrega_pais;
	public $lugarEntrega_codigoPostal;
	public $otros_po;
	public $totales_totalLetra;

	public $conceptos;

	public $uso_cfdi;
	public $forma_pago;

	// datos doce
	
	// public $RFC_Emisor; 
	public $TipoDocto;
	// public $Serie;
	// public $Folio;
	// public $RFC_Receptor;
	// public $NombreReceptor;
	// public $Fecha;
	public $IVA;
	public $Total;
	public $lcStatus;
	public $lcTipoComprobante;
	public $ArchPDF;
	public $ArchXML;
	public $FiltroA;
	public $FiltroB;
	public $FiltroC;
	public $EmailReenvio;
	public $UUID;
	public $Moneda;
	public $TipoCambio;
	public $MetodoPag;
	
	public $err_query;
	public $err_correo = FALSE;

	function __construct($TipoTimbrado) {
		parent::__construct();

		switch($TipoTimbrado){
			case "T": 
						$this->wsdl="https://www.dis12.com/ws/timbrado/t/cfdi3.3/wsSellaTimbra.php";
						$this->wsdlCancela="https://www.dis12.com/ws/timbrado/t/cfdi3.3/wscancelar3_3swrest.php";
						$this->USUARIOWS = "disxii";
						$this->PASSWORDWS = "DisXIIwsSellaTimbra";
						$this->TIPO_TIMBRADO = "T";
						break;
			case "P": 
						$this->wsdl="https://www.dis12.com/ws/timbrado/p/cfdi3.3/wsSellaTimbra.php";
						$this->wsdlCancela="https://www.dis12.com/ws/timbrado/p/cfdi3.3/wscancelar3_3swrest.php";
						$this->USUARIOWS = "disxii";
						$this->PASSWORDWS = "D1sXIIws5ella7imbra";
						break;
			default: 
						$this->ERROR_NO=100;
						$this->MENSAJE_ERROR="Especifique el tipo de timbrado. Pruebas o productivo.";
		}
	}
	
	function wsSellaTimbra($xml, $cer, $key, $passKey, $usuario, $password){
		try{

			if ($this->TIPO_TIMBRADO === 'T') {
				$usuario = 'demo';
				$password = 'demo';
			}

			$data = '{
				"usuarioWS" : "'.$this->USUARIOWS.'",
				"passwordWS" : "'.$this->PASSWORDWS.'",
				"usuarioTimbrado" : "'.$usuario.'",
				"passwordTimbrado" : "'.$password.'",
				"xmlB64" : "'.$xml.'",
				"cerB64" : "'.$cer.'",
				"keyB64" : "'.$key.'",
				"passKey" : "'.$passKey.'"
			}'; 
			
			// file_put_contents("json.txt",$data);exit;

			$curl  = curl_init($this->wsdl);
			curl_setopt($curl , CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl , CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl , CURLOPT_HTTPHEADER , array(
				'Content-Type: application/json'
				));  
			curl_setopt($curl , CURLOPT_POSTFIELDS, $data);

			$response = curl_exec($curl);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$err = curl_error($curl );
			curl_close($curl );

			if($err) 
			{
				$this->CODEHTTP=-1;
				throw new Exception("cURL Error #:" . $err);
			}else{
				$this->CODEHTTP = $httpcode;
				$this->ERROR_NO = 0;
				$this->MENSAJE_ERROR = "";
				$this->RESPONSE = $response;
			}
			return true;
		}catch(Exception $e){
			$this->ERROR_NO=300;
			$this->MENSAJE_ERROR="Exception: ".$e->getMessage();
			return false;
		}
	}
	
	function wsCancela($uuid,$rfcemisor,$rfcreceptor,$total,$cer,$key,$passKey,$usuario,$password) {
		try{
			if($this->TIPO_TIMBRADO == "T") {
				$usuario = "demo";
				$password = "demo";
			}
			$data = '{
				"usuario" : "' . $usuario . '",
				"password" : "' . $password . '",
				"uuid" : "' . $uuid . '",
				"rfcemisor" : "' . $rfcemisor . '",
				"rfcreceptor" : "' . $rfcreceptor . '",
				"total" : "' . $total . '",
				"cer" : "' . $cer . '",
				"keyCER" : "' . $key . '",
				"passCER" : "' . $passKey . '"
			}'; 
			
			$curl  = curl_init($this->wsdlCancela);
			curl_setopt($curl , CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl , CURLOPT_POST, true);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($curl , CURLOPT_HTTPHEADER , array(
				'Content-Type: application/json'
				));  
			curl_setopt($curl , CURLOPT_POSTFIELDS, $data);

			$response = curl_exec($curl);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$err = curl_error($curl );
			curl_close($curl );
			if($err) 
			{
				$this->CODEHTTP=-1;
				throw new Exception("cURL Error #:" . $err);
			} else if($httpcode!='200') {
				$this->CODEHTTP=$httpcode;
				$this->RESPONSE = $response;
			}else{
				$this->CODEHTTP = $httpcode;
				$this->ERROR_NO = 0;
				$this->MENSAJE_ERROR = "";
				$this->RESPONSE = $response;
			}
			return true;
		}catch(Exception $e){
			$this->ERROR_NO=300;
			$this->MENSAJE_ERROR="Exception: ".$e->getMessage();
			return false;
		}
	}

	function createXML() {
		// get template
		/* if (file_exists('SinSello64.xml')) {
			// $xml = simplexml_load_file('SinSello64.xml');
			// $fp = fopen('SinSello64.xml', 'r');
			$this->xml = file_get_contents('SinSello64.xml');
			// var_dump($fileContent);
		} else {
			exit('Error abriendo SinSello64.xml.');
		} */

		// * get timbrado config
		try {
			$sql = 'SELECT 
						*
					FROM
						configuracion_sistema';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute();

			$configs = array();
			while ($config = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$configs[] = $config;
			}

			$this->cer64 = $configs[0]['timbrado_cer'];
			$this->key64 = $configs[0]['timbrado_key'];
			$this->keyPass = $configs[0]['timbrado_pass'];
			$this->usuario = $configs[0]['timbrado_usuario'];
			$this->password = $configs[0]['timbrado_password'];

		} catch (Exception $e) {
			echo json_encode(array('status'=> FALSE, 'msg' => 'Error al leer configuración', 'error' => $e->getMessage()));
			die();
		}
	}
    
    
	function GetGMT()
	{
	//   https://stackoverflow.com/questions/16592142/retrieve-time-from-ntp-server-via-php 

	$server_time_formatted = "";
	$bit_max = 4294967296;
	$epoch_convert = 2208988800;
	$vn = 3;

	$servers = array('cronos.cenam.mx','time.nist.gov','time.google.com','1.mx.pool.ntp.org','3.uk.pool.ntp.org');
	$server_count = count($servers);

	//see rfc5905, page 20
	//first byte
	//LI (leap indicator), a 2-bit integer. 00 for 'no warning'
	$header = '00';
	//VN (version number), a 3-bit integer.  011 for version 3
	$header .= sprintf('%03d',decbin($vn));
	//Mode (association mode), a 3-bit integer. 011 for 'client'
	$header .= '011';

	//echo bindec($header);    

	//construct the packet header, byte 1
	$request_packet = chr(bindec($header));

	//we'll use a for loop to try additional servers should one fail to respond
	$i = 0;
	for($i; $i < $server_count; $i++) {
		$socket = @fsockopen('udp://'.$servers[$i], 123, $err_no, $err_str,1);
		if ($socket) {

		//add nulls to position 11 (the transmit timestamp, later to be returned as originate)
		//10 lots of 32 bits
		for ($j=1; $j<40; $j++) {
			$request_packet .= chr(0x0);
		}

		//the time our packet is sent from our server (returns a string in the form 'msec sec')
		$local_sent_explode = explode(' ',microtime());
		$local_sent = $local_sent_explode[1] + $local_sent_explode[0];

		//add 70 years to convert unix to ntp epoch
		$originate_seconds = $local_sent_explode[1] + $epoch_convert;

		//convert the float given by microtime to a fraction of 32 bits
		$originate_fractional = round($local_sent_explode[0] * $bit_max);

		//pad fractional seconds to 32-bit length
		$originate_fractional = sprintf('%010d',$originate_fractional);

		//pack to big endian binary string
		$packed_seconds = pack('N', $originate_seconds);
		$packed_fractional = pack("N", $originate_fractional);

		//add the packed transmit timestamp
		$request_packet .= $packed_seconds;
		$request_packet .= $packed_fractional;

		if (fwrite($socket, $request_packet)) {
			$data = NULL;
			stream_set_timeout($socket, 1);

			$response = fread($socket, 48);

			//the time the response was received
			$local_received = microtime(true);

			//echo 'response was: '.strlen($response).$response;
		}
		fclose($socket);

		if (strlen($response) == 48) {
			//the response was of the right length, assume it's valid and break out of the loop
			break;
		}
		else {
			if ($i == $server_count-1) {
			//this was the last server on the list, so give up
			// die('unable to establish a connection');
			return '';
			}
		}
		}
		else {
		if ($i == $server_count-1) {
			//this was the last server on the list, so give up
			// die('unable to establish a connection');
			return '';
		}
		}
	}

	//unpack the response to unsiged lonng for calculations
	$unpack0 = unpack("N12", $response);
	//print_r($unpack0);

	//present as a decimal number
	$remote_originate_seconds = sprintf('%u', $unpack0[7])-$epoch_convert;
	$remote_received_seconds = sprintf('%u', $unpack0[9])-$epoch_convert;
	$remote_transmitted_seconds = sprintf('%u', $unpack0[11])-$epoch_convert;

	$remote_originate_fraction = sprintf('%u', $unpack0[8]) / $bit_max;
	$remote_received_fraction = sprintf('%u', $unpack0[10]) / $bit_max;
	$remote_transmitted_fraction = sprintf('%u', $unpack0[12]) / $bit_max;

	$remote_originate = $remote_originate_seconds + $remote_originate_fraction;
	$remote_received = $remote_received_seconds + $remote_received_fraction;
	$remote_transmitted = $remote_transmitted_seconds + $remote_transmitted_fraction;
	//unpack to ascii characters for the header response
	$unpack1 = unpack("C12", $response);
	//print_r($unpack1);

	//echo 'byte 1: ' . $unpack1[1] . ' | ';

	//the header response in binary (base 2)
	$header_response =  base_convert($unpack1[1], 10, 2);

	//pad with zeros to 1 byte (8 bits)
	$header_response = sprintf('%08d',$header_response);

	//Mode (the last 3 bits of the first byte), converting to decimal for humans;
	$mode_response = bindec(substr($header_response, -3));

	//VN
	$vn_response = bindec(substr($header_response, -6, 3));

	//the header stratum response in binary (base 2)
	$stratum_response =  base_convert($unpack1[2], 10, 2);
	$stratum_response = bindec($stratum_response);
	//echo 'stratum: ' . bindec($stratum_response);

	//calculations assume a symmetrical delay, fixed point would give more accuracy
	$delay = (($local_received - $local_sent) / 2)  - ($remote_transmitted - $remote_received);
	$delay_ms = round($delay * 1000) . ' ms';
	//echo 'delay: ' . $delay * 1000 . 'ms';

	$server = $servers[$i];  // Aqui tengo el server que contestó correctamente, se intentan de manera secuencial. 

	$ntp_time =  $remote_transmitted - $delay;
	$ntp_time_explode = explode('.',$ntp_time);

	$ntp_time_formatted = date('Y-m-d H:i:s', $ntp_time_explode[0]).'.'.$ntp_time_explode[1];

	return '['.$server.'|'.str_replace(' ','T',substr($ntp_time_formatted, 0, 19)).']';
	}

	function ExtractString($str, $from, $to)
	{
		$sub = substr($str, strpos($str,$from)+strlen($from),strlen($str));
		return substr($sub,0,strpos($sub,$to));
	}

	function validar_ticket($data) {
		try { 
			$sql = 'SELECT 
						ticket.FormaPago,
						ticket.Total,
						ticket.usocfdi,
						ticket.Status,
						ticket.IDTicket,
						ticket.MetodoPago,
						uso_cfdi.Descripcion as DescripcionCFDI,
						c_formapago.Descripcion as DescripcionFormaPago
					FROM
						ticket JOIN uso_cfdi ON 
						ticket.usocfdi = uso_cfdi.clave
						JOIN c_formapago ON
						ticket.FormaPago = c_formapago.c_FormaPago
					WHERE
						WebID = :WebID
					AND 
						IDTicket = :IDTicket';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':WebID' => $data['webID'], ':IDTicket' => $data['noTicket']));
			
			$ticket = $stmt->fetch(PDO::FETCH_ASSOC);

			if ( ! $ticket) {
				echo json_encode(array('status'=> FALSE, 'msg' => 'No se encontraron registros con el WebID o IDTicket agregado'));
				die();
			} 
			if ( $ticket['Status'] === 'Facturado') {
				echo json_encode(array('status'=> FALSE, 'msg' => 'El ticket ' . $ticket['IDTicket'] . ' ya se ha facturado anteriormente. Puede visualizarlo en el módulo de consulta'));
				die();
			}

			$sql = 'SELECT 
						id, rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario, fecha_insercion, fecha_modificacion, regimen_fiscal
					FROM
						datos_facturacion
					WHERE
						usuario = :usuario';


			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':usuario' => $data['usuario']));

			$dataF = $stmt->fetch(PDO::FETCH_ASSOC);
			$ticket['rfc'] = $dataF['rfc'];

			if ($dataF['taxID'] !== null) {
				$ticket['rfc'] .= ' - ' . $dataF['taxID'];
			}

			echo json_encode(array('status'=> TRUE, 'msg' => 'Encontrado', 'ticket' => $ticket));
			die();
		} catch (Exception $e) {
			echo json_encode(array('status'=> FALSE, 'msg' => 'Error al leer datos de ticket', 'error' => $e->getMessage(), 'line' => $e->getLine()));
			die();
		}
	}

	function getData($data) {
		// * get timbrado config
		try { 
			$sql = 'SELECT 
						*
					FROM
						ticket
					WHERE
						WebID = :WebID
					AND 
						IDTicket = :IDTicket';

			$stmt = $this->conexion_db->prepare($sql);
			// QVJX3A
			$stmt->execute(array (':WebID' => $data['webID'], ':IDTicket' => $data['noTicket']));

			$ticket = $stmt->fetch(PDO::FETCH_ASSOC);
			if ( ! $ticket) {
				echo json_encode(array('status'=> FALSE, 'msg' => 'No se encontraron registros con el WebID o IDTicket agregado'));
				die();
			}

			if ( $ticket['Status'] === 'Facturado') {
				echo json_encode(array('status'=> FALSE, 'msg' => 'El ticket ' . $ticket['IDTicket'] . ' ya se ha facturado anteriormente. Puede visualizarlo en el módulo de consulta'));
				die();
			}

			$this->uso_cfdi = $data['usoCFDI'];
			$this->forma_pago = $data['formaPago'];

			$this->ticket = $ticket;
			$this->idticket = $ticket['IDTicket'];

			// datos comerciales
			$this->lugarEntrega_nombre = $ticket['A_01'];
			$this->lugarEntrega_calle = $ticket['A_02'];
			$this->lugarEntrega_noExterior = $ticket['A_03'];
			$this->lugarEntrega_noInterior = $ticket['A_04'];
			$this->lugarEntrega_colonia = $ticket['A_05'];
			$this->lugarEntrega_localidad = $ticket['A_06'];
			$this->lugarEntrega_referencia = $ticket['A_07'];
			$this->lugarEntrega_municipio = $ticket['A_08'];
			$this->lugarEntrega_estado = $ticket['A_09'];
			$this->lugarEntrega_pais = $ticket['A_10'];
			$this->lugarEntrega_codigoPostal = $ticket['A_11'];
			$this->otros_po = $ticket['A_12'];
			$this->totales_totalLetra = $ticket['A_13'];

			// after validate it exists, get all general configuration. Then resume with the ticket nested data

			// * configuracion_sistema
			$sql = 'SELECT 
						*
					FROM
						configuracion_sistema';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute();

			$configuracion_sistema = $stmt->fetch(PDO::FETCH_ASSOC);
			$this->configuracion_sistema = $configuracion_sistema;

			// var_dump($configuracion_sistema);

			// * datos_facturacion
			$sql = 'SELECT 
						id, rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario, fecha_insercion, fecha_modificacion, regimen_fiscal
					FROM
						datos_facturacion
					WHERE
						usuario = :usuario';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':usuario' => $data['usuario']));

			$datos_facturacion = $stmt->fetch(PDO::FETCH_ASSOC);
			$this->datos_facturacion = $datos_facturacion;

			if ($datos_facturacion['rfc'] === '' OR $datos_facturacion['razonSocial'] === '') {
				echo json_encode(array('status'=>FALSE, 'msg'=> 'No se han agregado los datos de facturación del usuario'));
				die();
			}

			$this->rfcemisor = $configuracion_sistema['RFCEmisor'];
			/* $this->serie = $configuracion_sistema['serie'];
			$this->folio = $configuracion_sistema['folio_siguiente']; */
			$this->rfcreceptor = $datos_facturacion['rfc'];
			$this->nombrereceptor = $datos_facturacion['razonSocial'];
			$this->DomicilioFiscalReceptor = $datos_facturacion['codigoPostal'];
			$this->RegimenFiscalReceptor = $datos_facturacion['regimen_fiscal'];

			// * SERIES FOLIOS ASSA
			$this->serie = explode('/', $ticket['IDTicket'])[0];
			$this->folio = explode('/', $ticket['IDTicket'])[1];

			// var_dump($datos_facturacion);

			// *** XML

			$sql = "SELECT TipoImpuesto, Impuesto, TipoFactor, TasaOCuota,ROUND(sum(importe), 2) as nTTras, Base from concepto_impuestos where idTicket = :idTicket and tipoImpuesto='TRASLADO' group by TipoImpuesto, Impuesto, TipoFactor, TasaOCuota" ;

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':idTicket' => $data['noTicket']));

			$totalesTrasladados = array();
			$totalImpuestosTrasladados = -1.00;
			while ($totalTraslado = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$totalesTrasladados[] = $totalTraslado;
				if ($totalImpuestosTrasladados == -1.00) {
					$totalImpuestosTrasladados = 0.00;
				}
				$totalImpuestosTrasladados += $totalTraslado['nTTras'];
			}

			$sql = "SELECT TipoImpuesto, Impuesto, ROUND(sum(importe), 2) AS nTRet, Base from concepto_impuestos where idTicket = :idTicket and tipoImpuesto='RETENCION' group by TipoImpuesto, Impuesto";

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':idTicket' => $data['noTicket']));

			$totalesRetenciones = array();
			$totalImpuestosRetenciones = -1.00;
			while ($totalRetencion = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$totalesRetenciones[] = $totalRetencion;
				if ($totalImpuestosRetenciones == -1.00) {
					$totalImpuestosRetenciones = 0.00;
				}
				$totalImpuestosRetenciones += $totalRetencion['nTRet'];
			}
			
			$this->totalImpuestosTrasladados = $totalImpuestosTrasladados;
			$this->totalImpuestosRetenciones = $totalImpuestosRetenciones;
			/* echo $totalImpuestosTrasladados;
			echo $totalImpuestosRetenciones;
			die(); */

			date_default_timezone_set('America/Mexico_City');
			$sGMT = $this->GetGMT();
			$fecha = $this->ExtractString($sGMT,"|","]");
			$this->fechaFactura = $fecha;

			$dom = new DOMDocument('1.0', "UTF-8");
			$dom->encoding = 'utf-8';
			
			$domE = $dom->createElement('cfdi:Comprobante');
			
			$domA = $dom->createAttribute('xmlns:cfdi');
			$domA->value = 'http://www.sat.gob.mx/cfd/4';
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('xmlns:xsi');
			$domA->value = 'http://www.w3.org/2001/XMLSchema-instance';
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('xsi:schemaLocation');
			$domA->value = 'http://www.sat.gob.mx/cfd/4 http://www.sat.gob.mx/sitio_internet/cfd/4/cfdv40.xsd';
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Version');
			$domA->value = '4.0';
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Serie');
			$domA->value = htmlspecialchars($this->serie);
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Folio');
			$domA->value = htmlspecialchars($this->folio);
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Fecha');
			$domA->value = $fecha;
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Sello');
			$domA->value = '';
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('FormaPago');
			$domA->value = htmlspecialchars($this->forma_pago);
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('NoCertificado');
			$domA->value = htmlspecialchars($configuracion_sistema['timbrado_cer_serie']);
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Certificado');
			$domA->value = htmlspecialchars($configuracion_sistema['timbrado_cer']);
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('SubTotal');
			$domA->value = number_format($ticket['SubTotal'], 2,".","");
			$domE->appendChild($domA);
			
			$domA = $dom->createAttribute('Descuento');
			$domA->value = number_format($ticket['Descuento'], 2,".","");
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Moneda');
			$domA->value = htmlspecialchars($ticket['Moneda']);
			$domE->appendChild($domA);
			
			$domA = $dom->createAttribute('Exportacion');
			$domA->value = htmlspecialchars('01');
			$domE->appendChild($domA);

			if ($ticket['Moneda'] === 'MXN') {
				$this->TipoCambio = '1';
			} else {
				$this->TipoCambio = $ticket['TipoCambio'];
			}

			$domA = $dom->createAttribute('TipoCambio');
			$domA->value = $this->TipoCambio;
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('Total');
			$domA->value = number_format($ticket['Total'], 2,".","");
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('TipoDeComprobante');
			$domA->value = 'I';
			$domE->appendChild($domA);

			if ($this->forma_pago === '99') {
				$this->ticket['MetodoPago'] = 'PPD';
			} else {
				$this->ticket['MetodoPago'] = 'PUE';
			}

			$domA = $dom->createAttribute('MetodoPago');
			$domA->value =  htmlspecialchars($this->ticket['MetodoPago']);
			$domE->appendChild($domA);

			$domA = $dom->createAttribute('LugarExpedicion');
			$domA->value = $ticket['LugarExpedicion'];
			$domE->appendChild($domA);

			/* Emisor */
			
			$domEmisor = $dom->createElement('cfdi:Emisor');
			
			$domA = $dom->createAttribute('Rfc');
			$domA->value = htmlspecialchars($configuracion_sistema['RFCEmisor']);
			$domEmisor->appendChild($domA);

			$domA = $dom->createAttribute('Nombre');
			$domA->value = htmlspecialchars($configuracion_sistema['NombreEmisor']);
			$domEmisor->appendChild($domA);

			$domA = $dom->createAttribute('RegimenFiscal');
			$domA->value = htmlspecialchars($configuracion_sistema['RegimenFiscal']);
			$domEmisor->appendChild($domA);

			/* Receptor */

			$domReceptor = $dom->createElement('cfdi:Receptor');
			
			$domA = $dom->createAttribute('Rfc');
			$domA->value = htmlspecialchars($datos_facturacion['rfc']);
			$domReceptor->appendChild($domA);
			
			$domA = $dom->createAttribute('DomicilioFiscalReceptor');
			$domA->value = htmlspecialchars($datos_facturacion['codigoPostal']);
			$domReceptor->appendChild($domA);
			
			$domA = $dom->createAttribute('RegimenFiscalReceptor');
			$domA->value = htmlspecialchars($datos_facturacion['regimen_fiscal']);
			$domReceptor->appendChild($domA);
			
			$domA = $dom->createAttribute('Nombre');
			/* var_dump(htmlspecialchars($datos_facturacion['razonSocial']));
			die(); */
			$domA->value = htmlspecialchars($datos_facturacion['razonSocial']);
			$domReceptor->appendChild($domA);
			
			$domA = $dom->createAttribute('UsoCFDI');
			// $domA->value = htmlspecialchars($ticket['usocfdi']);
			$domA->value = htmlspecialchars($this->uso_cfdi);
			$domReceptor->appendChild($domA);

			$xml = '<?xml version="1.0" encoding="utf-8"?>
<cfdi:Comprobante';
			// var_dump($ticket);

			$sql = 'SELECT 
						idConcepto, IDTicket, ClaveProdServ, NoIdentificacion, Cantidad, ClaveUnidad, Unidad, Descripcion, ValorUnitario, Importe, Descuento, objetoImp
					FROM
						conceptos
					WHERE
						IDTicket = :IDTicket';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':IDTicket' => $ticket['IDTicket']));

			$conceptos = array();
			while ($concepto = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$conceptos[] = $concepto;
			}

			$this->conceptos = $conceptos;

			$domConceptos = $dom->createElement('cfdi:Conceptos');

			$total_traslados = array();
			$total_retenciones = array();
			
			foreach ($conceptos as $concepto) {
				$sql = 'SELECT 
							*
						FROM
							concepto_impuestos
						WHERE
							idConcepto = :idConcepto';

				$stmt = $this->conexion_db->prepare($sql);
				$stmt->execute(array (':idConcepto' => $concepto['idConcepto']));
				
				$conceptos_impuestos = array();
				while ($concepto_impuesto = $stmt->fetch(PDO::FETCH_ASSOC)) {
					$conceptos_impuestos[] = $concepto_impuesto;
				}

				$domConcepto = $dom->createElement('cfdi:Concepto');

				$domA = $dom->createAttribute('ClaveProdServ');
				$domA->value = htmlspecialchars($concepto['ClaveProdServ']);
				$domConcepto->appendChild($domA);

				$domA = $dom->createAttribute('NoIdentificacion');
				$domA->value = htmlspecialchars($concepto['NoIdentificacion']);
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('Cantidad');
				$domA->value = htmlspecialchars($concepto['Cantidad']);
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('ClaveUnidad');
				$domA->value = htmlspecialchars($concepto['ClaveUnidad']);
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('Unidad');
				$domA->value = htmlspecialchars($concepto['Unidad']);
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('Descripcion');
				$domA->value = htmlspecialchars($concepto['Descripcion']);
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('ValorUnitario');
				$domA->value = htmlspecialchars($concepto['ValorUnitario']);
				$domConcepto->appendChild($domA);

				$domA = $dom->createAttribute('Descuento');
				$domA->value = number_format($concepto['Descuento'], 2,".","");
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('Importe');
				$domA->value = $concepto['Importe'];
				$domConcepto->appendChild($domA);
				
				$domA = $dom->createAttribute('ObjetoImp');
				$domA->value = $concepto['objetoImp'];
				$domConcepto->appendChild($domA);

			if ($conceptos_impuestos) {
				$xml .= '<cfdi:Impuestos>';

				$domConceptoImp = $dom->createElement('cfdi:Impuestos');
			
				foreach ($conceptos_impuestos as $concepto_impuesto) {
					if ($concepto_impuesto['TipoImpuesto'] === 'TRASLADO') {
						
						$domConceptoImpTraslados = $dom->createElement('cfdi:Traslados');
						$domConceptoImpTraslado = $dom->createElement('cfdi:Traslado');
						
						$domA = $dom->createAttribute('Base');
						$domA->value = htmlspecialchars($concepto_impuesto['Base']);
						$domConceptoImpTraslado->appendChild($domA);
						
						$domA = $dom->createAttribute('Impuesto');
						$domA->value = htmlspecialchars($concepto_impuesto['Impuesto']);
						$domConceptoImpTraslado->appendChild($domA);
						
						$domA = $dom->createAttribute('TipoFactor');
						$domA->value = htmlspecialchars($concepto_impuesto['TipoFactor']);
						$domConceptoImpTraslado->appendChild($domA);
						
						$domA = $dom->createAttribute('TasaOCuota');
						$domA->value = htmlspecialchars($concepto_impuesto['TasaOCuota']);
						$domConceptoImpTraslado->appendChild($domA);
						
						$domA = $dom->createAttribute('Importe');
						$domA->value = htmlspecialchars($concepto_impuesto['Importe']);
						$domConceptoImpTraslado->appendChild($domA);

						$domConceptoImpTraslados->appendChild($domConceptoImpTraslado);
						$domConceptoImp->appendChild($domConceptoImpTraslados);


					} else if ($concepto_impuesto['TipoImpuesto'] === 'RETENCION') {

						$domConceptoImpRetenidos = $dom->createElement('cfdi:Retenciones');
						$domConceptoImpRetenido = $dom->createElement('cfdi:Retencion');

						$domA = $dom->createAttribute('Base');
						$domA->value = htmlspecialchars($concepto_impuesto['Base']);
						$domConceptoImpRetenido->appendChild($domA);
						
						$domA = $dom->createAttribute('Impuesto');
						$domA->value = htmlspecialchars($concepto_impuesto['Impuesto']);
						$domConceptoImpRetenido->appendChild($domA);
						
						$domA = $dom->createAttribute('TipoFactor');
						$domA->value = htmlspecialchars($concepto_impuesto['TipoFactor']);
						$domConceptoImpRetenido->appendChild($domA);
						
						$domA = $dom->createAttribute('TasaOCuota');
						$domA->value = htmlspecialchars($concepto_impuesto['TasaOCuota']);
						$domConceptoImpRetenido->appendChild($domA);						
						
						$domA = $dom->createAttribute('Importe');
						$domA->value = ($concepto_impuesto['Importe']);
						$domConceptoImpRetenido->appendChild($domA);

						$domConceptoImpRetenidos->appendChild($domConceptoImpRetenido);
						$domConceptoImp->appendChild($domConceptoImpRetenidos);
						
					}
				}
				$domConcepto->appendChild($domConceptoImp);
			}
			$domConceptos->appendChild($domConcepto);
		}

			$domE->appendChild($domEmisor);
			$domE->appendChild($domReceptor);
			$domE->appendChild($domConceptos);
		

			$domImpCom = $dom->createElement('cfdi:Impuestos');

			if ($totalImpuestosRetenciones != -1) {
				$domA = $dom->createAttribute('TotalImpuestosRetenidos');
				$domA->value = number_format($totalImpuestosRetenciones, 2,".","");
				$domImpCom->appendChild($domA);
			} 
			if ($totalImpuestosTrasladados != -1) {
				$domA = $dom->createAttribute('TotalImpuestosTrasladados');
				$domA->value = number_format($totalImpuestosTrasladados, 2,".","");
				$domImpCom->appendChild($domA);
			}

				if ( ! empty($totalesRetenciones)) {
					$domImpRetenidosCom = $dom->createElement('cfdi:Retenciones');
					$xml .= '
		<cfdi:Retenciones>';
					foreach ($totalesRetenciones as $key => $value) {
						$domImpRetenidoCom = $dom->createElement('cfdi:Retencion');

						$domA = $dom->createAttribute('Base');
						$domA->value = $value['Base'];
						$domImpRetenidoCom->appendChild($domA);
						
						$domA = $dom->createAttribute('Impuesto');
						$domA->value = $value['Impuesto'];
						$domImpRetenidoCom->appendChild($domA);

						$domA = $dom->createAttribute('Importe');
						$domA->value = number_format($value['nTRet'], 2,".","");
						$domImpRetenidoCom->appendChild($domA);
						$domImpRetenidosCom->appendChild($domImpRetenidoCom);
						
					}
					$domImpCom->appendChild($domImpRetenidosCom);
				}

				if ( ! empty($totalesTrasladados)) {
					
					$domImpTrasladosCom = $dom->createElement('cfdi:Traslados');
					
					foreach ($totalesTrasladados as $key => $value) {
						
						$domImpTrasladoCom = $dom->createElement('cfdi:Traslado');

						$domA = $dom->createAttribute('Base');
						$domA->value =  $value['Base'];
						$domImpTrasladoCom->appendChild($domA);
						
						$domA = $dom->createAttribute('Impuesto');
						$domA->value =  $value['Impuesto'];
						$domImpTrasladoCom->appendChild($domA);

						$domA = $dom->createAttribute('TipoFactor');
						$domA->value = $value['TipoFactor'];
						$domImpTrasladoCom->appendChild($domA);

						$domA = $dom->createAttribute('TasaOCuota');
						$domA->value = $value['TasaOCuota'];
						$domImpTrasladoCom->appendChild($domA);

						$domA = $dom->createAttribute('Importe');
						$domA->value = number_format($value['nTTras'], 2,".","");
						$domImpTrasladoCom->appendChild($domA);
						
						$domImpTrasladosCom->appendChild($domImpTrasladoCom); 
					}
					$domImpCom->appendChild($domImpTrasladosCom);
				}

			$domE->appendChild($domImpCom);
			$dom->appendChild($domE);
			/* echo $xml;
			die(); */
			// $this->xml = base64_encode($xml);
			/* echo $dom->saveXML();
			die(); */
			$this->xml = base64_encode($dom->saveXML());

		} catch (Exception $e) {
			echo json_encode(array('status'=> FALSE, 'msg' => 'Error al leer configuración de facturación', 'error' => $e->getMessage()));
			die();
		}

		/* // * get XML
		if (file_exists('SinSello64.xml')) {
			$this->xml = base64_encode(file_get_contents('SinSello.xml'));
			// $this->xml = file_get_contents('SinSello.xml');
			// echo $this->xml;
		} else {
			exit('Error abriendo SinSello64.xml.');
		} */

		// * get timbrado config
		try {
			$sql = 'SELECT 
						*
					FROM
						configuracion_sistema';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute();

			$configs = array();
			while ($config = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$configs[] = $config;
			}

			$this->cer64 = $configs[0]['timbrado_cer'];
			$this->key64 = $configs[0]['timbrado_key'];
			$this->keyPass = $configs[0]['timbrado_pass'];
			$this->usuario = $configs[0]['timbrado_usuario'];
			$this->password = $configs[0]['timbrado_password'];

		} catch (Exception $e) {
			echo json_encode(array('status'=> FALSE, 'msg' => 'Error al leer configuración', 'error' => $e->getMessage()));
			die();
		}
	}

	public function setFactura($resp, $data) {
		try {
			 // Cambiar estado de Ticket
			$sql = 'UPDATE 
						ticket 
					SET 
						status = "Facturado",
						FechaFactura = :FechaFactura 
					WHERE WebID = :WebID
					AND IDTicket = :IDTicket';

			$stmt = $this->conexion_db->prepare($sql);
			// QVJX3A
			$stmt->execute(array (':FechaFactura' => $this->fechaFactura,
								':WebID' => $data['webID'],
								':IDTicket' => $data['noTicket']));
			
			// Crear Factura

			$sql = 'INSERT INTO facturas
					VALUES (:RFCEmisor,
							:Serie,
							:Folio,
							:UUID,
							:RFCReceptor,
							:NombreReceptor,
							:Total,
							:Fecha,
							:FechaTimbrado,
							:Status,
							:Usuario)';
								
			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute( array (':RFCEmisor' => $this->rfcemisor, 
									':Serie' => $this->serie,
									':Folio' => $this->folio,
									':UUID' => $resp['uuid'],
									':RFCReceptor' => $this->rfcreceptor,
									':NombreReceptor' => $this->nombrereceptor,
									':Total' => $resp['total'],
									':Fecha' => $this->fechaFactura,
									':FechaTimbrado' => $resp['fechaTimbrado'],
									':Status' => 'A',
									':Usuario' => $data['usuario']));

			// Actualizar folio, no necesario en ASSA
			// $sql = 'UPDATE 
			// 			configuracion_sistema
			// 		SET
			// 			folio_siguiente = :folio_siguiente';

			// $stmt = $this->conexion_db->prepare($sql);
			// $stmt->execute(array (':folio_siguiente' => (int)$this->folio+=1));
 
			// Crear Factura-Tickets

			$sql = 'INSERT INTO factura_tickets
					VALUES (:UUID,
							:IDTicket)';
								
			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute( array (':UUID' => $resp['uuid'], 
									':IDTicket' => $this->idticket));

			/* echo "<b>Status:</b> ".$resp['status']."<br/>";  
			echo "<b>Mensaje:</b> ".$resp['mensaje']."<br/>";
			echo "<b>No. Certificado:</b> ".$resp['NoCertificado']."<br/>";
			echo "<b>Sello Comprobante:</b> ".$resp['SelloComprobante']."<br/>";  
			echo "<b>CFDI B64:</b> ".$resp['CFDI']."<br/>";
			echo "<b>Cadena Original SAT:</b> ".$resp['cadenaOriginalSAT']."<br/>";
			echo "<b>No. Certificado SAT:</b> ".$resp['noCertificadoSAT']."<br/>";
			echo "<b>No. Certificado CFDI:</b> ".$resp['noCertificadoCFDI']."<br/>";
			echo "<b>UUID:</b> ".$resp['uuid']."<br/>";
			echo "<b>Sello SAT:</b> ".$resp['selloSAT']."<br/>";
			echo "<b>Fecha Timbrado:</b> ".$resp['fechaTimbrado']."<br/>";
			echo "<b>Total:</b> ".$resp['total']."<br/>";
			echo "<b>Total con Letra:</b> ".$resp['totalLetra']."<br/>";
			echo "<b>QR Code:</b> ".$resp['qrCode']."<br/>"; */
			$this->createPDF($resp);
		} catch (Exception $e) {
			// echo "La linea de error es:" . $e->getLine() . "<br>";
			// echo "Mensaje:" . $e->getMessage();
			echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar datos de facturas', 'error' => $e->getMessage()));
			die();
		}
	}

	public function createPDF($resp) {
		$ruta_xml = 'config.xml';
		$xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
		$this->TipoDocto = str_replace(' ', '_', $xml_config->Doce->TipoDocto);

		$namePDF = $this->TipoDocto . '_' . $this->idticket;
		$this->ArchPDF = str_replace('/', '_', $namePDF) . '.pdf';

		$clienteRazonSocial = $this->datos_facturacion['razonSocial'];
		$clienteDireccion = '';
		if ($this->datos_facturacion['calle'] !== '') {
			$clienteDireccion .= $this->datos_facturacion['calle'] . ' ';
		}
		if ($this->datos_facturacion['noExt'] !== '') {
			$clienteDireccion .= $this->datos_facturacion['noExt'] . ' ';
		}
		if ($this->datos_facturacion['noInt'] !== '') {
			$clienteDireccion .= $this->datos_facturacion['noInt'] . ' ';
		}
		if ($this->datos_facturacion['colonia'] !== '') {
			$clienteDireccion .= $this->datos_facturacion['colonia'];
		}
		
		$clienteCiudad = '';
		if ($this->datos_facturacion['municipio']) {
			$clienteCiudad = $this->datos_facturacion['municipio'] . ',';
		}
		
		$clienteCP = $this->datos_facturacion['codigoPostal'];

		$lugar_entrega_1 = '';
		if ($this->datos_facturacion['calle'] !== '') {
			$lugar_entrega_1 .= $this->lugarEntrega_calle . ' ';
		}
		if ($this->datos_facturacion['noExt'] !== '') {
			$lugar_entrega_1 .= $this->lugarEntrega_noExterior . ' ';
		}
		if ($this->datos_facturacion['noInt'] !== '') {
			$lugar_entrega_1 .= $this->lugarEntrega_noInterior . ' ';
		}
		if ($this->datos_facturacion['colonia'] !== '') {
			$lugar_entrega_1 .= $this->lugarEntrega_colonia;
		}

		if ($lugar_entrega_1 === '') {
			$lugar_entrega_1 = '<br><br>';
		}

		$lugarEntrega_calle = $this->lugarEntrega_calle;
		$lugarEntrega_noExterior = $this->lugarEntrega_noExterior;
		$lugarEntrega_noInterior = $this->lugarEntrega_noInterior;
		$lugarEntrega_colonia = $this->lugarEntrega_colonia;

		$lugar_entrega_2 = '';
		if ($this->lugarEntrega_municipio !== '') {
			$lugar_entrega_2 .= $this->lugarEntrega_municipio . ', ';
		}
		if ($this->lugarEntrega_estado !== '') {
			$lugar_entrega_2 .= $this->lugarEntrega_estado . ', ';
		}
		if ($this->lugarEntrega_pais !== '') {
			$lugar_entrega_2 .= $this->lugarEntrega_pais . ', ';
		}
		if ($this->lugarEntrega_codigoPostal !== '') {
			$lugar_entrega_2 .= $this->lugarEntrega_codigoPostal;
		}

		if ($lugar_entrega_2 === '') {
			$lugar_entrega_2 = '<br><br>';
		}

		$serie = $this->serie;
		$folio = $this->folio;
		$remitidoPor = $this->configuracion_sistema['timbrado_cer_serie'];

		// $agente;
		// $clienteID;

		// validar si utiliza ID
		
		$clienteRFC = $this->datos_facturacion['rfc'];
		if ($this->datos_facturacion['taxID']) {
			$clienteRFC .= ' - ' . $this->datos_facturacion['taxID'];
		}

		$UsoCFDI = $this->uso_cfdi;

		$sql = 'SELECT 
					Descripcion
				FROM
					uso_cfdi
				WHERE
					clave = :clave';

			$stmt = $this->conexion_db->prepare($sql);
			// QVJX3A
			$stmt->execute(array (':clave' => $UsoCFDI));

		$cUsoCFDI = $stmt->fetch(PDO::FETCH_ASSOC);
		
		$UsoCFDIDescripcion = $cUsoCFDI['Descripcion'];

		$fechaTimbrado = $resp['fechaTimbrado'];
		$folioFiscal = $resp['uuid'];

		$noCertificadoSAT = $resp['noCertificadoSAT'];
		$noCertificado = $resp['NoCertificado'];
		$formaPago = $this->forma_pago;
		
		$sql = 'SELECT 
					Descripcion
				FROM
					c_formapago
				WHERE
					c_FormaPago = :c_FormaPago';

			$stmt = $this->conexion_db->prepare($sql);
			// QVJX3A
			$stmt->execute(array (':c_FormaPago' => $formaPago));

		$cFormaPago = $stmt->fetch(PDO::FETCH_ASSOC);
		
		$formaPagoDescripcion = $cFormaPago['Descripcion'];
		$metodoPago = $this->ticket['MetodoPago'];

		$sql = 'SELECT 
					Descripcion
				FROM
					c_metodopago
				WHERE
					c_MetodoPago = :c_MetodoPago';

			$stmt = $this->conexion_db->prepare($sql);
			// QVJX3A
			$stmt->execute(array (':c_MetodoPago' => $metodoPago));

		$cMetodoPago = $stmt->fetch(PDO::FETCH_ASSOC);
		
		$metodoPagoDescripcion = $cMetodoPago['Descripcion'];

		$importeEnLetras = $resp['totalLetra'];
		$lugarExpedicion = $this->ticket['LugarExpedicion'];
		$fechaExpedido = $this->fechaFactura;
		$selloDigitalCFDI = chunk_split($resp['SelloComprobante'], 150, "<br>");
		$selloDigitalSAT = chunk_split($resp['selloSAT'], 150, "<br>");
		$cadenaOriginalSAT = chunk_split($resp['cadenaOriginalSAT'], 150, "<br>");

		$conceptos = $this->conceptos;

		$conceptosArticulos = '';
		$conceptosCantidad = '';
		$conceptosDescripcion = '';
		$conceptosUM = '';
		$conceptosPrecioUnitario = '';
		$conceptosImporte = '';

		foreach ($conceptos as $concepto) {
			$conceptosArticulos .= '<p style="margin: 0">' . $concepto['NoIdentificacion'] . '</p>';
			$conceptosCantidad .= '<p style="margin: 0">' . $concepto['Cantidad'] . '</p>';
			$conceptosDescripcion .= '<p style="margin: 0">' . $concepto['Descripcion'] . '</p>';
			$conceptosUM .= '<p style="margin: 0">' . $concepto['Unidad'] . '</p>';
			$conceptosPrecioUnitario .= '<p style="margin: 0; text-align: right">' . number_format($concepto['ValorUnitario'], 2,".",",") . '</p>';
			$conceptosImporte .= '<p style="margin: 0;  text-align: right">' . number_format($concepto['Importe'], 2,".",",") . '</p>';
		}

		$qr64 = $resp['qrCode'];
		
		$subTotal = number_format($this->ticket['SubTotal'], 2,".",",");
		$total = number_format($resp['total'], 2,".",","); // * verificar campo
		
		if ($this->totalImpuestosTrasladados == -1) {
			$this->totalImpuestosTrasladados = 1500;
		}
		if ($this->totalImpuestosRetenciones == -1) {
			$this->totalImpuestosRetenciones = 0;
		}

		$totalImpuestosTrasladados = number_format($this->totalImpuestosTrasladados, 2,".",",");
		$totalImpuestosRetenciones = number_format($this->totalImpuestosRetenciones, 2,".",",");

		/* echo "<b>Status:</b> ".$resp['status']."<br/>";  
			echo "<b>Mensaje:</b> ".$resp['mensaje']."<br/>";
			echo "<b>No. Certificado:</b> ".$resp['NoCertificado']."<br/>";
			echo "<b>Sello Comprobante:</b> ".$resp['SelloComprobante']."<br/>";  
			echo "<b>CFDI B64:</b> ".$resp['CFDI']."<br/>";
			echo "<b>Cadena Original SAT:</b> ".$resp['cadenaOriginalSAT']."<br/>";
			echo "<b>No. Certificado SAT:</b> ".$resp['noCertificadoSAT']."<br/>";
			echo "<b>No. Certificado CFDI:</b> ".$resp['noCertificadoCFDI']."<br/>";
			echo "<b>UUID:</b> ".$resp['uuid']."<br/>";
			echo "<b>Sello SAT:</b> ".$resp['selloSAT']."<br/>";
			echo "<b>Fecha Timbrado:</b> ".$resp['fechaTimbrado']."<br/>";
			echo "<b>Total:</b> ".$resp['total']."<br/>";
			echo "<b>Total con Letra:</b> ".$resp['totalLetra']."<br/>";
			echo "<b>QR Code:</b> ".$resp['qrCode']."<br/>"; */
		
		// require 'TCPDF/examples/example_061x.php';

		$date = explode("-", $resp['fechaTimbrado']);
		$year = $date[0];
		
		$month = $date[1];
		// subfolders xml
		$rutaXML = $this->configuracion_sistema['rutaXML'] . '/' . $year . '/' . $month;
		if (!file_exists($rutaXML)) {
			mkdir($rutaXML, 0777, true);
		}

		// subfolders pdf
		$rutaPDF = $this->configuracion_sistema['rutaPDF'] . '/' . $year . '/' . $month;
		if (!file_exists($rutaPDF)) {
			mkdir($rutaPDF, 0777, true);
		}
		
		// create xml
		$nameXML =  $this->TipoDocto . '_' . $this->idticket;
		$nameXML = str_replace('/', '_', $nameXML);
		$this->ArchXML = $nameXML . '.xml';	

		@file_put_contents($rutaXML . '/' . $nameXML . '.xml', base64_decode($resp['CFDI']));

		// create PDF
		require 'html2pdf/index.php';

		// sendFiles
		$this->sendMailCFDI($resp, $rutaXML, $rutaPDF);
	}

	public function sendMailCFDI($resp, $rutaXML, $rutaPDF) {

        $IDTicket = $this->idticket;
        require 'MandaCorreos/FuncionSendMailCFDI.php';

        $body = file_get_contents('templates/mail_cfdi.php');
        $asunto = 'CFDI ticket: ' . $IDTicket;

        $arr_campos_reemplazar = array('<<IDTICKET>>');
        // Verificar configuracion modo de pruebas 
        $ruta_xml = 'config.xml';
		$xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
		$this->EmailReenvio = $xml_config->Factura->correo_copia_factura;
        // echo var_dump($xml_config);

        $arr_campos = array($IDTicket);

        $body = str_replace($arr_campos_reemplazar, $arr_campos, $body);
		$sql = 'SELECT 
						correo
					FROM
						usuarios
					WHERE
						username = :username';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':username' => $this->usuarioPortal));

			$usuario = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($xml_config->sendmail->modo_test == 'SI') {
					$correos_notificar = explode(',', $usuario['correo'] . ',' . $xml_config->sendmail->correos_notificar_factura);
					$correos_copia = explode(',', $xml_config->Factura->correo_copia_factura);
            
					if ( ! SendMail($correos_notificar, $correos_notificar, $asunto, $body, '', '', '', $IDTicket, $rutaXML, $rutaPDF, $correos_copia)){
						$this->err_correo = 'Se ha timbrado el ticket, pero ha sucedido un error al notificar el CFDI por correo'; 
					}
        } else {
					$correos_notificar = array();
					$correos_notificar[] = $usuario['correo'];
					$correos_copia = explode(',', $xml_config->Factura->correo_copia_factura);
	
					if ( ! SendMail($correos_notificar, $correos_notificar, $asunto, $body, '', '', '', $IDTicket, $rutaXML, $rutaPDF, $correos_copia)){
						$this->err_correo = 'Se ha timbrado el ticket, pero ha sucedido un error al notificar el CFDI por correo'; 
			}
		}
		$this->insertar_disxii($resp, $rutaXML, $rutaPDF);
	}

	function get_atributo_xml($xml, $string) {
        
        // registrar namespaces
        foreach ($xml->getNamespaces(true) as $key => $value) {
            $xml->registerXPathNamespace($key, $value);
        }

        return isset($xml->xpath($string)[0][0]) ? $xml->xpath($string)[0][0] : '';
	}

	function get_campos_adicionales($string) {
		$arr_adicionales = array('A_01','A_02','A_03','A_04','A_05','A_06','A_07','A_08','A_09','A_10','A_11','A_12','A_13','A_14','A_15','A_16','A_17','A_18','A_19','A_20');

        return in_array($string, $arr_adicionales) ? $this->ticket[$string] : '';
	}

	public function insertar_disxii($resp, $rutaXML, $rutaPDF) {
		require "conexion/configDisXII.php";

		try
        {
			/* CONEXION */
            $conexion_db = new PDO('mysql:host=' . DB_HOST_XII .': 
                                        ' . DB_PORT_XII . '; 
                                        dbname=' . DB_NOMBRE_XII, DB_USUARIO_XII, DB_CONTRA_XII);

            $conexion_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $conexion_db->exec("SET CHARACTER SET utf8");

			/* QUERYS */
			
			$sql = 'SELECT 
						SERIE, FOLIO
					FROM 
						doce
					WHERE 
						RFCEmisor = :RFC_Emisor
						AND tipoDocto = :tipoDocto
						AND serie = :serie
						AND folio = :folio';

			$stmt = $conexion_db->prepare($sql);

			$xml = simplexml_load_string(base64_decode($resp['CFDI']));

			$ruta_xml = 'config.xml';
			$xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");

			$FiltroA = $xml_config->Doce->Empresas->Empresa->FiltroA;
			$FiltroB = $xml_config->Doce->Empresas->Empresa->FiltroB;
			$FiltroC = $xml_config->Doce->Empresas->Empresa->FiltroC;

			while (preg_match('/\[(.*?)\]/', $FiltroA, $match) == 1) {
				$FiltroA = str_replace($match[0], $this->get_campos_adicionales($match[1]), $FiltroA);
			}
			while (preg_match('/{{(.*?)}}/', $FiltroA, $match) == 1) {
				$FiltroA = str_replace($match[0], $this->get_atributo_xml($xml, $match[1]), $FiltroA); 
			}

			while (preg_match('/\[(.*?)\]/', $FiltroB, $match) == 1) {
				$FiltroB = str_replace($match[0], $this->get_campos_adicionales($match[1]), $FiltroB);
			}
			while (preg_match('/{{(.*?)}}/', $FiltroB, $match) == 1) {
				$FiltroB = str_replace($match[0], $this->get_atributo_xml($xml, $match[1]), $FiltroB); 
			}

			while (preg_match('/\[(.*?)\]/', $FiltroC, $match) == 1) {
				$FiltroC = str_replace($match[0], $this->get_campos_adicionales($match[1]), $FiltroC);
			}
			while (preg_match('/{{(.*?)}}/', $FiltroC, $match) == 1) {
				$FiltroC = str_replace($match[0], $this->get_atributo_xml($xml, $match[1]), $FiltroC); 
			}

			$taxID = '';
			if ($this->datos_facturacion['taxID']) {
				$taxID = $this->datos_facturacion['taxID'];
			}
			
			$stmt->execute(array (
				':RFC_Emisor' => $this->rfcemisor,
				':tipoDocto' => $this->TipoDocto,
				':serie' => $this->serie,
				':folio' => $this->folio));

			$doce = $stmt->fetch(PDO::FETCH_ASSOC);
			
			if ($doce) {
				$sql = 'UPDATE
							doce 
						SET 
							RFCReceptor = :RFC_Receptor,
							nombreRec = :NombreReceptor,
							fecha = :Fecha,
							iva = :IVA,
							total = :Total,
							tipoComprobante = :lcTipoComprobante,
							ArchPDF = :ArchPDF,
							ArchXML = :ArchXML,
							filtroA = :FiltroA,
							filtroB = :FiltroB,
							filtroC = :FiltroC,
							email = :EmailReenvio,
							UUID = :UUID,
							observaciones = "Actualizado desde DisXII Tickets",
							Moneda = :Moneda,
							TipoCambio = :TipoCambio,
							VersionCFD = :VersionCFD,
							MetodoPago = :MetodoPago,
							taxId = :taxId
						WHERE 
							RFCEmisor = :RFC_Emisor
							AND tipoDocto = :TipoDocto
							AND serie = :Serie
							AND folio= :Folio';
					
					$stmt = $conexion_db->prepare($sql);

					$stmt->execute(array (
						':RFC_Receptor' => $this->rfcreceptor,
						':NombreReceptor' => $this->nombrereceptor, // xml
						':Fecha' => $this->fechaFactura,
						':IVA' => $this->ticket['IVA'],
						':Total' => $this->ticket['Total'],
						':lcTipoComprobante' => 'I',
						':ArchPDF' => $this->ArchPDF,
						':ArchXML' => $this->ArchXML,
						':FiltroA' => $FiltroA, // xml
						':FiltroB' => $FiltroB, // xml
						':FiltroC' => $FiltroC, // xml
						':EmailReenvio' => $this->EmailReenvio,
						':UUID' => $resp['uuid'],
						':Moneda' => $this->ticket['Moneda'],
						':TipoCambio' => $this->TipoCambio,
						':VersionCFD' => '4.0',
						':MetodoPago' => $this->ticket['MetodoPago'],
						':taxId' => $taxID,
						':RFC_Emisor' => $this->rfcemisor,
						':TipoDocto' => $this->TipoDocto,
						':Serie' => $this->serie,
						':Folio' => $this->folio));
			} else {
				$sql = 'INSERT INTO 
							doce (RFCEmisor,
								tipoDocto,
								serie,
								folio,
								RFCReceptor,
								nombreRec,
								fecha,
								noAprobacion,
								anoAprobacion,
								iva,
								total,
								status,
								tipoComprobante,
								pedimentos,
								fechaPedimentos,
								aduanas,
								ArchPDF,
								ArchXML,
								filtroA,
								filtroB,
								filtroC,
								email,
								UUID,
								observaciones,
								Moneda,
								TipoCambio,
								VersionCFD,
								MetodoPago,
								taxId)
						VALUES (:RFC_Emisor,
								:TipoDocto,
								:Serie,
								:Folio,
								:RFC_Receptor,
								:NombreReceptor,
								:Fecha,
								0,
								0,
								:IVA,
								:Total,
								:lcStatus,
								:lcTipoComprobante,
								"",
								"",
								"",
								:ArchPDF,
								:ArchXML,
								:FiltroA,
								:FiltroB,
								:FiltroC,
								:EmailReenvio,
								:UUID,
								"Generado desde DisXII Tickets",
								:Moneda,
								:TipoCambio,
								:VersionCFD,
								:MetodoPago,
								:taxId)';
				
				$stmt = $conexion_db->prepare($sql);

				$stmt->execute(array (
					':RFC_Emisor' => $this->rfcemisor,
					':TipoDocto' => $this->TipoDocto, // xml
					':Serie' => $this->serie,
					':Folio' => $this->folio,
					':RFC_Receptor' => $this->rfcreceptor,
					':NombreReceptor' => $this->nombrereceptor,
					':Fecha' => $this->fechaFactura,
					':IVA' => $this->ticket['IVA'],
					':Total' => $this->ticket['Total'],
					':lcStatus' => 1,
					':lcTipoComprobante' => 'I',
					':ArchPDF' => $this->ArchPDF,
					':ArchXML' => $this->ArchXML,
					':FiltroA' => $FiltroA, // xml
					':FiltroB' => $FiltroB, // xml
					':FiltroC' => $FiltroC, // xml
					':EmailReenvio' => $this->EmailReenvio,
					':UUID' => $resp['uuid'],
					':Moneda' => $this->ticket['Moneda'],
					':TipoCambio' => $this->TipoCambio,
					':VersionCFD' => '4.0',
					':MetodoPago' => $this->ticket['MetodoPago'],
					':taxId' => $taxID));
			}

        } catch (Exception $e) {
			// Notificar res
			$error = $e->getMessage();
			// $this->err_query = $stmt->debugDumpParams();
			// $this->err_query = 123;

			if ($this->crear_archivos_res('DisXII', $this->rfcemisor, $this->folio, $this->serie, $resp['uuid'], $resp['fechaTimbrado'], "Error: Se ha timbrado correctamente, pero no se pudo insertar en DisXII \n $error")) {
				if ($this->err_correo) {
					echo json_encode(array('status' => FALSE, 'msg' => $this->err_correo, 'resp'=>$resp, 'IDTicket' => $this->idticket, 'rutaXML' => $rutaXML, 'rutaPDF' => $rutaPDF));
					die();
				} else {
					echo json_encode(array('status' => TRUE, 'resp'=>$resp, 'IDTicket' => $this->idticket, 'rutaXML' => $rutaXML, 'rutaPDF' => $rutaPDF));
					die();
				}
			}
    }

		if ($this->crear_archivos_res(0, $this->rfcemisor, $this->folio, $this->serie, $resp['uuid'], $resp['fechaTimbrado'])) {
			if ($this->err_correo) {
				echo json_encode(array('status'=>FALSE, 'msg' => $this->err_correo, 'resp'=>$resp, 'IDTicket' => $this->idticket, 'rutaXML' => $rutaXML, 'rutaPDF' => $rutaPDF));
			} else {
				echo json_encode(array('status'=>TRUE, 'resp'=>$resp, 'IDTicket' => $this->idticket, 'rutaXML' => $rutaXML, 'rutaPDF' => $rutaPDF));
			}
		}
		
	}

	public function crear_archivos_res($error, $rfc_emisor, $folio, $serie, $uuid, $fecha, $detalle_error = FALSE, $xml_sin_timbrar = FALSE) {
		if ($error === 0) {
			$rutaDoc = $this->configuracion_sistema['rutaResOK'];
			if (!file_exists($rutaDoc)) {
				$old = umask(0);
				mkdir($rutaDoc, 0777, true);
				umask($old);
			}

			// nombre archivo dinámico
			$arr_campos_reemplazar = array('<<_SERIE>>','<<_FOLIO>>','<<_FECHA>>');
			
			$fecha = str_replace(array("-",':','T'), "", $fecha);

			$arr_campos = array($serie,
													$folio,
													$fecha);

			$nombreArchivo = $this->configuracion_sistema['resNombre'];
			$nombreArchivo = str_replace($arr_campos_reemplazar, $arr_campos, $nombreArchivo);

			$contenido = $error . "\n";
			$contenido .= $rfc_emisor . "\n";
			$contenido .= $folio . "\n";
			$contenido .= $serie . "\n";
			$contenido .= $uuid . "\n";

			file_put_contents($rutaDoc . '/' . $nombreArchivo, $contenido);
			return true;
		} else {
			if ($error !== 'DisXII') {
				$rutaDoc = $this->configuracion_sistema['rutaResWR'];
				if (!file_exists($rutaDoc)) {
					$old = umask(0);
					mkdir($rutaDoc, 0777, true);
					umask($old);
				}
	
				// nombre archivo dinámico
				$arr_campos_reemplazar = array('<<_SERIE>>','<<_FOLIO>>','<<_FECHA>>');
				
				$fecha = str_replace(array("-",':','T'), "", $fecha);
	
				$arr_campos = array($serie,
														$folio,
														$fecha);
	
				$nombreArchivo = $this->configuracion_sistema['resNombre'];
				$nombreArchivo = str_replace($arr_campos_reemplazar, $arr_campos, $nombreArchivo);
	
				$contenido = $error . "\n";
				$contenido .= $rfc_emisor . "\n";
				$contenido .= $folio . "\n";
				$contenido .= $serie . "\n";
				$contenido .= $uuid . "\n";
				$contenido .= $detalle_error . "\n";
	
				file_put_contents($rutaDoc . '/' . $nombreArchivo, $contenido);
	
				if ($this->notificar_error_timbrado($detalle_error, $xml_sin_timbrar)) {
					return true; 
				}
			} else {
				$rutaDoc = $this->configuracion_sistema['rutaResWR'];
				if (!file_exists($rutaDoc)) {
					$old = umask(0);
					mkdir($rutaDoc, 0777, true);
					umask($old);
				}
	
				// nombre archivo dinámico
				$arr_campos_reemplazar = array('<<_SERIE>>','<<_FOLIO>>','<<_FECHA>>');
				
				$fecha = str_replace(array("-",':','T'), "", $fecha);
				$arr_campos = array($serie, $folio, $fecha);
				$nombreArchivo = $this->configuracion_sistema['resNombre'];
				
				$nombreArchivo = str_replace($arr_campos_reemplazar, $arr_campos, $nombreArchivo);
	
				$contenido = 0 . "\n";
				$contenido .= $rfc_emisor . "\n";
				$contenido .= $folio . "\n";
				$contenido .= $serie . "\n";
				$contenido .= $uuid . "\n";
				$contenido .= $detalle_error . "\n";
	
				file_put_contents($rutaDoc . '/' . $nombreArchivo, $contenido);
	
				if ($this->notificar_error_timbrado($detalle_error, false)) {
					return true; 
				}
			}
		}
	}

	public function notificar_error_timbrado($error, $xml_sin_timbrar) {
		$IDTicket = $this->idticket;
		require 'MandaCorreos/FuncionSendMailErrorTimbrado.php';

		$body = file_get_contents('templates/mail_error_timbrado.php');
		
		$arr_campos_reemplazar = array('<<IDTICKET>>', '<<ERROR>>');

		$ruta_xml = 'config.xml';
		$xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
		$asunto = $xml_config->Correos->asunto_correo_error_timbrado . $IDTicket;

		$arr_campos = array($IDTicket, $error);

		$body = str_replace($arr_campos_reemplazar, $arr_campos, $body);
		
		$sql = 'SELECT 
						correo
					FROM
						usuarios
					WHERE
						username = :username';

			$stmt = $this->conexion_db->prepare($sql);
			$stmt->execute(array (':username' => 'admin'));

			$usuarioAdmin = $stmt->fetch(PDO::FETCH_ASSOC);
			
			$correos_notificar = explode(',', $usuarioAdmin['correo'] . ',' . $xml_config->sendmail->correos_notificar_error_timbrado);
					
			if ( ! SendMailErrorTimbrado($correos_notificar, $correos_notificar, $asunto, $body, '', '', '', $xml_sin_timbrar)){
					echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
					die();
					return false;
			}
			return true;
			/*  else {
				$correos_notificar = array();
				$correos_notificar[] = $usuarioAdmin['correo'];
		
				if ( ! SendMailErrorTimbrado($correos_notificar, $correos_notificar, $asunto, $body, '', '', '', $xml_sin_timbrar)){
						echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
						die();
						return false;
				}
				return true;
			} */
	}

	public function callWS($data) {
		$this->usuarioPortal = $data['usuario'];
		$this->getData($data);
		
		$res = $this->wsSellaTimbra(
							$this->xml,
							$this->cer64,
							$this->key64,
							$this->keyPass,
							$this->usuario,
							$this->password
							);
		if ( ! $res) {
			$resp = json_decode($this->RESPONSE, true);
			
			if(!isset($resp['status'])){
				$resp['status'] = "false";
			}
			if(!isset($resp['mensaje'])){
				$resp['mensaje'] = "No existe mensaje de error";
			}
			if(!isset($resp['XML'])){
				$resp['XML'] = "";
			}

			if ($this->crear_archivos_res($resp['status'], $this->rfcemisor, $this->folio, $this->serie, '--UUID--', $this->fechaFactura, $resp['mensaje'], $resp['XML'])) {
				echo json_encode(array('status'=>FALSE, 'statusWEB'=> $resp['status'], 'msg'=> $resp['mensaje'], 'xmlSinTimbrar' => $resp['XML']));
			}
			echo json_encode(array('status'=>FALSE, 'msg'=> $this->MENSAJE_ERROR));
			die();
		}

			if(!isset($resp['status'])){
				$resp['status'] = "false";
			}
			if(!isset($resp['mensaje'])){
				$resp['mensaje'] = "No existe mensaje de error";
			}
			if(!isset($resp['XML'])){
				$resp['XML'] = "";
			}
		if ($this->CODEHTTP != 200) {
			$resp = json_decode($this->RESPONSE, true);

			if ($this->crear_archivos_res($resp['status'], $this->rfcemisor, $this->folio, $this->serie, '--UUID--', $this->fechaFactura, $resp['mensaje'], $resp['XML'])) {
				echo json_encode(array('status'=>FALSE, 'statusWEB'=> $resp['status'], 'msg'=> $resp['mensaje'], 'xmlSinTimbrar' => $resp['XML']));
			}
			// echo $this->CODEHTTP . " - " . $this->MENSAJE_ERROR;
			echo json_encode(array('status'=>FALSE, 'codehttp'=> $this->CODEHTTP, 'msg'=> $this->MENSAJE_ERROR));
			die();
		} else {
			$resp = json_decode($this->RESPONSE, true);

			if ($resp["status"] === "0") {
				$this->setFactura($resp, $data);
			} else {
				// En caso de que ocurra un error de timbrado
				/* echo "<b>Status:</b> ".$resp['status']."<br/>";  
				echo "<b>Mensaje:</b> ".$resp['mensaje']."<br/>";
				echo "<b>XML sin timbrar:</b> ".$resp['XML']."<br/>"; */
				
				if ($this->crear_archivos_res($resp['status'], $this->rfcemisor, $this->folio, $this->serie, '--UUID--', $this->fechaFactura, $resp['mensaje'], $resp['XML'])) {
					echo json_encode(array('status'=>FALSE, 'statusWEB'=> $resp['status'], 'msg'=> $resp['mensaje'], 'xmlSinTimbrar' => $resp['XML']));
				}
			}
		}
	}
 }

$data = json_decode(@file_get_contents("php://input"), true);
if (isset($data['method'])){

	// Verificar configuracion modo de pruebas 
	$ruta_xml = 'config.xml';
	$xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
	$modo = 'T'; // T pruebas, P productivo
	if ($xml_config->sendmail->modo_test == 'NO') {
		$modo = 'P';
	}

	$disxiiws = new DisXIIWS($modo);
	
	if ($data['method'] === 'validar_ticket') {
		$disxiiws->validar_ticket($data);
	} else if ($data['method'] === 'wsSellaTimbra') {
		$disxiiws->callWS($data);
	}
	
	
}
?>