<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require 'conexion/Conexion.php';
class Empresa extends Conexion {

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt)) {
            // $stmt->closeCursor();
        }
    }

    public function get_empresas()
    {
        $sql = 'SELECT 
                   *
                FROM
                    empresas';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute();
        
        $empresas = array();
        while ($empresa = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $empresas[] = $empresa;
        }

        echo json_encode(array('status'=> TRUE, 'empresas' => $empresas));
    }

    public function create_empresa($data)
    {
        try {
			
			// validar RFC
			if (!$this->valida_rfc1($data['emp_rfc'])) {
				echo json_encode(array('status'=> FALSE, 'msg'=> 'Formato de RFC no válido'));
				die();
			}
		
            $sql = 'INSERT INTO empresas (emp_nombre, emp_rfc, emp_calle, emp_noExt, emp_noInt, emp_estado, emp_municipio, emp_cp, emp_colonia, emp_telefono)
                    VALUES (:emp_nombre, :emp_rfc, :emp_calle, :emp_noExt, :emp_noInt, :emp_estado, :emp_municipio, :emp_cp, :emp_colonia, :emp_telefono)';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (
									':emp_nombre' => (string) $data['emp_nombre'],
									':emp_rfc' => (string) $data['emp_rfc'],
									':emp_calle' => (string) $data['emp_calle'],
									':emp_noExt' => (string) $data['emp_noExt'],
									':emp_noInt' => (string) $data['emp_noInt'],
									':emp_colonia' => (string) $data['emp_colonia'],
									':emp_cp' => (string) $data['emp_cp'],
									':emp_estado' => (string) $data['emp_estado'],
									':emp_municipio' => (string) $data['emp_municipio'],
									':emp_telefono' => (string) $data['emp_telefono']
                                    ));
			echo json_encode(array('status'=> TRUE, 'msg' => 'Empresa dada de alta correctamente'));
            
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al insertar la empresa, verifique que el rfc no exista', 'error' => $e->getMessage()));
            die();
        }
    }

    public function valida_rfc1($valor){
        $valor = str_replace("-", "", $valor); 
        $cuartoValor = substr($valor, 3, 1);
        //RFC sin homoclave
        if(strlen($valor)==10){
            $letras = substr($valor, 0, 4); 
            $numeros = substr($valor, 4, 6);
            if (ctype_alpha($letras) && ctype_digit($numeros)) { 
                return true;
            }
            return false;          
        }
        // Sólo la homoclave
        /* else if (strlen($valor) == 3) {
            $homoclave = $valor;
            if(ctype_alnum($homoclave)){
                return true;
            }
            return false;
        } */
        //RFC Persona Moral.
        else if (ctype_digit($cuartoValor) && strlen($valor) == 12) { 
            $letras = substr($valor, 0, 3); 
            $numeros = substr($valor, 3, 6); 
            $homoclave = substr($valor, 9, 3); 
            if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
                return true; 
            } 
            return false;
        //RFC Persona Física. 
        } else if (ctype_alpha($cuartoValor) && strlen($valor) == 13) { 
            $letras = substr($valor, 0, 4); 
            $numeros = substr($valor, 4, 6);
            $homoclave = substr($valor, 10, 3); 
            if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
                return true; 
            }
            return false; 
        }else { 
            return false; 
        }  
    }//fin validaRFC

   

    public function update_empresa($data)
    {
        try {

            $sql = 'UPDATE 
                        empresas
                    SET 
                        emp_nombre = :emp_nombre,
                        emp_rfc = :emp_rfc,
                        emp_calle = :emp_calle,
                        emp_noExt = :emp_noExt,
                        emp_noInt = :emp_noInt,
                        emp_colonia = :emp_colonia,
                        emp_cp = :emp_cp,
                        emp_estado = :emp_estado,
                        emp_municipio = :emp_municipio,
                        emp_telefono = :emp_telefono
                    WHERE
                        emp_id = :emp_id';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (
									':emp_nombre' => (string) $data['emp_nombre'],
									':emp_rfc' => (string) $data['emp_rfc'],
									':emp_calle' => (string) $data['emp_calle'],
									':emp_noExt' => (string) $data['emp_noExt'],
									':emp_noInt' => (string) $data['emp_noInt'],
									':emp_colonia' => (string) $data['emp_colonia'],
									':emp_cp' => (string) $data['emp_cp'],
									':emp_estado' => (string) $data['emp_estado'],
									':emp_municipio' => (string) $data['emp_municipio'],
									':emp_telefono' => (string) $data['emp_telefono'],
									':emp_id' => (string) $data['emp_id']
									));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Empresa actualizada'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar la empresa.', 'error' => $e->getMessage()));
            die();
        }
    }

    public function delete_empresa($data)
    {
        try {
            $sql = 'DELETE FROM 
                        empresas
                    WHERE
                        emp_id = :emp_id';

            $stmt = $this->conexion_db->prepare($sql);
            
            $stmt->execute( array (':emp_id' => $data['emp_id']));
            
            $sql = 'DELETE FROM
                        empresas
                    WHERE
                        emp_id = :emp_id';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':emp_id' => $data['emp_id']));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Empresa eliminada'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al eliminar la empresa', 'error' => $e->getMessage()));
            die();
        }
    }

    public function Encripta($cadena, $tipo = 0){
        $salida = "";
        if ($tipo === 0) {
            $cadInv = strrev(str_replace(" ", "--SPACE--", $cadena));
            for($i=0; $i < strlen($cadInv); $i++) {
                    $asc = ord($cadInv[$i]);
                    $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));
                }
            $salida = base64_encode($salida);
        } else {
            $cadInv = base64_decode($cadena);
            for($i=0; $i < strlen($cadInv); $i++) {
                $asc = ord($cadInv[$i]);
                $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));
            }
            $salida = str_replace("--SPACE--"," ",strrev($salida));
        }
        return $salida;
    }

}

$data = json_decode(file_get_contents("php://input"), true);
if (isset($data['method'])){
    $obj = new Empresa();
    if ($data['method'] === 'get_empresas') {
        $obj->get_empresas();
    } else if ($data['method'] === 'create_empresa') {
        $obj->create_empresa($data);
    } else if ($data['method'] === 'update_empresa') {
        $obj->update_empresa($data);
    } else if ($data['method'] === 'delete_empresa') {
        $obj->delete_empresa($data);
    }
}
