<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require 'conexion/Conexion.php';
class Facturas extends Conexion {

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt))
            $stmt->closeCursor();
    }

    public function get_facturas($data)
    {
        try {
            if ($data['user'] === 'admin') {
                $sql = 'SELECT 
                        *
                        FROM
                            facturas JOIN factura_tickets ON factura_tickets.UUID = facturas.UUID
                        WHERE
                            fecha >= :from 
                            AND fecha <= :to';
                
                $stmt = $this->conexion_db->prepare($sql);
                $stmt->execute(array (':from' => $data['from'] . ' 00:00:00',
                                        ':to' => $data['to'] . ' 23:59:59'));
            } else {
                $sql = 'SELECT 
                        *
                        FROM
                            facturas JOIN factura_tickets ON factura_tickets.UUID = facturas.UUID
                        WHERE
                            usuario = :usuario
                        AND fecha >= :from 
                        AND fecha <= :to';

                $stmt = $this->conexion_db->prepare($sql);
                $stmt->execute(array (':usuario' => $data['user'],
                                    ':from' => $data['from'] . ' 00:00:00',
                                    ':to' => $data['to'] . ' 23:59:59'));
            }
            
            $facturas = array();
            while ($factura = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $facturas[] = $factura;
            }
    
            echo json_encode(array('status'=> TRUE, 'facturas' => $facturas));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al consultar las facturas', 'error' => $e->getMessage()));
            die();
        }
    }

    public function send_pdf($data)
    {
        $IDTicket = $data['IDTicket'];
        
        // * configuracion_sistema
		$sql = 'SELECT 
            *
        FROM
            configuracion_sistema';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute();

        $configuracion_sistema = $stmt->fetch(PDO::FETCH_ASSOC);

        $sql = 'SELECT 
                    *
                FROM
                    ticket
                WHERE
                    IDTicket = :IDTicket';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute(array (':IDTicket' => $data['IDTicket']));

        $ticket = $stmt->fetch(PDO::FETCH_ASSOC);

        $date = explode("-", $ticket['FechaFactura']);
		$year = $date[0];
		$month = $date[1];
		// subfolders xml
        $rutaXML = $configuracion_sistema['rutaXML'] . '/' . $year . '/' . $month;
        $rutaPDF = $configuracion_sistema['rutaPDF'] . '/' . $year . '/' . $month;

        require 'MandaCorreos/FuncionSendMailCFDI.php';

        $body = file_get_contents('templates/mail_cfdi.php');

        $ruta_xml = 'config.xml';
        $xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
        // echo var_dump($xml_config);
        $asunto = $xml_config->Correos->asunto_correo_notificacion_cfdi . $data['IDTicket'];

        $arr_campos_reemplazar = array('<<IDTICKET>>');
        // Verificar configuracion modo de pruebas 
        $ruta_xml = 'config.xml';
        $xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
        // echo var_dump($xml_config);

        $arr_campos = array($IDTicket);

        $body = str_replace($arr_campos_reemplazar, $arr_campos, $body);
        $correos_notificar = $data['arrCorreos'];

        if ( ! SendMail($correos_notificar, $correos_notificar, $asunto, $body, '', '', '', $IDTicket, $rutaXML, $rutaPDF)) {
            echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
            die();
        }

        echo json_encode(array('status'=>true, 'msg'=>'Se han enviado los documentos'));
        die();
    }

    public function Encripta($cadena, $tipo = 0){
        $salida = "";
        if ($tipo === 0) {
            $cadInv = strrev(str_replace(" ", "--SPACE--", $cadena));
            for($i=0; $i < strlen($cadInv); $i++) {
                    $asc = ord($cadInv[$i]);
                    $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));
                }
            $salida = base64_encode($salida);
        } else {
            $cadInv = base64_decode($cadena);
            for($i=0; $i < strlen($cadInv); $i++) {
                $asc = ord($cadInv[$i]);
                $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));            
            }
            $salida = str_replace("--SPACE--"," ",strrev($salida));
        }
        return $salida;
    }
}

$data = json_decode(file_get_contents("php://input"), true);
if (isset($data['method'])){
    $objFacturas = new Facturas();
    if ($data['method'] === 'get_facturas') {
        $objFacturas->get_facturas($data);
    } else if ($data['method'] === 'send_pdf') {
        $objFacturas->send_pdf($data);
    }
}