<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: *');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require 'conexion/Conexion.php';
class GetCFDI extends Conexion {

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt))
            $stmt->closeCursor();
    }

    public function get_pdf($data)
    {
        $IDTicket = $data['ticket'];
        
        // * configuracion_sistema
		$sql = 'SELECT 
            *
        FROM
            configuracion_sistema';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute();

        $configuracion_sistema = $stmt->fetch(PDO::FETCH_ASSOC);

        $sql = 'SELECT 
                    ticket.IDTicket as IDTicket,
                    facturas.FechaTimbrado as FechaTimbrado
                FROM
                    ticket JOIN factura_tickets ON
                    ticket.IDTicket = factura_tickets.IDTicket
                    JOIN facturas ON
                    factura_tickets.UUID = facturas.UUID
                WHERE
                    ticket.IDTicket = :IDTicket';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute(array (':IDTicket' => $IDTicket));

        $ticket = $stmt->fetch(PDO::FETCH_ASSOC);

        $date = explode("-", $ticket['FechaTimbrado']);
		$year = $date[0];
		$month = $date[1];
		// subfolders xml
        $rutaPDF = $configuracion_sistema['rutaPDF'] . '/' . $year . '/' . $month;

        $IDTicket = str_replace('/', '_', $IDTicket);

        $ruta_xml = 'config.xml';
        $xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
        $TipoDocto = str_replace(' ', '_', $xml_config->Doce->TipoDocto);
    
        
        $pdf = base64_encode(file_get_contents($rutaPDF . '/' . $TipoDocto . '_' . $IDTicket . '.pdf'));
        echo json_encode(array('pdf' => $pdf));
    }

    public function get_xml($data)
    {
        $IDTicket = $data['ticket'];
        
        // * configuracion_sistema
		$sql = 'SELECT 
            *
        FROM
            configuracion_sistema';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute();

        $configuracion_sistema = $stmt->fetch(PDO::FETCH_ASSOC);

        $sql = 'SELECT 
                    ticket.IDTicket as IDTicket,
                    facturas.FechaTimbrado as FechaTimbrado
                FROM
                    ticket JOIN factura_tickets ON
                    ticket.IDTicket = factura_tickets.IDTicket
                    JOIN facturas ON
                    factura_tickets.UUID = facturas.UUID
                WHERE
                    ticket.IDTicket = :IDTicket';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute(array (':IDTicket' => $IDTicket));

        $ticket = $stmt->fetch(PDO::FETCH_ASSOC);

        $date = explode("-", $ticket['FechaTimbrado']);
		$year = $date[0];
		$month = $date[1];
		// subfolders xml
        $rutaXML = $configuracion_sistema['rutaXML'] . '/' . $year . '/' . $month;

        $IDTicket = str_replace('/', '_', $IDTicket);

        $ruta_xml = 'config.xml';
        $xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
        $TipoDocto = str_replace(' ', '_', $xml_config->Doce->TipoDocto);

        $xml = base64_encode(file_get_contents($rutaXML . '/' . $TipoDocto . '_' . $IDTicket . '.xml'));
        echo json_encode(array('xml' => $xml));
    }
}

$data = json_decode(file_get_contents("php://input"), true);
if (isset($data['method'])){
    $objCFDI = new GetCFDI();
    if ($data['method'] === 'get_pdf') {
        $objCFDI->get_pdf($data);
    } else if ($data['method'] === 'get_xml') {
        $objCFDI->get_xml($data);
    }
}