<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require_once 'conexion/Conexion.php';
class Session extends Conexion {
    public $user;
    public $pass;

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt))
            $stmt->closeCursor();
    }

    public function login()
    {
        $sql = 'SELECT 
                   *
                FROM
                    usuarios
                WHERE
                    username = :username AND
                    password = :password';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute(array(
            ':username' => $this->user,
            ':password' => $this->Encripta($this->pass)));
        
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            if (!$user['activo']) {
                echo json_encode(array('status'=> FALSE, 'msg' => 'No se ha confirmado la cuenta del usuario ingresado'));
                die();
            }
            $this->set_session($user);
        } else {
            echo json_encode(array('status'=> FALSE, 'msg' => 'Usuario o contraseña incorrectos'));
        }
    }

    private function set_session($user)
    {
        //echo json_encode( array('status' => TRUE));
        session_name('facticket_xii');
        session_start();

        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_username'] = $user['username'];
        $_SESSION['user_type'] = $user['tipo'];
        $_SESSION['user_mail'] = $user['correo'];
        // $_SESSION['user_emp_id'] = $user['emp_id'];

        $this->get_session(TRUE);
    }

    public function get_session($login_call = FALSE) {
        if ( ! $login_call) {
            session_name('facticket_xii');
            session_start();
        } 

        if ( isset($_SESSION['user_username']))
            echo json_encode( array('status' => TRUE, 'session' => $_SESSION) );
        else
            echo json_encode( array('status' => FALSE) );
    }

    public function logout() {
        session_name('facticket_xii');
        session_start();

        session_unset();
        session_destroy();
        
        echo json_encode( array('status' => TRUE, 'session' => $_SESSION) );
    }

    public function Encripta($cadena, $tipo = 0){
        $salida = "";
        if ($tipo === 0) {
            $cadInv = strrev(str_replace(" ", "--SPACE--", $cadena));
            for($i=0; $i < strlen($cadInv); $i++) {
                    $asc = ord($cadInv[$i]);
                    $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));
                }
            $salida = base64_encode($salida);
        } else {
            $cadInv = base64_decode($cadena);
            for($i=0; $i < strlen($cadInv); $i++) {
                $asc = ord($cadInv[$i]);
                $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));            
            }
            $salida = str_replace("--SPACE--"," ",strrev($salida));
        }
        return $salida;
    }

}

$data = json_decode(file_get_contents("php://input"), true);
if (isset($data['method'])){
    $objSession = new Session();
    if ($data['method'] === 'login') {
        $objSession->user = $data['user'];
        $objSession->pass = $data['pass'];
        $objSession->login();
    } else if ($data['method'] === 'logout') {
        $objSession->logout();
    } else if ($data['method'] === 'get_session') {
        $objSession->get_session();
    }
}