<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require 'conexion/Conexion.php';
class Tickets extends Conexion {

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt))
            $stmt->closeCursor();
    }

    public function get_tickets($data)
    {
        try {
            $sql = '';
            if ($data['ticketTipo'] === 'facturados') {
                $sql = 'SELECT 
                            ticket.IDTicket,
                            ticket.Fecha as TicketFecha,
                            ticket.Total as TicketTotal,
                            facturas.Serie as FacturaSerie,
                            facturas.Folio as FacturaFolio,
                            facturas.Fecha as FacturaFecha,
                            facturas.FechaTimbrado as FacturaFechaTimbrado,
                            facturas.UUID as FacturaUUID,
                            facturas.Total as FacturaTotal,
                            facturas.usuario as Usuario
                        FROM
                            ticket 
                            JOIN factura_tickets ON
                            ticket.IDTicket = factura_tickets.IDTicket
                            JOIN facturas ON
                            factura_tickets.UUID = facturas.UUID';
            } else if ($data['ticketTipo'] === 'noFacturados'){
                $sql = 'SELECT 
                            ticket.IDTicket,
                            ticket.Fecha as TicketFecha,
                            ticket.Total as TicketTotal
                        FROM
                            ticket';
            } else if ($data['ticketTipo'] === 'facturadosYNoFacturados') {
                $sql = 'SELECT 
                            ticket.IDTicket,
                            ticket.Fecha as TicketFecha,
                            ticket.Total as TicketTotal,
                            facturas.Serie as FacturaSerie,
                            facturas.Folio as FacturaFolio,
                            facturas.Fecha as FacturaFecha,
                            facturas.FechaTimbrado as FacturaFechaTimbrado,
                            facturas.UUID as FacturaUUID,
                            facturas.Total as FacturaTotal,
                            facturas.usuario as Usuario
                        FROM
                            ticket 
                            LEFT JOIN factura_tickets ON
                            ticket.IDTicket = factura_tickets.IDTicket
                            LEFT JOIN facturas ON
                            factura_tickets.UUID = facturas.UUID';
            }
                
            if ($data['filtroTipo'] === 'ticket') {
                $sql .= ' WHERE
                    ticket.Fecha >= :from
                    AND ticket.Fecha <= :to';
            } else if ($data['filtroTipo'] === 'factura') {
                $sql .= ' WHERE
                    facturas.FechaTimbrado >= :from
                    AND facturas.FechaTimbrado <= :to';
            }

            if ($data['ticketTipo'] === 'noFacturados'){
                $sql .= ' AND ticket.Status = "No Facturado"';
            }

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute(array (':from' => $data['from'] . ' 00:00:00',
                                    ':to' => $data['to'] . ' 23:59:59'));
        
            $tickets = array();
            while ($ticket = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $tickets[] = $ticket;
            }

            echo json_encode(array('status'=> TRUE, 'tickets' => $tickets));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al consultar los tickets', 'error' => $e->getMessage()));
            die();
        }
    }
}

$data = json_decode(file_get_contents("php://input"), true);
if (isset($data['method'])){
    $objTickets = new Tickets();
    if ($data['method'] === 'get_tickets') {
        $objTickets->get_tickets($data);
    }
}