<?php
/* ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL); */
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token');

require 'conexion/Conexion.php';
class User extends Conexion {

    public function __construct() {
        parent::__construct();
    }
    
    public function __destruct() {
        if (isset($stmt)) {
            // $stmt->closeCursor();
        }
    }

    public function get_users()
    {
        $sql = 'SELECT 
                   *
                FROM
                    usuarios';

        $stmt = $this->conexion_db->prepare($sql);
        $stmt->execute();
        
        $users = array();
        while ($user = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $user['password'] = $this->Encripta($user['password'], 1);
            $users[] = $user;
        }

        echo json_encode(array('status'=> TRUE, 'users' => $users));
    }

    public function create_user($data)
    {
        try {
            $sql = 'INSERT INTO usuarios (username, password, tipo, correo, activo, fecha_insercion, fecha_modificacion)
                    VALUES (:username, :pass, :tipo, :correo, 1, NOW(), NOW())';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':username' => $data['usuario'], 
                                    ':pass' => $this->Encripta($data['contra']),
                                    ':tipo' => $data['tipo'],
                                    ':correo' => $data['correo']));

            $sql = 'INSERT INTO datos_facturacion (rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario)
                    VALUES (:rfc,
                            :taxID,
                            :razonSocial,
                            :contacto,
                            :telefono,
                            :calle,
                            :noExt,
                            :noInt,
                            :colonia,
                            :codigoPostal,
                            :municipio,
                            :estado,
                            :usuario)';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':rfc' => '',
                                    ':taxID' => '',
                                    ':razonSocial' => '',
                                    ':contacto' => '',
                                    ':telefono' => '',
                                    ':calle' => '',
                                    ':noExt' => '',
                                    ':noInt' => '',
                                    ':colonia' => '',
                                    ':codigoPostal' => '',
                                    ':municipio' => '',
                                    ':estado' => '',
                                    ':usuario' => $data['usuario']));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Usuario insertado'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error: '.$e->getMessage(), 'error' => $e->getMessage()));
            die();
        }
    }

    public function valida_rfc1($valor){
        $valor = str_replace("-", "", $valor); 
        $cuartoValor = substr($valor, 3, 1);
        //RFC sin homoclave
        if(strlen($valor)==10){
            $letras = substr($valor, 0, 4); 
            $numeros = substr($valor, 4, 6);
            if (ctype_alpha($letras) && ctype_digit($numeros)) { 
                return true;
            }
            return false;          
        }
        // Sólo la homoclave
        /* else if (strlen($valor) == 3) {
            $homoclave = $valor;
            if(ctype_alnum($homoclave)){
                return true;
            }
            return false;
        } */
        //RFC Persona Moral.
        else if (ctype_digit($cuartoValor) && strlen($valor) == 12) { 
            $letras = substr($valor, 0, 3); 
            $numeros = substr($valor, 3, 6); 
            $homoclave = substr($valor, 9, 3); 
            if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
                return true; 
            } 
            return false;
        //RFC Persona Física. 
        } else if (ctype_alpha($cuartoValor) && strlen($valor) == 13) { 
            $letras = substr($valor, 0, 4); 
            $numeros = substr($valor, 4, 6);
            $homoclave = substr($valor, 10, 3); 
            if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
                return true; 
            }
            return false; 
        }else { 
            return false; 
        }  
    }//fin validaRFC

    public function create_userFacturacion($data)
    {
        // validar RFC
        if (!$this->valida_rfc1($data['rfc'])) {
            echo json_encode(array('status'=> FALSE, 'msg'=> 'Formato de RFC no válido'));
            die();
        }

        try {

            $sql = 'INSERT INTO usuarios (username, password, tipo, correo, activo)
                    VALUE (:username,
                            :password,
                            :tipo,
                            :correo,
                            :activo)';
            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':username' => (string) $data['usuario'], 
                                    ':password' => (string) $this->Encripta($data['contra']),
                                    ':tipo' => (string) 'Cliente',
                                    ':correo' => (string) $data['correo'],
                                    ':activo' => (int) 0));
            $last_id = $this->conexion_db->lastInsertId();

            $sql = 'INSERT INTO datos_facturacion (rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario, regimen_fiscal)
                    VALUES (:rfc,
                            :taxID,
                            :razonSocial,
                            :contacto,
                            :telefono,
                            :calle,
                            :noExt,
                            :noInt,
                            :colonia,
                            :codigoPostal,
                            :municipio,
                            :estado,
                            :usuario,
							:regimen_fiscal)';

            $stmt = $this->conexion_db->prepare($sql);
			$params = array (':rfc' => $data['rfc'],
                                    ':taxID' => $data['taxID'],
                                    ':razonSocial' => $data['razonSocial'],
                                    ':contacto' => $data['contacto'],
                                    ':telefono' => $data['telefono'],
                                    ':calle' => $data['calle'],
                                    ':noExt' => $data['noExt'],
                                    ':noInt' => $data['noInt'],
                                    ':colonia' => $data['colonia'],
                                    ':codigoPostal' => $data['cp'],
                                    ':municipio' => $data['municipio'],
                                    ':estado' => $data['estado'],
                                    ':usuario' => $data['usuario'],
                                    ':regimen_fiscal' => $data['regimen_fiscal']);
			
            $stmt->execute($params);
									

            $this->send_mail_registrar($data['usuario'], $data['correo']);
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            $msg = 'Error al registrar al usuario.';
            if ($e->getCode() == '23000') {
                $msg .= ' El nombre de usuario "' . $data['usuario'] . '" no está disponible';
            }
            echo json_encode(array('status'=> FALSE, 'msg' => $msg, 'error' => $e->getMessage(), 'linea' => $e->getLine(), 'code' => $e->getCode()));
            die();
        }
    }

    public function update_user($data)
    {
        try {

            $sql = 'UPDATE 
                        usuarios
                    SET 
                        password = :password,
                        tipo = :tipo,
                        correo = :correo,
                        fecha_modificacion = NOW()
                    WHERE
                        id = :id';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':password' => $this->Encripta($data['contra']),
                                    ':tipo' => $data['tipo'],
                                    ':correo' => $data['correo'],
                                    ':id' => $data['id']));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Usuario actualizado'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al insertar el usuario. Verifique que el nombre de usuario no exista', 'error' => $e->getMessage()));
            die();
        }
    }

    public function delete_user($data)
    {
        try {
            $sql = 'DELETE FROM 
                        datos_facturacion
                    WHERE
                        usuario = :usuario';

            $stmt = $this->conexion_db->prepare($sql);
            
            $stmt->execute( array (':usuario' => $data['usuario']));
            
            $sql = 'DELETE FROM 
                        usuarios
                    WHERE
                        id = :id';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':id' => $data['id']));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Usuario eliminado'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al eliminar el usuario', 'error' => $e->getMessage()));
            die();
        }
    }

    public function update_pass($data)
    {
        try {
            $sql = 'UPDATE 
                        usuarios
                    SET
                        password = :password
                    WHERE
                        username = :username';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':password' => $this->Encripta($data['pass']), 
                                ':username' => base64_decode($data['user'])));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Contraseña actualizada'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar la contraseña', 'error' => $e->getMessage()));
            die();
        }
    }

    public function register_user($data)
    {
        try {
            $sql = 'UPDATE 
                        usuarios
                    SET
                        activo = 1
                    WHERE
                        username = :username';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array ( ':username' => base64_decode($data['user'])));
        
            echo json_encode(array('status'=> TRUE, 'msg' => 'Usuario activado'));
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al activar al usuario', 'error' => $e->getMessage()));
            die();
        }
    }

    public function send_mail_registrar($username, $correo) {
        require 'MandaCorreos/FuncionSendMail.php';

        $body = file_get_contents('templates/mail_registrar.php');

        $arr_campos_reemplazar = array('<<USUARIO_NOMBRE>>', '<<USUARIO_TOKEN>>', '<<URL_BASE>>');
        // Verificar configuracion modo de pruebas 
        $ruta_xml = 'config.xml';
        $xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
        // echo var_dump($xml_config);
        $asunto = $xml_config->Correos->asunto_correo_registro;

        $arr_campos = array($username, base64_encode($username), $xml_config->Server->URL_API);

        $body = str_replace($arr_campos_reemplazar,$arr_campos,$body);

        if ($xml_config->sendmail->modo_test == 'SI') {
            $correos_notificar = explode(',', $xml_config->sendmail->correos_notificar_recordar);
            array_push($correos_notificar, $correo);

            if ( ! SendMail($correos_notificar, $correos_notificar, $asunto,$body, '', '', '')){
                echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
                die();
            }
        } else {
            $correo_notificar = $correo;
            // var_dump($correos_notificar);
            // die();
            if ( ! SendMail($correo_notificar, $correo_notificar, $asunto,$body, '', '', '')){
                echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
                die();
            }
        }

        echo json_encode(array('status'=> TRUE, 'msg' => 'Usuario registrado. Se ha enviado un link de activación a su correo'));
        die();
    }

    public function send_mail_remember($username, $correo) {
        require 'MandaCorreos/FuncionSendMail.php';

        $body = file_get_contents('templates/mail_recordar.php');
        
        $arr_campos_reemplazar = array('<<USUARIO_NOMBRE>>', '<<USUARIO_TOKEN>>', '<<URL_BASE>>');
        // Verificar configuracion modo de pruebas 
        $ruta_xml = 'config.xml';
        $xml_config = simplexml_load_file($ruta_xml) or die("Error: Cannot create object");
        // echo var_dump($xml_config);
        $asunto = $xml_config->Correos->asunto_correo_recordar_contra;

        $arr_campos = array($username, base64_encode($username), $xml_config->Server->URL_API);

        $body = str_replace($arr_campos_reemplazar,$arr_campos,$body);

        if ($xml_config->sendmail->modo_test == 'SI') {
            $correos_notificar = explode(',', $xml_config->sendmail->correos_notificar_recordar);
            array_push($correos_notificar, $correo);

            if ( ! SendMail($correos_notificar, $correos_notificar, $asunto,$body, '', '', '')){
                echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
                die();
            }
        } else {
            $correo_notificar = $correo;
            // var_dump($correos_notificar);
            // die();
            if ( ! SendMail($correo_notificar, $correo_notificar, $asunto,$body, '', '', '')){
                echo json_encode(array('status'=>false,'msg'=> 'Error al enviar el correo'));    
                die();
            }
        }

        echo json_encode(array('status'=>true, 'msg'=>'Se ha enviado un correo a la cuenta del usuario', 'asunto'=> $asunto));
        die();
    }

    public function remember_user($data)
    {

        try {
            $sql = 'SELECT 
                        *
                    FROM
                        usuarios
                    WHERE username = :username';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':username' => $data['user']));
            
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($user) {
                $this->send_mail_remember($user['username'], $user['correo']);
            } else {
                echo json_encode(array('status'=> FALSE, 'msg' => 'El usuario ingresado no existe'));
            die();
            }

        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al insertar el usuario', 'error' => $e->getMessage()));
            die();
        }
    }

    public function get_datos_facturacion($data)
    {
        try {
            $sql = 'SELECT 
                        id, rfc, taxID, razonSocial, contacto, telefono, calle, noExt, noInt, colonia, codigoPostal, municipio, estado, usuario, fecha_insercion, fecha_modificacion, regimen_fiscal
                    FROM
                        datos_facturacion
                    WHERE usuario = :usuario';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':usuario' => $data['usuario']));
            
            $datos_facturacion = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($datos_facturacion) {
                echo json_encode(array('status'=>TRUE, 'datos_facturacion'=> $datos_facturacion));
            } else {
                echo json_encode(array('status'=>FALSE, 'msg'=> 'No se encontraron datos de facturación del usuario'));
            }
            die();
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al consultar datos de facturación del usuario', 'error' => $e->getMessage()));
            die();
        }
    }

    public function update_datos_facturacion($data)
    {
        if (!$this->valida_rfc1($data['rfc'])) {
            echo json_encode(array('status'=> FALSE, 'msg'=> 'Formato de RFC no válido'));
            die();
        }

        try {
            $sql = 'UPDATE 
                        datos_facturacion
                    SET
                        rfc = :rfc,
                        taxID = :taxID,
                        razonSocial = :razonSocial,
                        contacto = :contacto,
                        telefono = :telefono,
                        calle = :calle,
                        noExt = :noExt,
                        noInt = :noInt,
                        colonia = :colonia,
                        codigoPostal = :codigoPostal,
                        municipio = :municipio,
                        estado = :estado,
						regimen_fiscal = :regimen_fiscal,
                        fecha_modificacion = NOW()
                    WHERE usuario = :usuario';

            $stmt = $this->conexion_db->prepare($sql);
            $stmt->execute( array (':rfc' => $data['rfc'],
                                ':taxID' => $data['taxID'],
                                ':razonSocial' => $data['razonSocial'],
                                ':contacto' => $data['contacto'],
                                ':telefono' => $data['telefono'],
                                ':calle' => $data['calle'],
                                ':noExt' => $data['noExt'],
                                ':noInt' => $data['noInt'],
                                ':colonia' => $data['colonia'],
                                ':codigoPostal' => $data['codigoPostal'],
                                ':municipio' => $data['municipio'],
                                ':estado' => $data['estado'],
                                ':usuario' => $data['usuario'],
                                ':regimen_fiscal' => $data['regimen_fiscal'],
                            ));
            
            echo json_encode(array('status'=>TRUE, 'msg'=> 'Datos actualizados'));
            die();
        } catch (Exception $e) {
            // echo "La linea de error es:" . $e->getLine() . "<br>";
            // echo "Mensaje:" . $e->getMessage();
            echo json_encode(array('status'=> FALSE, 'msg' => 'Error al actualizar datos de facturación del usuario', 'error' => $e->getMessage()));
            die();
        }
    }

    public function Encripta($cadena, $tipo = 0){
        $salida = "";
        if ($tipo === 0) {
            $cadInv = strrev(str_replace(" ", "--SPACE--", $cadena));
            for($i=0; $i < strlen($cadInv); $i++) {
                    $asc = ord($cadInv[$i]);
                    $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));
                }
            $salida = base64_encode($salida);
        } else {
            $cadInv = base64_decode($cadena);
            for($i=0; $i < strlen($cadInv); $i++) {
                $asc = ord($cadInv[$i]);
                $salida.=utf8_encode(chr((intval($asc) ^ intval(5))));            
            }
            $salida = str_replace("--SPACE--"," ",strrev($salida));
        }
        return $salida;
    }

}

$data = json_decode(file_get_contents("php://input"), true);
if (isset($data['method'])){
    $objUser = new User();
    if ($data['method'] === 'get_users') {
        $objUser->get_users();
    } else if ($data['method'] === 'create_user') {
        $objUser->create_user($data);
    } else if ($data['method'] === 'update_user') {
        $objUser->update_user($data);
    } else if ($data['method'] === 'delete_user') {
        $objUser->delete_user($data);
    } else if ($data['method'] === 'remember_user') {
        $objUser->remember_user($data);
    } else if ($data['method'] === 'create_userFacturacion') {
        $objUser->create_userFacturacion($data['usuarioFacturacion']);
    } else if ($data['method'] === 'update_pass') {
        $objUser->update_pass($data);
    } else if ($data['method'] === 'register_user') {
        $objUser->register_user($data);
    } else if ($data['method'] === 'get_datos_facturacion') {
        $objUser->get_datos_facturacion($data);
    } else if ($data['method'] === 'update_datos_facturacion') {
        $objUser->update_datos_facturacion($data['datosFacturacion']);
    } 
}
