<?php
require __DIR__.'/vendor/autoload.php';

use Spipu\Html2Pdf\Html2Pdf;

$html2pdf = new Html2Pdf();
$namePDF = str_replace('/', '_', $namePDF);
$path = str_replace('index.php', '', __FILE__);

$nombreQR = uniqid('qr') . $namePDF . '.png';
file_put_contents($path . '/' . $nombreQR, base64_decode($qr64));
$html = <<<EOD
<page backtop="10mm" backbottom="10mm" backleft="20mm" backright="20mm">
    <page_header>
        <table>
            <tr style="height:100px">
                <td style="width:100px">
                    <img src="$path/assa_logos.png">
                </td>
                <td style="vertical-align: top; font-size: 11px;">
                    <div style="margin-left: 50px;">
                        <p style="margin-left: 20px; margin-bottom: 0px; padding-bottom: 0px"><b>ASSA ABLOY Mexico S.A. DE C.V.</b></p>
                        <p style="margin: 0"><b style="margin-right: 30px;">Dirección: </b> Pelicano 242   Granjas Modernas</p>
                        <p style="margin: 0">Ciudad de Mexico ,Gustavo A Madero ,Ciudad de Mexico, 07460</p>
                        <p style="margin: 0">R.F.C.: AAM961204CI1</p>
                        <p style="margin: 0">Régimen Fiscal: 601 - General de Ley Personas Morales</p>
                    </div>
                </td>
            </tr>
        </table>
    </page_header>
    <page_footer>
        <table>
            <tr>
                <td>
                    <p style="font-size: 7px; font-weight: bold">
                        Conmutador: 01 (55) 5118 0000* Lada sin costo: 01 (800) 702 89* Fax: 01 (55) 5118 0017 www.phillips.com.mx , www.yalemexico.com , www.tesa.com.mx servicioclientes@assaabloymexico.com
                    </p>
                </td>
                <td>
                    <p style="font-size: 10px; font-weight: bold; margin-left: 55px">
                        PAGINA [[page_cu]]/[[page_nb]]
                    </p>
                </td>
            </tr>
        </table>
    <img src="$path/page_separator.png" style="width 720px">
    </page_footer>
    <br>
    <table style="width: 720px; margin-left: -72px; margin-top: 50px; font-size: 11px">
        <tr style="height:100px">
            <td style="width:480px; vertical-align: top;">
                <div style="border: solid 1px #C0C0C0; width: 478px" >
                    <div style="background: #C0C0C0;">
                        <p style="margin-top: 0; font-weight: bold;">VENDIDO A:</p>
                    </div>
                    <p style="margin: 0">
                        $clienteRazonSocial
                    </p>
                    <p style="margin: 0">
                        $clienteDireccion
                    </p>
                    <p style="margin: 0">
                        $clienteCiudad $clienteCP
                    </p>
                    <br>
                </div>
                <div style="border: solid 1px #C0C0C0; width: 480px">
                    <table>
                        <tr style="width: 100px">
                            <td style="width: 115px">
                                <p><b>AGENTE:</b></p>
                            </td>
                            <td style="width: 115px">
                                <p><b>CLIENTE:</b></p>
                            </td>
                            <td style="width: 180px">
                                <p><b>R.F.C.:</b>$clienteRFC</p>
                            </td>
                        </tr>
                    </table>
                    <p style="margin-bottom: 27px;">UsoCFDI: $UsoCFDI - $UsoCFDIDescripcion</p>
                    <br>
                </div>
                <br>
                        <table style="width: 100px; margin-left: -3px">
                            <tr style="width: 100px; margin: 0">
                                <td style="width: 300px; margin: 0;">
                                    <div style="border: solid 1px #C0C0C0;">
                                        <div style="background: #C0C0C0;">
                                            <p style="font-weight: bold; margin-top: 0;" margin: 0>ENVIAR A:</p>
                                        </div>
                                        <p>$lugar_entrega_1</p>
                                        <p>$lugar_entrega_2</p> 
                                        <br>
                                    </div>
                                </td>
                                <td style="width: 167px; margin: 0;">
                                    <div style="border: solid 1px #C0C0C0; min-height: 400px">
                                    <div style="background: #C0C0C0;">
                                        <p style="margin-top:0; font-weight: bold;">REMITIDO POR:</p>
                                    </div>
                                    <p style="margin-bottom: 10px"></p>
                                        <br><br><br><br><br>
                                    </div>
                                </td>
                            </tr>
                        </table>
                    <table style="width: 100px; margin-left: -3px">
                        <tr style="width: 100px;">
                            <td style="width: 100px;">
                                <div style="border: solid 1px #C0C0C0; height: 40px">
                                <div style="background: #C0C0C0;">
                                <p style=" margin-top: 0; background: #C0C0C0; font-weight: bold; text-align: center">SERIE</p>
                                </div>
                                    <p style="text-align: center; padding-bottom:">$serie</p>
                                </div>
                            </td>
                            <td style="width: 100px;">
                                <div style="border: solid 1px #C0C0C0; height: 40px">
                                <div style="background: #C0C0C0;">
                                <p style=" margin-top: 0; background: #C0C0C0; font-weight: bold; text-align: center">FOLIO</p>
                                </div>
                                    <p style="text-align: center; padding-bottom:">$folio</p>
                                </div>
                            </td>
                            <td style="width: 100px;">
                                <div style="border: solid 1px #C0C0C0; height: 40px">
                                <div style="background: #C0C0C0;">
                                <p style=" margin-top: 0; background: #C0C0C0; font-weight: bold; text-align: center">ORDEN COMPRA</p>
                                </div>
                                    <p style="text-align: center; padding-bottom:">27</p>
                                </div>
                            </td>
                            <td style="width: 151px;">
                                <div style="border: solid 1px #C0C0C0; height: 40px">
                                <div style="background: #C0C0C0;">
                                <p style=" margin-top: 0; background: #C0C0C0; font-weight: bold; text-align: center">CLAVE CATASTRAL</p>
                                </div>
                                    <p style="text-align: center; padding-bottom:"><br></p>
                                </div>
                            </td>
                        </tr>
                    </table>
            </td>
            <td style="text-align: center; vertical-align: top; width: 250px; margin-left: -3px; border: solid 1px #C0C0C0;">
                <div style="margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold; margin: 5;">FACTURA</p>
                </div>
                <div style="background: #C0C0C0; margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold">CP - Fecha y hora de Certificación</p>
                </div>
                <div style="margin-right: 125px; margin-left: -128px">
                    <p>$lugarExpedicion - $fechaTimbrado </p>
                </div>
                <div style="background: #C0C0C0; margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold">Folio Fiscal</p>
                </div>
                <div style="margin-right: 125px; margin-left: -128px">
                    <p>$folioFiscal</p>
                </div>
                <div style="background: #C0C0C0; margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold">Número de Certificado SAT</p>
                </div>
                <div style="margin-right: 125px; margin-left: -128px">
                    <p>$noCertificadoSAT</p>
                </div>
                <div style="background: #C0C0C0; margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold">Número de Certificado Emisor</p>
                </div>
                <div style="margin-right: 125px; margin-left: -128px">
                    <p>$noCertificado</p>
                </div>
                <div style="background: #C0C0C0; margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold">Forma de Pago</p>
                </div>
                <div style="margin-right: 125px; margin-left: -128px">
                    <p>$formaPago - $formaPagoDescripcion</p>
                </div>
                <div style="background: #C0C0C0; margin-right: 125px; margin-left: -128px">
                    <p style="font-weight: bold">Método de Pago</p>
                </div>
                <div style="margin-right: 125px; margin-left: -128px; height: 15px">
                    <p>$metodoPago - $metodoPagoDescripcion</p>
                </div>
            </td>
        </tr>
    </table>
    <br>
    <table style="width: 600px; margin-left: -72px; font-size: 11px">
        <tr style="width: 600px">
            <td style="width: 70px;">
            <div style="background: #C0C0C0;">
                <p style="margin-top: 0; font-weight: bold;">ARTICULO</p>
            </div>
                <p>$conceptosArticulos</p>
            </td>
            <td style="width: 70px;">
                <div style="background: #C0C0C0; margin-left: -5px">
                    <p style="margin-top: 0; font-weight: bold;">CANTIDAD</p>
                </div>
                <p>$conceptosCantidad</p>
            </td>
            <td style="width: 310px;">
                <div style="background: #C0C0C0; margin-left: -5px">
                    <p style="margin-top: 0; font-weight: bold;">DESCRIPCION</p>
                </div>  
                <p>$conceptosDescripcion</p>
            </td>
            <td style="width: 60px;">
                <div style="background: #C0C0C0; margin-left: -5px">
                    <p style="margin-top: 0; font-weight: bold;">U.M</p>
                </div>
                <p>$conceptosUM</p>
            </td>
            <td style="width: 115px">
                <div style="background: #C0C0C0; margin-left: -5px">
                    <p style="margin-top: 0; font-weight: bold;">PRECIO UNITARIO</p>
                </div>
                <p>$conceptosPrecioUnitario</p>
            </td>
            <td style="width: 80px;">
                <div style="background: #C0C0C0; margin-left: -5px">
                    <p style="margin-top: 0; font-weight: bold;">IMPORTE</p>
                </div>
                <p>$conceptosImporte</p>
            </td>
        </tr>
    </table>
    <div style="margin-top: 50px; border: solid 1px #C0C0C0; word-wrap:break-word; margin-left: -72px; width: 740px; font-size: 8px">
        <div style="background: #C0C0C0;">
            <p style="background: #C0C0C0; font-weight: bold;">IMPORTE EN LETRAS</p>
        </div>
        <p style="margin: 3">$importeEnLetras</p>
        <p style="margin: 3">Expedido en $lugarExpedicion a $fechaExpedido</p>
        <p style="margin: 3">SE COBRARA 20 % SOBRE EL VALOR DE CHEQUE DEVUELTO POR FALTA DE FONDOS, LEY GENERAL DE TITULOS Y OPERACIONES DE CRÉDITO</p>
        <div style="background: #C0C0C0;">
            <p style="background: #C0C0C0; font-weight: bold;">SELLO DIGITAL DEL CFDI</p>
        </div>
        <p style="word-wrap: break-word;">$selloDigitalCFDI</p>
        <div style="background: #C0C0C0;">
            <p style="background: #C0C0C0; font-weight: bold;">SELLO DIGITAL DEL SAT</p>
        </div>
        <p style="word-wrap: break-word;">$selloDigitalSAT</p>
        <div style="background: #C0C0C0;">
            <p style="background: #C0C0C0; font-weight: bold;">CADENA ORIGINAL DEL COMPLEMENTO DE CERTIFICACION DIGITAL DEL SAT</p>
        </div>
        <p style="word-wrap: break-word;">$cadenaOriginalSAT</p>
    </div>
    <end_last_page end_height="60mm">
        <table style="width: 700px; margin-left: -72px; font-size: 11px">
            <tr style="margin-top: 100px;">
                <td style="width: 150px;">
                    <img src="$path/$nombreQR" style="margin-top: 20px; width: 127px; margin-left: 15px">
                </td>
                <td style="width: 350px; vertical-align: top;">
                    <p style="text-align: center;">
                        Este documento es una representación impresa de un CFDI
                    </p>
                    <br>
                    <div style="border: solid 1px #C0C0C0; font-size: 8px">
                        <p>
                            DEBEMOS Y PAGAREMOS INCONDICIONALMENTE EN ESTA PLAZA A LA ORDEN DE: . LA CANTIDAD DE $total VALOR DE LOS ARTICULOS ESPECIFICADOS QUE HEMOS RECIBIDO A NUESTRA ENTERASATISFACCIÓN.
                        </p>
                        <br>
                        <br>
                        <p style="text-align:center">ACEPTAMOS <br>
                        SELLO Y FIRMA</p>
                    </div>
                    <br>
                    <div style="font-size: 8px">
                        <p style="margin: 0">
                            Referencia Bancaria: 4373230
                        </p>
                        <p style="margin: 0">
                            Efectuar su pago en PESOS: Banamex Sucursal: 0870 Cuenta: 559387 Cable: 0021-800-870-0559387-
                        </p>
                        <p style="margin: 0">
                            Efectuar su pago en DOLARES: Citibank, N. A Sucursal: 0940 Cuenta: 3691-9043 Aba: 021-0000-89 Swift: CITIUS3
                        </p>
                        <p style="margin: 0">
                            Address: 111 Wall Street Piso9, 10043 New York, USA
                        </p>
                        <p style="margin: 0">
                            LA MERCANCÍA VIAJA POR CUENTA Y RIESGO DEL COMPRADOR
                        </p>
                    </div>
                </td>
                <td style="width: 225px; vertical-align: top;">
                    <div>
                        <table style="width: 100%">
                            <tr>
                                <td style="width: 100px; vertical-align: top;">
                                <div style="background:  #C0C0C0">
                                    <p style=" margin-left: 10px; background: #C0C0C0; font-weight: bold;">SUBTOTAL:</p>
                                    <p style=" margin-left: 10px; background: #C0C0C0; font-weight: bold;">IMPUESTOS TRASLADADOS:</p>
                                    <p style=" margin-left: 10px; background: #C0C0C0; font-weight: bold;">IMPUESTOS RETENIDOS:</p>
                                    <p style=" margin-left: 10px; background: #C0C0C0; font-weight: bold;">TOTAL:</p>
                                </div>
                                </td>
                                <td style="width: 110px;">
                                    <div style="border: 1px solid #c0c0c0; margin-left: -5px; width: 130px">
                                        <p style=" margin-left: 10px; text-align: right">$$subTotal</p>
                                        <p style=" margin-left: 10px; text-align: right"><br>$$totalImpuestosTrasladados</p>
                                        <p style=" margin-left: 10px; text-align: right"><br>$totalImpuestosRetenciones</p>
                                        <p style=" margin-left: 10px; text-align: right">$$total</p>
                                    </div>
                                </td>
                            </tr>

                        </table>
                    </div>
                </td>
            </tr>
        </table>
    </end_last_page>
</page>
EOD;

$html2pdf->writeHTML($html);

$filelocation = $rutaPDF; //Linux
$namePDF = str_replace('/', '_', $namePDF);
$fileNL = $filelocation. '/' .$namePDF . '.pdf'; //Linux

$html2pdf->output($fileNL, 'F');
unlink($path . '/' . $nombreQR);
?>