<?php
require_once __DIR__ ."/config.php";
require_once __DIR__ .'/../../util/util.class.php';

class Conexion {
    protected $conexion_db;
	protected $conexion_error;
	protected $conexion_mensaje;
	
    public function __construct()
    {
        try
        {
			$util = new Util();
            $this->conexion_db = new PDO('mysql:host=' . DB_HOST .
										'; dbname=' . DB_NOMBRE
										, $util->Encripta(DB_USUARIO,1), $util->Encripta(DB_CONTRA,1));
			
            $this->conexion_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
			
			if($this->conexion_db->errorCode() != 0){
				$this->conexion_error = $this->conexion_db->errorCode();
				$mensaje = $this->conexion_mensaje = $this->conexion_db->errorInfo();
				$this->conexion_mensaje = $mensaje[2];
				return $this->conexion_db;
			}
			
            $this->conexion_db->exec("SET CHARACTER SET utf8");
			
            return $this->conexion_db;

        } catch (Exception $e) {
			$this->conexion_error = -1;
			$this->conexion_mensaje = $e->getMessage();
        }
    }
}
