<?php
require_once __DIR__ ."/conexion/Conexion.php";
class CSDSAT extends Conexion
{
	var $ERROR_NO = 0;
	var $MENSAJE = "";
	var $NUM_REGISTROS = 0;
	var $CURSOR;
	var $STMT;
	var $LAST_INSERT_ID;

	function __construct() {
		parent::__construct();
		if($this->conexion_error != 0){
			$this->ERROR_NO = $this->conexion_error;
			$this->MENSAJE = $this->conexion_mensaje;
		}
	}

	function __destruct() {
		$this->ERROR_NO = 0;
		$this->MENSAJE = "";
		if (isset($stmt))
			$stmt->closeCursor();
	}

	function qry_iu_csdsat($noSerie, $fecIni, $fecFin, $RFC, $edoCert){
		try{
			$sql = 'insert into csdsat (noSerie, fecIni, fecFin, RFC, edoCert) values (:noSerie, :fecIni, :fecFin, :RFC, :edoCert) on duplicate key update
							edoCert = :edoCert';

			$stmt = $this->conexion_db->prepare($sql);

			$stmt->execute(array(
			":noSerie" => (string) $noSerie,
			":fecIni" => (string) $fecIni,
			":fecFin" => (string) $fecFin,
			":RFC" => (string) $RFC,
			":edoCert" => (string) $edoCert
			));

			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode;
				$this->MENSAJE = $error[2];
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se inserto el registro.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->LAST_INSERT_ID = $this->conexion_db->lastInsertId();
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se inserto ".$stmt->rowCount()." registro.";
			$this->NUM_REGISTROS = $stmt->rowCount();
			return true;
		}catch(Exception $e){
			$this->ERROR_NO = 300;
			$this->MENSAJE = "Excepción: ".$e->getMessage();
			return false;
		}
	}
	function qry_u_csdsat($noSerie, $edoCert){
		try{
			$sql = 'update csdsat set edoCert = :edoCert where noSerie = :noSerie';

			$stmt = $this->conexion_db->prepare($sql);

			$stmt->execute(array(
			":noSerie" => (string) $noSerie,
			":edoCert" => (string) $edoCert
			));

			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode;
				$this->MENSAJE = $error[2];
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se inserto el registro.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->LAST_INSERT_ID = $this->conexion_db->lastInsertId();
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se inserto ".$stmt->rowCount()." registro.";
			$this->NUM_REGISTROS = $stmt->rowCount();
			return true;
		}catch(Exception $e){
			$this->ERROR_NO = 300;
			$this->MENSAJE = "Excepción: ".$e->getMessage();
			return false;
		}
	}

	function qry_u_csdsat_fechaFin($noSerie){
		try{
			$sql = 'update csdsat set fecFin = current_timestamp() where noSerie = :noSerie';

			$stmt = $this->conexion_db->prepare($sql);

			$stmt->execute(array(
			":noSerie" => (string) $noSerie
			));

			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode;
				$this->MENSAJE = $error[2];
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se inserto el registro.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->LAST_INSERT_ID = $this->conexion_db->lastInsertId();
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se inserto ".$stmt->rowCount()." registro.";
			$this->NUM_REGISTROS = $stmt->rowCount();
			return true;
		}catch(Exception $e){
			$this->ERROR_NO = 300;
			$this->MENSAJE = "Excepción: ".$e->getMessage();
			return false;
		}
	}

	function qry_s_csdsat($noSerie){
		try{
			$sql = 'SELECT noSerie,fecIni,fecFin,rfc,edoCert,fecha_i,fecha_u FROM csdsat where noSerie = :noSerie LIMIT 1';


			$stmt = $this->conexion_db->prepare($sql);

			$stmt->execute(array(':noSerie' => (string) $noSerie));

			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode;
				$this->MENSAJE = $error[2];
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se encontraron registros.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se encontraron ".$stmt->rowCount()." registros.";
			$this->NUM_REGISTROS = $stmt->rowCount();

			$this->CURSOR = $stmt->fetch(PDO::FETCH_ASSOC);

			return true;
		}catch(Exception $e){
			$this->ERROR_NO = 300;
			$this->MENSAJE = "Excepción: ".$e->getMessage();
			return false;
		}
	}
}

?>
