<?php
set_time_limit(0);
require_once('lib/nusoap/nusoap.php');
require("conexion/conectarArchivosSAT.class.php");
libxml_use_internal_errors(true);
define("LOCAL_FILE","CSD/");
define("USUARIOUTIL","disxii");
define("PASSWORDUTIL","d15x11_u71l");
date_default_timezone_set('America/Mexico_City');

$server = new soap_server();
$server->configureWSDL('wsvalidaCerwsdl', 'urn:wsvalidaCerwsdl');
$server->soap_defencoding = 'utf-8';
$server->decode_utf8 = false;
$server->wsdl->addComplexType(
    'ResultadoUtil',
    'complexType',
    'struct',
    'all',
    '',
    array(
		'status' => array('name'=>'status','type'=>'xsd:string'),
        'mensaje' => array('name'=>'mensaje','type'=>'xsd:string'),
        'Certificados' => array('name'=>'Certificados','type'=>'tns:DetalleArray')
    )
);
$server->wsdl->addComplexType(
    'DetalleArray',
    'complexType',
    'array',
    '',
    'SOAP-ENC:Array',
    array(),
    array(
        array('ref'=>'SOAP-ENC:arrayType','wsdl:arrayType'=>'tns:Detalle[]')
    ),
    'tns:Detalle'
);
$server->wsdl->addComplexType(
    'Detalle',
    'complexType',
    'struct',
    'all',
    '',
    array(
        'status' => array('name'=>'status','type'=>'xsd:string'),
        'mensaje' => array('name'=>'mensaje','type'=>'xsd:string'),
        'noSerie' => array('name'=>'noSerie','type'=>'xsd:string'),
        'rfc' => array('name'=>'rfc','type'=>'xsd:string'),
        'pac' => array('name'=>'pac','type'=>'xsd:string'),
        'tipo' => array('name'=>'tipo','type'=>'xsd:string'),
        'fecIni' => array('name'=>'fecIni','type'=>'xsd:string'),
        'fecFin' => array('name'=>'fecFin','type'=>'xsd:string'),
        'noAutorizacionPAC' => array('name'=>'noAutorizacionPAC','type'=>'xsd:string'),
		'statusValCer' => array('name'=>'statusValCer','type'=>'xsd:string'),
		'mensajeValCer' => array('name'=>'mensajeValCer','type'=>'xsd:string'),
		'statusEnBD' => array('name'=>'statusEnBD','type'=>'xsd:string'),
		'cer' => array('name'=>'cer','type'=>'xsd:string')
    )
);

/*$server->wsdl->addComplexType(
    'WSOptional',
    'complexType',
    'struct',
    'all',
    '',
    'cerB64' => array('name'=>'cerB64','type'=>'xsd:string','minOccurs' => 0, 'maxOccurs' => 1)
    )
);*/

$server->register('validaCer',                // method name
    array('usuario' => 'xsd:string','password' => 'xsd:string','noSerieTimbre' => 'xsd:string','cerB64' => 'xsd:string'),        // input parameters
    array('return' => 'tns:ResultadoUtil'),      // output parameters
    'urn:wsvalidaCerwsdl',                      // namespace
    'urn:wsvalidaCerwsdl#validaCer',                // soapaction
    'rpc',                                // style
    'encoded',                            // use
    'Regresa información de certificados y valida.'            // documentation
);
	

function validaCer($usuario,$password,$noSerieTimbre,$cerB64="") {
	
	$conexion = new CONDB();
	$conexion->conectar();
	
	$resultadoWS = new stdClass();
	$resultadoWS->Certificados = array();
	if($usuario != USUARIOUTIL || $password != PASSWORDUTIL){
		$resultadoWS->status = 400;
		$resultadoWS->mensaje = "Usuario o password incorrecto";
		return $resultadoWS;
	}
	//Validacion de parametros vacios
	if(trim($noSerieTimbre) == ""){
		$resultadoWS->status = "100";
		$resultadoWS->mensaje = "El parametro no puede ser vacio";
		return $resultadoWS;
	}
	
	$arrSeries = explode(",",$noSerieTimbre);
	$arrCerB64 = explode(",",$cerB64);
	for($j=0; $j<count($arrSeries); $j++){
		$noSerieTimbre = $arrSeries[$j];
		$cerB64 = $arrCerB64[$j];
		$local_file=LOCAL_FILE.$noSerieTimbre.".cer";
		try{
			$banCerExiste=true;
			$mensaje="";
			/*if(!file_exists($local_file)){
				if(!getCerSAT($noSerieTimbre,$local_file)){
					$banCerExiste=false;
					$mensaje="No se descargo el certificado.";
				}
			}*/
			if(trim($noSerieTimbre) == ""){
				$resultadoWS->Certificados[]=array("status" => "108",
					"mensaje" => "Serie vacia",
					"noSerie" => "",
					"rfc" => "",
					"pac" => "",
					"tipo" => "",
					"fecIni" => "",
					"fecFin" => "",
					"noAutorizacionPAC" => "",
					"statusValCer" => "",
					"mensajeValCer" => "",
					"statusEnBD" => "",
					"cer" => "");
					continue;
			}
				
			$query="select noSerie,rfc,pac,tipo,fecIni,fecFin,status,noAutorizacionPAC from csd_timbrado where noSerie='$noSerieTimbre' LIMIT 1";
			
			if($result = mysqli_query($conexion->CONEXION,$query)){
				// if(mysqli_num_rows($result) > 0){
				if(false){
					$certificadoB64="";
					if(!file_exists($local_file)){
						$intento=3;
						while($intento){
							if(!getCerSAT($noSerieTimbre,$local_file)){
								$banCerExiste=false;
								$mensaje="No se descargo el certificado.";
								$intento--;
							}else{
								$banCerExiste=true;
								$mensaje="";
								//$certificadoB64 = base64_encode(file_get_contents($local_file));
								break;
							}
						}
						
						if(!$banCerExiste){
							if(trim($cerB64) != ""){
								$archCER = fopen($local_file, "w");
								fwrite($archCER,base64_decode($cerB64));
								fclose($archCER);
								$banCerExiste=true;
								$mensaje="";
								$certificadoB64=$cerB64;
							}
						}else{
							if(filesize($local_file) > 0){
								$certificadoB64 = base64_encode(file_get_contents($local_file));
							}else{
								if(trim($cerB64) != ""){
									$archCER = fopen($local_file, "w");
									fwrite($archCER,base64_decode($cerB64));
									fclose($archCER);
									$banCerExiste=true;
									$mensaje="";
									$certificadoB64=$cerB64;
								}else{
									$banCerExiste=false;
									$mensaje="No se descargo el certificado.";
								}
							}
						}
					}else{
						if(filesize($local_file) > 0){
								$certificadoB64 = base64_encode(file_get_contents($local_file));
						}else{
							if(trim($cerB64) != ""){
								$archCER = fopen($local_file, "w");
								fwrite($archCER,base64_decode($cerB64));
								fclose($archCER);
								$banCerExiste=true;
								$mensaje="";
								$certificadoB64=$cerB64;
							}else{
								$banCerExiste=false;
								$mensaje="No se descargo el certificado.";
							}
						}
						//$certificadoB64 = base64_encode(file_get_contents($local_file));
					}
					$tmp=mysqli_fetch_assoc($result);
					$resultadoWS->Certificados[]=array("status" => "200",
					"mensaje" => "Validación de certificado finalizada correctamente.".$mensaje,
					"noSerie" => $tmp['noSerie'],
					"rfc" => $tmp['rfc'],
					"pac" => $tmp['pac'],
					"tipo" => $tmp['tipo'],
					"fecIni" => $tmp['fecIni'],
					"fecFin" => $tmp['fecFin'],
					"noAutorizacionPAC" => $tmp['noAutorizacionPAC'],
					"statusValCer" => "200",
					"mensajeValCer" => "Validado por base de datos.",
					"statusEnBD" => $tmp['status'],
					"cer" => $certificadoB64);
					continue;
				}else{
					
					$certificadoB64="";
							
					if(!file_exists($local_file)){
						$intento=3;
						while($intento){
							if(!getCerSAT($noSerieTimbre,$local_file)){
								$banCerExiste=false;
								$mensaje="No se descargo el certificado.";
								$intento--;
								
							}else{
								$banCerExiste=true;
								$mensaje="";
								//$certificadoB64 = base64_encode(file_get_contents($local_file));
								break;
								
							}
						}
						
						if(!$banCerExiste){
							if(trim($cerB64) != ""){
								$archCER = fopen($local_file, "w");
								fwrite($archCER,base64_decode($cerB64));
								fclose($archCER);
								$banCerExiste=true;
								$mensaje="";
								$certificadoB64=$cerB64;
							}
						}else{
							if(filesize($local_file) > 0){
								$certificadoB64 = base64_encode(file_get_contents($local_file));
							}else{
								if(trim($cerB64) != ""){
									$archCER = fopen($local_file, "w");
									fwrite($archCER,base64_decode($cerB64));
									fclose($archCER);
									$banCerExiste=true;
									$mensaje="";
									$certificadoB64=$cerB64;
								}else{
									$banCerExiste=false;
									$mensaje="No se descargo el certificado.";
								}
							}
						}
					}else{
						if(filesize($local_file) > 0){
								$certificadoB64 = base64_encode(file_get_contents($local_file));
						}else{
							if(trim($cerB64) != ""){
								$archCER = fopen($local_file, "w");
								fwrite($archCER,base64_decode($cerB64));
								fclose($archCER);
								$banCerExiste=true;
								$mensaje="";
								$certificadoB64=$cerB64;
							}else{
								$banCerExiste=false;
								$mensaje="No se descargo el certificado.";
							}
						}
						//$certificadoB64 = base64_encode(file_get_contents($local_file));
					}
					
					if(!$banCerExiste){
						$resultadoWS->Certificados[]=array(	"status" => "102",
							"mensaje" => "No se encontro o no se pudo descargar el certificado.");
							continue;
					}
					$arrDatos = getDatosCer($local_file);
					/*$resultadoWS->Certificados[]=array("statusValCer" => $arrDatos['status']);
					return $resultadoWS;*/
				if(trim($arrDatos['noSerie']) == ""){
					$resultadoWS->Certificados[]=array("status" => "107",
						"mensaje" => "No se pudo leer el archivo .cer. ".$mensaje,
						"noSerie" => $noSerieTimbre,
						"rfc" => "",
						"pac" => "",
						"tipo" => "",
						"fecIni" => "",
						"fecFin" => "",
						"noAutorizacionPAC" => "",
						"statusValCer" => "",
						"mensajeValCer" => "",
						"statusEnBD" => "",
						"cer" => $certificadoB64);
						if(file_exists($local_file)){
							try{
								unlink($local_file);
							}catch(Exception $eDelete){
								
							}
						}
						continue;
				}
					$query="insert into csd_timbrado set noSerie='".$arrDatos['noSerie']."',
							rfc='".$arrDatos['rfc']."',
							pac='".$arrDatos['pac']."',
							tipo='".$arrDatos['tipo']."',
							fecIni='".$arrDatos['fecIni']."',
							fecFin='".$arrDatos['fecFin']."',
							status='A',
							noAutorizacionPAC='".$arrDatos['noAutorizacionPAC']."'";
							
					if(mysqli_query($conexion->CONEXION,$query)){
						$resultadoWS->Certificados[]=array("status" => "200",
						"mensaje" => "Validación de certificado finalizada correctamente. ".$mensaje,
						"noSerie" => $arrDatos['noSerie'],
						"rfc" => $arrDatos['rfc'],
						"pac" => $arrDatos['pac'],
						"tipo" => $arrDatos['tipo'],
						"fecIni" => $arrDatos['fecIni'],
						"fecFin" => $arrDatos['fecFin'],
						"noAutorizacionPAC" => $arrDatos['noAutorizacionPAC'],
						"statusValCer" => $arrDatos['status'],
						"mensajeValCer" => "Validado por archivo CER.".$arrDatos['mensaje'],
						"statusEnBD" => "A",
						"cer" => $certificadoB64);
					}else{
						$resultadoWS->Certificados[]=array(	"status" => "201",
						"mensaje" => "No se agrego el numero de serie a la lista.".$mensaje,
						"noSerie" => $arrDatos['noSerie'],
						"rfc" => $arrDatos['rfc'],
						"pac" => $arrDatos['pac'],
						"tipo" => $arrDatos['tipo'],
						"fecIni" => $arrDatos['fecIni'],
						"fecFin" => $arrDatos['fecFin'],
						"noAutorizacionPAC" => $arrDatos['noAutorizacionPAC'],
						"statusValCer" => $arrDatos['status'],
						"mensajeValCer" => "Validado por archivo CER.".$arrDatos['mensaje'],
						"statusEnBD" => "",
						"cer" => $certificadoB64);
					}
					if(trim($arrDatos['tipo']) != "PAC" && trim($arrDatos['tipo']) != "MEGAPAC"){
						if(file_exists($local_file)){
							try{
								unlink($local_file);
							}catch(Exception $eDelete){
								
							}
						}
					}
					continue;
				}
			}else{
				$resultadoWS->Certificados[]=array(	"status" => "103",
							"mensaje" => "Ocurrio un error al consultar el numero de serie en la base de datos.",
							"noSerie" => $noSerieTimbre);
			}
		}catch(Exception $e1){
			$resultadoWS->Certificados[] = array("status" => "104",
							"mensaje" => "Ocurrio el siguiente error: ".$e1->getMessage(),
							"noSerie" => $noSerieTimbre);
		}
	}
	$resultadoWS->status = "200";
	$resultadoWS->mensaje = "Validaciones finalizadas correctamente";
	return $resultadoWS;
}
function validarRFC($rfc) {
	$regex = "/^[A-ZÑ&]{3,4}[0-9]{2}[0-1][0-9][0-3][0-9][A-Z,0-9][A-Z,0-9][0-9A]$/";
	return preg_match($regex, $rfc);
}
/*function validarRFC($valor) { 
	$valor = str_replace("-", "", $valor); 
	$cuartoValor = substr($valor, 3, 1); 
	//RFC Persona Moral. 
	if (ctype_digit($cuartoValor) && strlen($valor) == 12) { 
		$letras = substr($valor, 0, 3); 
		$numeros = substr($valor, 3, 6); 
		$homoclave = substr($valor, 9, 3); 
		if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
			return true; 
		} 
	//RFC Persona Física. 
	} else if (ctype_alpha($cuartoValor) && strlen($valor) == 13) { 
		$letras = substr($valor, 0, 4); 
		$numeros = substr($valor, 4, 6); 
		$homoclave = substr($valor, 10, 3); 
		if (ctype_alpha($letras) && ctype_digit($numeros) && ctype_alnum($homoclave)) { 
			return true; 
		} 
	}else { 
		return false; 
	} 
}*/
function getDatosCer($local_file){
	$arrCER = LeeCER($local_file);
	
	
	$mensaje="";
	$status="";
	$noAutorizacionPAC="";
	if(is_array($arrCER)){
		if(array_key_exists("OU",$arrCER['subject'])){
				if(substr(trim($arrCER['subject']['OU']),0,19) == "MEGAPACSAT970701NN3"){
					$a = explode("/",$arrCER['subject']['x500UniqueIdentifier']);
					if(trim($a[0]) == "SAT970701NN3"){
						$arrRFCTipo = array("tipo" => "MEGAPAC","rfc" => "SAT970701NN3");
						$mensaje="RFC en elemento x500UniqueIdentifier corresponde con el del SAT";
						$status="200";
					}else{
						$arrRFCTipo = array("tipo" => "MEGAPAC","rfc" => trim($a[0]));
						$mensaje="RFC MEGAPAC en elemento x500UniqueIdentifier diferente al del SAT";
						$status="300";
					}
				}else if(substr(trim($arrCER['subject']['OU']),0,3) == "PAC" && validarRFC(substr(trim($arrCER['subject']['OU']),3,12))){
					$arrRFCTipo = array("tipo" => "PAC","rfc" => substr(trim($arrCER['subject']['OU']),3,12));
					if(validarRFC(substr(trim($arrCER['subject']['OU']),3,12))){
						$a = explode("/",$arrCER['subject']['x500UniqueIdentifier']);
						if(trim($a[0]) != "SAT970701NN3"){
							$mensaje="RFC en elemento x500UniqueIdentifier diferente al del SAT";
							$status="301";
						}else{
							$mensaje="RFC en elemento x500UniqueIdentifier corresponde al del SAT";
							$status="200";
						}
					}else{
						$mensaje="RFC PAC invalido";
						$status="302";
					}
					
					$noAutorizacionPAC=substr(trim($arrCER['subject']['OU']),15);
					
				}else{
					
					$a = explode("/",$arrCER['subject']['x500UniqueIdentifier']);
					$arrRFCTipo = array("tipo" => "EMISOR","rfc" => trim($a[0]));
					
					if(!validarRFC(trim($a[0]))){
						$mensaje="RFC emisor invalido";
						$status="303";
					}else if(trim($a[0]) == "SAT970701NN3"){
						$mensaje="RFC en elemento x500UniqueIdentifier igual al del SAT para un CER de tipo emisor.";
						$status="304";
					}else{
						$mensaje="RFC en elemento x500UniqueIdentifier es correcto.";
						$status="200";
					}
				}
		}else{
			$a = explode("/",$arrCER['subject']['x500UniqueIdentifier']);
			$arrRFCTipo = array("tipo" => "FIEL","rfc" => trim($a[0]));
			if(!validarRFC(trim($a[0]))){
				$mensaje="RFC FIEL invalido";
				$status="305";
			}else if(trim($a[0]) == "SAT970701NN3"){
				$mensaje="RFC en elemento x500UniqueIdentifier igual al del SAT para un CER de tipo FIEL.";
				$status="306";
			}else{
				$mensaje="RFC en elemento x500UniqueIdentifier es correcto.";
				$status="200";
			}
		}
	}else{
		$mensaje="El CER no se pudo leer.";
		$status="307";
	}
	$serie = quitaNumero3Serie(str_replace("0x","",$arrCER["serialNumber"]));
	$arrDatos = array("mensaje"=> $mensaje,"status" => $status,"noSerie" => $serie,"fecIni" => date("Y-m-d H:i:s",$arrCER['validFrom_time_t']),
	"fecFin" => date("Y-m-d H:i:s",$arrCER['validTo_time_t']),"rfc" => $arrRFCTipo['rfc'],
	"tipo" => $arrRFCTipo['tipo'],"pac" => $arrCER['subject']["name"],"noAutorizacionPAC" => $noAutorizacionPAC);
	
	return $arrDatos;
	
}
function quitaNumero3Serie($serie){
	$arrSerie = str_split($serie);
	$serie = "";
	for($i=1; $i<count($arrSerie); $i++){
		$serie.=$arrSerie[$i];
		$i++;
	}
	return $serie;
}
function getCerSAT($noSerieTimbre,$local_file){
	$folder1 = substr($noSerieTimbre,0,6);
	$folder2 = substr($noSerieTimbre,6,6);
	$folder3 = substr($noSerieTimbre,12,2);
	$folder4 = substr($noSerieTimbre,14,2);
	$folder5 = substr($noSerieTimbre,16,2);
	//https://rdc.sat.gob.mx/rccf/000010/000004/03/25/87/00001000000403258748.cer
	$FTP = "https://rdc.sat.gob.mx/rccf/";
	$server_file=$FTP.$folder1."/".$folder2."/".$folder3."/".$folder4."/".$folder5."/".$noSerieTimbre.".cer";
	try{
		$con=3;
		while($con){
			try{
				$curl_handle=curl_init();
				curl_setopt($curl_handle, CURLOPT_URL,$server_file);
				curl_setopt($curl_handle, CURLOPT_HEADER, false);
				/*curl_setopt($curl_handle, CURLOPT_SSL_VERIFYHOST, 2);*/
				//curl_setopt($curl_handle, CURLOPT_SSLVERSION,1); 
				curl_setopt($curl_handle, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl_handle, CURLOPT_CONNECTTIMEOUT, 2);
				curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl_handle, CURLOPT_USERAGENT, 'ValidaCer');
				$archivo = curl_exec($curl_handle);
				
				//$archivo = file_get_contents($server_file);
				
				//if($archivo === false){

				if (!curl_errno($curl_handle)) {
					switch ($http_code = curl_getinfo($curl_handle, CURLINFO_HTTP_CODE)) {
						case 200:  
								if(file_put_contents($local_file,$archivo)){
									curl_close($curl_handle);
									return true;
								}
								curl_close($curl_handle);
								$con--;
								break;
						default:
								curl_close($curl_handle);
								$con--;
								break;
					}
				}else{
					$con--;
				}
			}catch(Exception $error){
				$con--;
			}
		}
		if(!$con){
			return false;
		}
		return true;
	}catch(Exception $e){
		return false;
	}
}
function LeeCER($archivo){
	$certificateFileDER = $archivo;
	$certificatePEM =  '-----BEGIN CERTIFICATE-----'.PHP_EOL
	 .chunk_split(base64_encode(file_get_contents($certificateFileDER)), 64,PHP_EOL)
	 .'-----END CERTIFICATE-----'.PHP_EOL;
	return openssl_x509_parse($certificatePEM);
}
function convierte($dec) {
    $hex=bcdechex($dec);
	$ser="";
    for ($i=1; $i<strlen($hex); $i=$i+2) {
        $ser.=substr($hex,$i,1);
    }
    return $ser;
}

function bcdechex($dec) {
    $last = bcmod($dec, 16);
    $remain = bcdiv(bcsub($dec, $last), 16);
    if($remain == 0) {
        return dechex($last);
    } else {
        return bcdechex($remain).dechex($last);
    }
}

// Use the request to (try to) invoke the service
$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
// $server->service($HTTP_RAW_POST_DATA);
$server->service(file_get_contents("php://input"));
?>