<?php

/*
Versi�n: 1.0.0.2
*/
require_once('lib/nusoap/nusoap.php');
require_once('class/ws_smarterweb.php');
require_once('class/pdo/csdsat.class.php');

define("NOTIFICAR_VALIDACION_USER",TRUE);

// Create the server instance
$server = new soap_server();
$server->soap_defencoding = 'UTF-8';
$server->decode_utf8 = false;
// Initialize WSDL support
$server->configureWSDL('validaCSDwsdl', 'urn:validaCSDwsdl');
// Register the method to expose
$server->register('validaCSD',                // method name
    array('serie' => 'xsd:string','rfc' => 'xsd:string'),        // input parameters
    array('return' => 'xsd:string'),      // output parameters
    'urn:validaCSDwsdl',                      // namespace
    'urn:validaCSDwsdl#validaCSD',                // soapaction
    'rpc',                                // style
    'encoded',                            // use
    'Carga Archivos'            // documentation
);
// Define the method as a PHP function
function validaCSD($serie,$rfc) {
	try{

		$csdsat = new CSDSAT();

		$ws_smarterweb = new WSSmarterWEB();

		$ws_smarterweb->autenticacion();
		$ws_smarterweb->TOKEN=$ws_smarterweb->getToken();

		$ws_smarterweb->setWSConsulta();

		$ws_smarterweb->NUM_CER=$serie;
		$ws_smarterweb->RFC=$rfc;

		if($ws_smarterweb->validaCertificadoLCO()){
      /*
          (
            [NoCertificado] => 00001000000505881967
            [RFC] => IOL170508DI2
            [ValidezObligaciones] => 1
            [EstatusCertificado] => A
            [FechaInicio] => 2020-12-02T12:38:18
            [FechaFinal] => 2024-12-02T12:38:18
          )
      */
      if(count( (array)$ws_smarterweb->RESULT) == 0){
        $csdsat->qry_s_csdsat($serie);
        if($csdsat->ERROR_NO != 0){
          return "ERROR: ".$csdsat->MENSAJE;
        }
        if($csdsat->NUM_REGISTROS == 0){
          return "";
        }
        $edoCert = $csdsat->CURSOR['edoCert'];
        $fecha_u = $csdsat->CURSOR['fecha_u'];
        $fecFin = $csdsat->CURSOR['fecFin'];
        if($csdsat->CURSOR['edoCert'] == 'A'){
            $csdsat->qry_u_csdsat($serie, 'R', $csdsat->CURSOR['fecFin']);
            $sFechaFin = (int) str_replace(":","",str_replace(" ","",str_replace("-","",$csdsat->CURSOR['fecFin'])));
            $sFechaHoy = (int) date('YmdHis');
            if($sFechaFin > $sFechaHoy){
                $csdsat->qry_u_csdsat_fechaFin($serie);
                $fecFin = date('Y-m-d-').'T'.date('H:i:s');
            }
            $edoCert = 'R';
            $fecha_u = date('Y-m-d-').'T'.date('H:i:s');
        }

        return $csdsat->CURSOR['noSerie']."|".$csdsat->CURSOR['fecIni']."|".$fecFin."|".$csdsat->CURSOR['rfc']."|".$edoCert."|".$csdsat->CURSOR['fecha_i']."|".$fecha_u;
			}else{
        $fechaiu = date("Y-m-d")."T".date("H:i:s");
        $csdsat->qry_iu_csdsat($serie, $ws_smarterweb->RESULT->LcoResult->FechaInicio, $ws_smarterweb->RESULT->LcoResult->FechaFinal, $rfc, $ws_smarterweb->RESULT->LcoResult->EstatusCertificado);
				return $serie."|".str_replace("T"," ",$ws_smarterweb->RESULT->LcoResult->FechaInicio)."|".str_replace("T"," ",$ws_smarterweb->RESULT->LcoResult->FechaFinal)."|".$rfc."|".$ws_smarterweb->RESULT->LcoResult->EstatusCertificado."|".$fechaiu."|".$fechaiu;
			}
		}else{
			return "ERROR: ".$ws_smarterweb->ERROR_MESSAGE;
		}
	}catch(Exception $e){
		return "ERROR: ".$e->getMessage();
	}
}
// Use the request to (try to) invoke the service
$HTTP_RAW_POST_DATA = isset($HTTP_RAW_POST_DATA) ? $HTTP_RAW_POST_DATA : '';
// $server->service($HTTP_RAW_POST_DATA);
$server->service(file_get_contents("php://input"));
?>
