<?
set_time_limit(30);

libxml_use_internal_errors(true);
require("../conexion/conectar.php");
require("../libs/funciones.php");
define("USUARIO","recibecfd");
define("PASSWORD","r3c1b3cfd");
header('Content-Type: application/json');

date_default_timezone_set('America/Mexico_City');

$conexion = new CONDB();
$conexion->conectar();

try{
	$contenido = file_get_contents('php://input');
	$resultadoWS = array();

	if(trim($contenido) == ""){
		$resultadoWS["status"]=100;
		$resultadoWS["mensaje"]="Los parametros no pueden ser vacíos";
		echo json_encode($resultadoWS);
		exit;
	}

	$json = json_decode($contenido);

	if(trim($json->usuario) != USUARIO || trim($json->password) != PASSWORD){
		$resultadoWS["status"]=101;
		$resultadoWS["mensaje"]="Usuario y password incorrecto";
		echo json_encode($resultadoWS);
	}
	if(trim($json->uuid) == ""){
		$resultadoWS["status"]=102;
		$resultadoWS["mensaje"]="Debe de indicar el uuid del REP.";
		echo json_encode($resultadoWS);
		exit;
	}
	
	$tREP = getDatosREP($json->uuid);
	
	$arrValidacion = validaRepvsNP($json->uuid,$tREP);
	
	if($json->responseHTML == 1){
		echo utf8_decode($arrValidacion["html"]);exit;
	}
	$htmlB64 = base64_encode(utf8_decode($arrValidacion["html"]));

	$resultadoWS["status"]=200;
	$resultadoWS["mensaje"]="Validación generada correctamente.";
	$resultadoWS["correcto"]=($arrValidacion["incorrecto"] == true)? 0 : 1;
	$resultadoWS["html"]=$htmlB64;

	echo json_encode($resultadoWS);
	exit;

	}catch(Exception $e){
		$resultadoWS["status"]=400;
		$resultadoWS["mensaje"]="Excepción: ".$e->getMessage();
		echo json_encode($resultadoWS);
		exit;
	}

	function getDatosREP($uuidREP){
		global $conexion;
		$query = "select rfcEmisor, serie, folio, uuid, fechaDocto, rfc_receptor, fechaRecibido from recibedoce where uuid='$uuidREP'";
		if(!$result = mysqli_query($conexion->CONEXION,$query)){
			$resultadoWS["status"]=300;
			$resultadoWS["mensaje"]="ERROR: ".mysqli_error($conexion->CONEXION);
			echo json_encode($resultadoWS);
			exit;
		}
		if(mysqli_num_rows($result) == 0){
			$resultadoWS["status"]=301;
			$resultadoWS["mensaje"]="ERROR: No se encontro el uuid del REP";
			echo json_encode($resultadoWS);
			exit;
		}
		return mysqli_fetch_assoc($result);
	}

	function validaRepvsNP($uuidREP,$rep){
		global $conexion;
			//Extraigo Configuracion General de notificaciones del receptor del REP
			$qConfig = "select notificar_dias,notificar_despuesde,notificar_repetirdias,notificar_correos,notificar_asunto,notificar_correos_cc,notificar_fecha_inicio,tolerancia_NPvsComplemento,tolerancia_NPvsFactura,tolerancia_FacturaPagada,tolerancia_CompensacionEgreso,tolerancia_tipoCambio, valida_fecha_pago,
		date_format(fecha_valida_fecha_pago,'%Y%m%d%H%i%s') as formatFecha_valida_fecha_pago from configpagina where rfc_receptor='".$rep["rfc_receptor"]."' limit 1";
		// echo $qConfig;exit;s
			if(!$rConfig = mysqli_query($conexion->CONEXION,$qConfig)){
				setBitacora($conexion, "WS", $rep["rfc_receptor"] , "WS VALIDA REP vs NP", "Error en consulta de configuracion general.", $qConfig);
				$resultadoWS["status"]=302;
				$resultadoWS["mensaje"]="ERROR: Consulta de configuracion general";
				echo json_encode($resultadoWS);exit;
			}
			if(mysqli_num_rows($rConfig) <= 0){
				setBitacora($conexion, "WS", $rep["rfc_receptor"] , "WS VALIDA REP vs NP", "No se encontro la configuracion del receptor.", $qConfig);
				$resultadoWS["status"]=303;
				$resultadoWS["mensaje"]="ERROR: No se encontro la configuracion del receptor";
				echo json_encode($resultadoWS);exit;
			}

			$tConfig = mysqli_fetch_assoc($rConfig);
			$formatFecha_valida_fecha_pago = $tConfig["formatFecha_valida_fecha_pago"];
			$valida_fecha_pago = $tConfig["valida_fecha_pago"];
			$tConfig["tolerancia_NPvsComplemento"] = (float) $tConfig["tolerancia_NPvsComplemento"];
			$tConfig["tolerancia_NPvsFactura"] = (float) $tConfig["tolerancia_NPvsFactura"];
			$tConfig["tolerancia_FacturaPagada"] = (float) $tConfig["tolerancia_FacturaPagada"];
			$tConfig["tolerancia_CompensacionEgreso"] = (float) $tConfig["tolerancia_CompensacionEgreso"];
			$tConfig["tolerancia_tipoCambio"] = (float) $tConfig["tolerancia_tipoCambio"];

			//Valido la fecha
			$completaQueryValidacionFechaInicio = "";
			if($tConfig['notificar_fecha_inicio'] != ""){
				$completaQueryValidacionFechaInicio = "fecha >= '".$tConfig['notificar_fecha_inicio']."' and ";
			}

			$tConfig["tolerancia_NPvsComplemento"] = (trim($tConfig["tolerancia_NPvsComplemento"]) == "")? 0 : $tConfig["tolerancia_NPvsComplemento"];
			$tConfig["tolerancia_NPvsFactura"] = (trim($tConfig["tolerancia_NPvsFactura"]) == "")? 0 : $tConfig["tolerancia_NPvsFactura"];
			$tConfig["tolerancia_FacturaPagada"] = (trim($tConfig["tolerancia_FacturaPagada"]) == "")? 0 : $tConfig["tolerancia_FacturaPagada"];
			$tConfig["tolerancia_CompensacionEgreso"] = (trim($tConfig["tolerancia_CompensacionEgreso"]) == "")? 0 : $tConfig["tolerancia_CompensacionEgreso"];
			$tConfig["tolerancia_tipoCambio"] = (trim($tConfig["tolerancia_tipoCambio"]) == "")? 0 : $tConfig["tolerancia_tipoCambio"];

			//CONSULTO PAGOS DEL REP



			$qPagos = "select recibedoce_pagos_ID, recibedoce_UUID, FechaPago, TipoCambioP, MonedaP, Monto, RfcEmisorCtaOrd, RfcEmisorCtaBen, FormaDePago,
			date_format(FechaPago,'%Y%m%d%H%i%s') as formatFechaPago
			from recibedoce_pagos
			where recibedoce_UUID = '$uuidREP'";
			// echo $qPagos;exit;

			if(!$rPago = mysqli_query($conexion->CONEXION,$qPagos)){
				setBitacora($conexion, "AUTOMATICO", $rep["rfc_receptor"], "WS VALIDA REP vs NP", "Error en consulta de pagos del REP", $qPagos);
				$resultadoWS["status"]=304;
				$resultadoWS["mensaje"]="ERROR: Error en consulta de pagos del REP";
				echo json_encode($resultadoWS);exit;
			}
			if(mysqli_num_rows($rPago) == 0){
				$resultadoWS["status"]=305;
				$resultadoWS["mensaje"]="ERROR: No se encontraron pagos en el REP";
				echo json_encode($resultadoWS);exit;
			}

			//ITERO TODOS LOS PAGOS
			$body="";
			$bodyEnviar="";
			$auxReceptor="";
			$correosProveedor="";
			$body='<html> <head><meta charset="UTF-8"></head><body>
							<table border="0">
								<tr>
									<td style="background-color: red" align="center">
										<b><font style="font-size: 15px; border-color: #fbca93">Diferencias</font></b>
									</td>
									<td style="background-color: yellow" align="center">
										<b><font style="font-size: 15px; border-color: #fbca93">Parcialidad Duplicada</font></b>
									</td>
								</tr>
							</table>
							<table width="98%" bgcolor="white" style="border: 5px #DDDDDD solid;">
							<tr>
								<th style="background-color: #DDDDDD; text-align: center" colspan="6">REP</th>
							</tr>
							<tr>
								<th style="background-color: #DDDDDD; text-align: left">Serie</th><td>'.$rep["serie"].'</td>
								<th style="background-color: #DDDDDD; text-align: left">Folio</th><td>'.$rep["folio"].'</td>
								<th style="background-color: #DDDDDD; text-align: left">UUID</th><td>'.$rep["uuid"].'</td>
							</tr>
						</table>';

			while($tPago = mysqli_fetch_array($rPago)){
				$validarTipoCambio = true;

				$body.= '
				<table width="98%" bgcolor="white" style="border: 5px #DDDDDD solid;">
					<tr>
						<th style="background-color: #DDDDDD; text-align: center" colspan="5">Pago recibido</th>
					</tr>
					<tr>
						<th>Monto</th>
						<th>Moneda</th>
						<th>T. Cambio</th>
						<th>Forma de pago</th>
						<th>Fecha de pago</th>
					</tr>
					<tr>
						<td style="text-align: center">'.$tPago["Monto"].'</td>
						<td style="text-align: center">'.$tPago["MonedaP"].'</td>
						<td style="text-align: center">'.$tPago["TipoCambioP"].'</td>
						<td style="text-align: center">'.$tPago["FormaDePago"].'</td>
						<td style="text-align: center">'.$tPago["FechaPago"].'</td>
					</tr></table>';


					$qPagoRecibePago = "select rpdr.uuidcfdirelacionado,
					r1.serie,r1.folio,
					pdr.monto as PDRmontoPago,pdr.numparcialidad as PDRnumparcialidad,pdr.tipocambio as PDRtipocambio,pdr.moneda as PDRmoneda, rpdr.tipocambiodr as RPDRtipocambio,r1.total as totalCFDI,r1.MetodoDePago as MetodoDePagoDoc,pdr.MetodoDePago as PDRMetodoDePago,rpdr.MetodoDePago as RPDRMetodoDePago,
				rpdr.monedadr as RPDRmoneda,rpdr.imppagado as RPDRimpagado,rpdr.NumParcialidad as RPDRnumparcialidad, r1.nombreemi, rdp.MonedaP as RDPmoneda,rdp.Monto as RDPmonto,rdp.recibedoce_UUID,
				rdp.TipoCambioP as RDPtipocambio,d.adicionalb as formadepago, rdp.FechaPago as RDPFechaPago, date_format(d.fechaPago,'%Y%m%d%H%i%s') as formatPDRFechaPago,
				rdt.totalPagoDocumentosRef, rdt.totalIngresoCompensado, rdt.ImpPagadoComplemento, rdt.FechaNP, rdt.numReferenciasPagoDocumentosRef,
				(select count(*) from recibedoce_pagos_docto_relacionado where uuidcfdirelacionado=rpdr.uuidcfdirelacionado and numparcialidad=rpdr.numparcialidad)
				as numParcialidadDuplicada,pdr.doce_uuid,d.fechaPago, concat(d.serie,d.folio) as folioNP, d.RFCReceptor as RFCReceptor
				from recibedoce_pagos rdp
				left join recibedoce_pagos_docto_relacionado rpdr ON rdp.recibedoce_pagos_id = rpdr.recibedoce_pagos_id
				left join recibedoce r1 ON rpdr.uuidcfdirelacionado = r1.uuid
				left join recibedoce_totales rdt ON rpdr.uuidcfdirelacionado = rdt.uuid
				left join pago_documentos_ref pdr
				ON rpdr.doce_uuid = pdr.doce_uuid and rpdr.uuidcfdirelacionado = pdr.uuidcfdirelacionado and
				(rpdr.numparcialidad = pdr.numparcialidad or rpdr.numparcialidad <> pdr.numparcialidad)
				left join doce d ON pdr.doce_uuid = d.adicionalA where rdp.recibedoce_pagos_ID = ".$tPago["recibedoce_pagos_ID"];


				/*$qPagoRecibePago = "select pdr.uuidcfdirelacionado,
				r1.serie,r1.folio,
				pdr.monto as PDRmontoPago,pdr.numparcialidad as PDRnumparcialidad,pdr.tipocambio as PDRtipocambio,pdr.moneda as PDRmoneda, rpdr.tipocambiodr as RPDRtipocambio,r.total as totalCFDI,r1.MetodoDePago as MetodoDePagoDoc,pdr.MetodoDePago as PDRMetodoDePago,rpdr.MetodoDePago as RPDRMetodoDePago,
			rpdr.monedadr as RPDRmoneda,rpdr.imppagado as RPDRimpagado,rpdr.NumParcialidad as RPDRnumparcialidad, r.nombreemi, rdp.MonedaP as RDPmoneda,rdp.Monto as RDPmonto,rdp.recibedoce_UUID,
			rdp.TipoCambioP as RDPtipocambio,rdp.formadepago, rdp.FechaPago as RDPFechaPago, date_format(rdp.FechaPago,'%Y%m%d%H%i%s') as formatRDPFechaPago, rcomplemento.status as statusComplemento,rcomplemento.uuid as RepUUID,rcomplemento.serie as RepSerie,rcomplemento.folio as RepFolio,
			rdt.totalPagoDocumentosRef, rdt.totalIngresoCompensado, rdt.ImpPagadoComplemento, rdt.FechaNP, rdt.numReferenciasPagoDocumentosRef,
			(select count(*) from pago_documentos_ref where uuidcfdirelacionado=pdr.uuidcfdirelacionado and numparcialidad=pdr.numparcialidad) as numParcialidadDuplicada,pdr.doce_uuid
			from pago_documentos_ref pdr
			left join recibedoce r1
			ON pdr.uuidcfdirelacionado = r1.uuid
			left join recibedoce_pagos_docto_relacionado rpdr
			ON pdr.doce_uuid = rpdr.doce_uuid and pdr.uuidcfdirelacionado = rpdr.uuidcfdirelacionado and
			(pdr.numparcialidad = rpdr.numparcialidad or pdr.numparcialidad <> rpdr.numparcialidad)
			left join recibedoce_pagos rdp
			ON rpdr.recibedoce_pagos_id = rdp.recibedoce_pagos_id
			left join recibedoce r
			ON rpdr.uuidcfdirelacionado = r.uuid
			left join recibedoce_totales rdt
			ON rdt.uuid=r.uuid
			left join recibedoce rcomplemento on rdp.recibedoce_UUID = rcomplemento.uuid
			where pdr.doce_uuid='".$tPago["uuid"]."' and r1.MetodoDePago='PPD' and rcomplemento.status IN ('A','S','W','WS')";*/
			// echo $qPagoRecibePago;exit;

				if(!$rPagoRecibePago = mysqli_query($conexion->CONEXION,$qPagoRecibePago)){
					setBitacora($conexion, "AUTOMATICO", $rep["rfc_receptor"], "WS VALIDA REP vs NP", "Ocurrio un error al consultar los documentos relacionados al pago", $qPagoRecibePago);
					$resultadoWS["status"]=305;
					$resultadoWS["mensaje"]="ERROR: Ocurrio un error al consultar los documentos relacionados al pago";
					echo json_encode($resultadoWS);exit;
				}
				
				if(mysqli_num_rows($rPagoRecibePago) <= 0){
					$body.='
					<table width="98%" bgcolor="white" style="border: 5px #DDDDDD solid;">
					<tr>
						<th style="background-color: #fcfbe5; text-align: center">SIN DOCUMENTOS RELACIONADOS</th>
					</tr>
					</table>';
				}
				$con=0;
					$body.='
					<table width="98%" bgcolor="white" style="border: 5px #DDDDDD solid;">
					<tr>
						<td style="padding: 20px 20px 20px 20px">
							<table width="100%" bgcolor="white" style="border: 2px #DDDDDD solid">
								<tr style="color: #FFFFFF">
									<th style="background-color: #000000; text-align: center" colspan="9">Complemento / ICFDI 3.3</th>
									<th style="background-color: #2476af; text-align: center" colspan="9">Pago emitido</th>
								</tr>
								<tr style="background-color: #2476af; color: #FFFFFF">
									<td>Serie</td>
									<td>Folio</td>
									<td>UUID</td>
									<td style="background-color: #000000">Parcialidad</td>
									<td style="background-color: #000000">Fecha de pago</td>
									<td style="background-color: #000000">Moneda</td>
									<td style="background-color: #000000">T. Cambio</td>
									<td style="background-color: #000000">Monto</td>
									<td style="background-color: #000000">Método de pago</td>

									<td>Parcialidad</td>
									<td>Fecha de pago</td>
									<td>Forma de pago</td>
									<td>Moneda</td>
									<td>T. Cambio</td>
									<td>Monto</td>
									<td>Método de pago</td>
									<td>Folio NP</td>
									<td>Receptor</td>
								</tr>';


				/*
				************************************************************************
				************************************************************************
				************************************************************************
				************************************************************************
				************************************************************************
				************************************************************************
				empieza a iterar los cfdi pagados
				*/
				$totalMontosFacturasNP=0;
				$sumaMontoPago=0.00;
				$banIncorrecto=false;
				$totalPPD=0.00;
				$totalEncabezadoComplemento = 0.00;
				
				while($tPagoRecibePago = mysqli_fetch_array($rPagoRecibePago,MYSQLI_ASSOC)){
					//Si es una PUE la ignoro
					/*if(trim($tPagoRecibePago["MetodoDePagoDoc"]) == "PUE"){
						continue;
					}*/
					if($tPagoRecibePago["MetodoDePagoDoc"] == "PPD"){
						$totalPPD = $totalPPD + $tPagoRecibePago["PDRmontoPago"];
					}
					$totalEncabezadoComplemento = $tPagoRecibePago["RDPmonto"];
					$con++;
					$res = $con%2;
					$trEstilo="";
					if($res == 0){
						$trEstilo = "style='background-color: #999999'";
					}
					$tdEstiloMonto = "";
					$tdEstiloTipoCambio = "";
					$tdEstiloMoneda = "";
					$tdEstiloFechaPago = "";
					$tdEstiloParcialidad = "";
					$tdEstiloFormaDePago = "";
					$tdEstiloMetodoDePago = "";
					$tdEstiloParcialidadPago = "";

					//Valido el monto pagado al documento en NP vs Complemento
					if($tPagoRecibePago["PDRmontoPago"] != $tPagoRecibePago["RPDRimpagado"]){

						$diferencia = (float) $tPagoRecibePago["PDRmontoPago"] - (float) $tPagoRecibePago["RPDRimpagado"];
						if($diferencia < 0){
							$diferencia = $diferencia * -1;
						}

						if((float) $diferencia > (float) $tConfig["tolerancia_NPvsComplemento"]){
							$tdEstiloMonto = "style='background-color: red'";
							$banIncorrecto=true;
						}else{
							$tdEstiloMonto = "style='background-color: orange'";
						}
						// $tdEstiloMonto = "style='background-color: red'";
						// $banIncorrecto=true;
					}
					//Valido el tipo de cambio del pago al documento en NP vs Complemento
					if($validarTipoCambio == true){
						if($tPagoRecibePago["PDRtipocambio"] != $tPagoRecibePago["RPDRtipocambio"]){
							$diferencia = (float) $tPagoRecibePago["PDRtipocambio"] - (float) $tPagoRecibePago["RPDRtipocambio"];
							if($diferencia < 0){
								$diferencia = $diferencia * -1;
							}

							if((float) $diferencia > (float) $tConfig["tolerancia_tipoCambio"]){
								$tdEstiloTipoCambio = "style='background-color: red'";
								$banIncorrecto=true;
							}else{
								$tdEstiloTipoCambio = "style='background-color: orange'";
							}
							// $tdEstiloTipoCambio = "style='background-color: red'";
							// $banIncorrecto=true;
						}
					}
					//Valido la moneda
					if($tPagoRecibePago["PDRmoneda"] != $tPagoRecibePago["RPDRmoneda"]){
						$tdEstiloMoneda = "style='background-color: red'";
						$banIncorrecto=true;
					}
					//Valido el numero de parcialidad
					if($tPagoRecibePago["PDRnumparcialidad"] != $tPagoRecibePago["RPDRnumparcialidad"]){
						$tdEstiloParcialidad = "style='background-color: red'";
						$tdEstiloParcialidadPago = "style='background-color: red'";
						$banIncorrecto=true;
					}
					//Valido la forma de pago
					if(trim($tPagoRecibePago["formadepago"]) != trim($tPago["FormaDePago"])){
						$tdEstiloFormaDePago = "style='background-color: red'";
						$banIncorrecto=true;
					}
					//Valido la fecha de pago
					/*if($valida_fecha_pago == "1"){
						if(substr($tPago["formatFechaPago"],0,8) >= substr($formatFecha_valida_fecha_pago,0,8)){
							if($tPago["formatFechaPago"] != $tPagoRecibePago["formatRDPFechaPago"]){
								$tdEstiloFechaPago = "style='background-color: red'";
								$banIncorrecto = true;
							}
						}
					}*/
					if($valida_fecha_pago == "1"){
						if($tPago["FechaPago"] == ""){
							$tdEstiloFechaPago = "style='background-color: red'";
							$banIncorrecto = true;
						}else if(substr($tPago["formatFechaPago"],0,8) >= substr($formatFecha_valida_fecha_pago,0,8)){
							if(substr($tPago["formatFechaPago"],8,6) != "120000"){
								if($tPago["formatFechaPago"] != $tPagoRecibePago["formatPDRFechaPago"]){
									$tdEstiloFechaPago = "style='background-color: red'";
									$banIncorrecto = true;
								}
							}
						}
					}
					if(trim($tPagoRecibePago["PDRMetodoDePago"]) != trim($tPagoRecibePago["RPDRMetodoDePago"])){
						$tdEstiloMetodoDePago = "style='background-color: red'";
						$banIncorrecto=true;
					}

					//Valido que si es PUE, el pago haya sido por completo al total del CFDI
					/*if(trim($tPago["RPDRMetodoDePago"]) == "PUE"){
						$totalCompensadoMasPagadoCom = $tPagoRecibePago["RPDRimpagado"]+$tPagoRecibePago["totalIngresoCompensado"];
						if($totalCompensadoMasPagadoCom != $tPagoRecibePago["totalCFDI"]){
							if($totalCompensadoMasPagadoCom > $tPagoRecibePago["totalCFDI"]){
								$diferencia = (float) $totalCompensadoMasPagadoCom - (float) $tPagoRecibePago["totalCFDI"];
							}
							if($totalCompensadoMasPagadoCom < $tPagoRecibePago["totalCFDI"]){
								$diferencia = (float) $tPagoRecibePago["totalCFDI"] - (float) $totalCompensadoMasPagadoCom;
							}
							if($diferencia < 0){
								$diferencia = $diferencia * -1;
							}
							if((float) $diferencia > (float) $tConfig["tolerancia_FacturaPagada"]){
								$tdEstiloMonto = "style='background-color: red'";
							}
						}
					}*/

					/*if($tPagoRecibePago["statusComplemento"] == "C" || $tPagoRecibePago["statusComplemento"] == "R" || trim($tPagoRecibePago["RPDRimpagado"]) == ""){
						$tdEstiloMonto = "style='background-color: red'";
						$tdEstiloTipoCambio = "style='background-color: red'";
						$tdEstiloMoneda = "style='background-color: red'";
						$tdEstiloFechaPago = "style='background-color: red'";
						$tdEstiloParcialidad = "style='background-color: red'";
						$tdEstiloParcialidadPago = "style='background-color: red'";
						$tdEstiloFormaDePago = "style='background-color: red'";
						$tdEstiloMetodoDePago = "style='background-color: red'";
						$tPagoRecibePago["RPDRimpagado"] = "";
						$tPagoRecibePago["RPDRmoneda"]="";
						$tPagoRecibePago["RPDRtipocambio"]="";
						$tPagoRecibePago["formadepago"]="";
						$tPagoRecibePago["RPDRnumparcialidad"]="";
						$banIncorrecto=true;
					}*/
					if($tPagoRecibePago["numParcialidadDuplicada"] > 1){
						if($tdEstiloParcialidad != ""){
							$tdEstiloParcialidad = "class='tdParcialidad'";
						}else{
							$tdEstiloParcialidad = "style='background-color: yellow'";
						}
					}
						$body.='
						<tr '.$trEstilo.'>
							<td>'.$tPagoRecibePago["serie"].'</td>
							<td>'.$tPagoRecibePago["folio"].'</td>
							<td>'.$tPagoRecibePago["uuidcfdirelacionado"].'</td>
							<td '.$tdEstiloParcialidad.'>'.$tPagoRecibePago["RPDRnumparcialidad"].'</td>
							<td '.$tdEstiloFechaPago.'>'.$tPagoRecibePago["RDPFechaPago"].'</td>
							<td '.$tdEstiloMoneda.'>'.$tPagoRecibePago["RPDRmoneda"].'</td>
							<td '.$tdEstiloTipoCambio.'>'.$tPagoRecibePago["RPDRtipocambio"].'</td>
							<td '.$tdEstiloMonto.'>'.$tPagoRecibePago["RPDRimpagado"].'</td>
							<td '.$tdEstiloMetodoDePago.'>'.$tPagoRecibePago["RPDRMetodoDePago"].'</td>

							<td '.$tdEstiloParcialidadPago.'>'.$tPagoRecibePago["PDRnumparcialidad"].'</td>
							<td '.$tdEstiloFechaPago.'>'.$tPagoRecibePago["fechaPago"].'</td>
							<td '.$tdEstiloFormaDePago.'>'.$tPagoRecibePago["formadepago"].'</td>
							<td '.$tdEstiloMoneda.'>'.$tPagoRecibePago["PDRmoneda"].'</td>
							<td '.$tdEstiloTipoCambio.'>'.$tPagoRecibePago["PDRtipocambio"].'</td>
							<td '.$tdEstiloMonto.'>'.$tPagoRecibePago["PDRmontoPago"].'</td>
							<td '.$tdEstiloMetodoDePago.'>'.$tPagoRecibePago["PDRMetodoDePago"].'</td>
							<td '.$tdEstiloMetodoDePago.'>'.$tPagoRecibePago["folioNP"].'</td>
							<td '.$tdEstiloMetodoDePago.'>'.$tPagoRecibePago["RFCReceptor"].'</td>

						</tr>';
			
			}//Termina While Relacionados
			$body.="</table></td></tr></table></body></html>";
	} // Termina while Pagos
		// echo $body;exit;
		$arrVal = ["html" => $body, "incorrecto" => $banIncorrecto];
		return $arrVal;
}//Termina función validaRepvsNP
?>
