<?php
require_once __DIR__ ."/conexion/Conexion.php";
class DB extends Conexion
{
	var $ERROR_NO = 0;
	var $MENSAJE = "";
	var $NUM_REGISTROS = 0;
	var $CURSOR;
	var $STMT;
	var $LAST_INSERT_ID;

	function __construct() {
		parent::__construct();
		if($this->conexion_error != 0){
			$this->ERROR_NO = $this->conexion_error;
			$this->MENSAJE = $this->conexion_mensaje;
		}
	}

	function __destruct() {
		$this->ERROR_NO = 0;
		$this->MENSAJE = "";
		if (isset($stmt))
			$stmt->closeCursor();
	}

	function qry_d_registro($tabla,$campo,$id){
		try{
			$sql = 'delete from '.$tabla.' where '.$campo.'= :id';

			$stmt = $this->conexion_db->prepare($sql);

			$stmt->execute(array(':id' => $id));

			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode();
				if($this->ERROR_NO == 1451){
					$this->MENSAJE = "No es posible eliminar un registro con dependencias.";
				}else{
					$this->MENSAJE = $error[2];
				}
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se elimino el registro.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se elimino ".$stmt->rowCount()." registro(s).";
			$this->NUM_REGISTROS = $stmt->rowCount();
			return true;
		}catch(Exception $e){
			$error = $stmt->errorInfo();
			$this->ERROR_NO = $error[1];
			if($this->ERROR_NO == 1451){
				$this->MENSAJE = "No es posible eliminar un registro con dependencias.";
			}else{
				$this->ERROR_NO = 300;
				$this->MENSAJE = "Excepción: ".$e->getMessage();
			}
			return false;
		}
	}
	
	function qry_iud($consulta,$valores){
		try{
			$stmt = $this->conexion_db->prepare($consulta);
			
			// $this->stmt->execute(array(':nuevoValor' => (string) '1',':UUID' => (string) '111111'));
			
			$stmt->execute($valores);
			
			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode;
				$this->MENSAJE = $error[2];
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se inserto el registro.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->LAST_INSERT_ID = $this->conexion_db->lastInsertId();
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se inserto ".$stmt->rowCount()." registro.";
			$this->NUM_REGISTROS = $stmt->rowCount();
			return true;
		}catch(Exception $e){
			$this->ERROR_NO = 300;
			$this->MENSAJE = "Excepción: ".$e->getMessage();
			return false;
		}
	}
	
	function qry_select($consulta,$valores){
		try{
			$stmt = $this->conexion_db->prepare($consulta);
			
			// $this->stmt->execute(array(':nuevoValor' => (string) '1',':UUID' => (string) '111111'));
			
			$stmt->execute($valores);
			
			if($stmt->errorCode() != 0){
				$error = $stmt->errorInfo();
				$this->ERROR_NO = $stmt->errorCode;
				$this->MENSAJE = $error[2];
				return false;
			}

			if($stmt->rowCount() == 0){
				$this->ERROR_NO = 0;
				$this->MENSAJE = "No se inserto el registro.";
				$this->NUM_REGISTROS = $stmt->rowCount();
				return false;
			}
			$this->CURSOR = $stmt->fetch(PDO::FETCH_ASSOC);
			
			$this->LAST_INSERT_ID = $this->conexion_db->lastInsertId();
			$this->ERROR_NO = 0;
			$this->MENSAJE = "Se inserto ".$stmt->rowCount()." registro.";
			$this->NUM_REGISTROS = $stmt->rowCount();
			return true;
		}catch(Exception $e){
			$this->ERROR_NO = 300;
			$this->MENSAJE = "Excepción: ".$e->getMessage();
			return false;
		}
	}
}

?>
