<?php
session_name('portal_absa');
session_start();

date_default_timezone_set('America/Mexico_City');
set_time_limit(0);

require_once('../../clases/wsUtil.class.php');
require_once('../../libs/funciones.php');
require_once('../../clases/datosbd.class.php');
require_once('../../MandaCorreos/FuncionSendMail.php');

$_SESSION["MODULO_PENDIENTES_CANCELAR"] = "1";

$datosbd = new datosbd();
$datosbd->conectar();
try{
	$xml = simplexml_load_string(file_get_contents("enviaPendientesCancelar.xml"));
	$noConfig=0;
	$tipoCancelacion="T";
	if(trim($xml->TipoConsulta) !== ""){
		$tipoCancelacion=trim($xml->TipoConsulta);
	}
	foreach($xml->ConfigRFC as $child) {
		$noConfig++;
		$receptor="";
		$body="";
		$asunto="";
		$correos="";
		$ban=false;
		debug("Inicia Proceso $noConfig",$xml->Debug);
		debug("Validando configuración",$xml->Debug);
		if(trim($child->RFCConsultar) === ""){
			writeLog("No existe RFC a consultar");
			debug("No existe RFC a consultar",$xml->Debug);
			$ban=true;
		}
		if(!is_file($child->Correo->Cuerpo)){
			writeLog("El cuerpo del correo no existe.");
			debug("El cuerpo del correo no existe.",$xml->Debug);
			$ban=true;
		}
		if(trim($child->Correo->AsuntoCorreo) === ""){
			writeLog("El asunto del correo no existe.");
			debug("El asunto del correo no existe.",$xml->Debug);
			$ban=true;
		}
		if(trim($child->Correo->CorreosEnviar) === ""){
			writeLog("No existen correos a enviar.");
			debug("No existen correos a enviar.",$xml->Debug);
			$ban=true;
		}
		
		debug("RFC: ".$child->RFCConsultar,$xml->Debug);
		debug("Cuerpo de correo: ".$child->Correo->Cuerpo,$xml->Debug);
		debug("Asunto de correo: ".$child->Correo->AsuntoCorreo,$xml->Debug);
		debug("Correos: ".$child->Correo->CorreosEnviar,$xml->Debug);
		debug("Termina validar configuración",$xml->Debug);
		
		if($ban===true){
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en EnviaPendientesCancelar - RecibeCFD","Error: Faltan parametros en la configuración.","","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		
		$receptor = $child->RFCConsultar;
		$body = file_get_contents($child->Correo->Cuerpo);
		$asunto = $child->Correo->AsuntoCorreo;
		$correos = $child->Correo->CorreosEnviar;
		
		$wsUtil = new wsUtil($tipoCancelacion);
		debug("Ejecutando webservice de pendientes de cancelación.",$xml->Debug);
		$wsUtil->getPendientesCancelar($receptor);
		debug("Termina ejecución webservice de pendientes de cancelación.",$xml->Debug);
		
		if($wsUtil->RESPONSE->statusWS !== 200){
			writeLog($wsUtil->RESPONSE->errorWS);
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en EnviaPendientesCancelar - RecibeCFD","Error: El WS regreso un status de error. ".$wsUtil->RESPONSE->errorWS,"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		//Comentar en pruebas--------------------------

		if($wsUtil->RESPONSE->codStatus == "1101"){
			debug("No existen pendientes de cancelación",$xml->Debug);
			continue;
		}
		if($wsUtil->RESPONSE->codStatus != "1100"){
			debug("Se recibio una respuesta no reconocida",$xml->Debug);
			continue;
		}

		//Termina codigo de productivo-----------------
		debug("Creando encabezado del cuerpo del correo",$xml->Debug);
		$bodyNuevo = encabezado($body,$receptor);
		if($bodyNuevo === false){
			continue;
		}
		debug("Termina encabezado del cuerpo del correo",$xml->Debug);
		
		//descomentar en pruebas
		// $respuesta = '{
		   // "codStatus": "1100",
		   // "message": "CA1100 - Se recibío la respuesta de la petición de forma exitosa.",
		   // "data":    {
			  // "uuid": ["BF9B771F-6521-42A1-9334-7D71843003E0"],
			  // "codEstatus": "1100"
		   // },
		   // "status": "success",
		   // "statusWS": 200,
		   // "errorWS": "El servicio se ejecuto correctamente."
		// }';
		// $wsUtil->decodificaResponse($respuesta);
		//Termina codigo de pruebas
		debug("Iterando uuids encontrados.",$xml->Debug);
		$banderaError = false;
		$detalle="";
		foreach($wsUtil->RESPONSE->data->uuid as $uuid){
			$rfcEmisor="";
			$nombre="";
			$tipoDocto="";
			$serie="";
			$folio="";
			$iconos="";
			
			debug("Insertando en base de datos uuid $uuid",$xml->Debug);
			// echo $uuid."<br/>";
			insertarBD($uuid,$receptor);
			debug("Ejecutando consulta de uuid $uuid en la base de datos de recibedoce",$xml->Debug);
			if($datosbd->getRecibeDoce($uuid)){
				//Descomentar en pruebas
				// if($datosbd->getRecibeDoce("8AC24A22-17B4-45A3-82E9-7F0D2884F3D7") === true){
				//Termina codigo pruebas
				debug("uuid $uuid consultado correctamente en la base de datos de recibedoce",$xml->Debug);
				debug("Agregando uuid $uuid en detalle.",$xml->Debug);
				
				$arr = explode("--INICIADETALLE--",$body);
				$arrF = explode("--TERMINADETALLE--",$arr[1]);
				if($datosbd->cRecibeDoce != null){
					$arrLbl = array(";;RFCEMISOR;;",";;RAZONSOCIALEMISOR;;",";;TDOCTO;;",";;SERIE;;",";;FOLIO;;",";;UUID;;");
					$arrVal = array($datosbd->cRecibeDoce["rfcEmisor"],$datosbd->cRecibeDoce["nombreemi"],$datosbd->cRecibeDoce["tipoDocto"],$datosbd->cRecibeDoce["serie"],$datosbd->cRecibeDoce["folio"],$uuid);
					debug("El uuid $uuid se encontro en la base de datos de recibedoce",$xml->Debug);
				}else{
					$arrLbl = array(";;RFCEMISOR;;",";;RAZONSOCIALEMISOR;;",";;TDOCTO;;",";;SERIE;;",";;FOLIO;;",";;UUID;;");
					$arrVal = array("","","","","",$uuid);
					debug("El uuid $uuid no se encontro en la base de datos de recibedoce",$xml->Debug);
				}
				$detalle.= str_replace($arrLbl,$arrVal,$arrF[0]);
				
				debug("Termina de construir linea de detalle",$xml->Debug);
			}else{
				writeLog("Ocurrio un error al consultar el uuid $uuid en recibedoce. Error: ".$datosbd->mensajeerror);
				$banderaError = true;
			}
		}
		$bodyNuevo = str_replace("<<DETALLE>>",$detalle,$bodyNuevo);
		if($banderaError === true){
			if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio un error en EnviaPendientesCancelar - RecibeCFD","Error: consultar el uuid $uuid en recibedoce. ".$datosbd->mensajeerror,"","","")){
				writeLog("Ocurrio un error al notificar el error.");
			}
			continue;
		}
		debug("Termina iteración de uuids encontrados.",$xml->Debug);
		
		if($datosbd->cReceptor != null){
			$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHAENVIO;;");
			$arrVal = array($datosbd->cReceptor["nombre"],$receptor,date("Y-m-d H:i:s"));
		}else{
			$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHAENVIO;;");
			$arrVal = array("",$receptor,date("Y-m-d H:i:s"));
		}
		$asunto = str_replace($arrLbl,$arrVal,$asunto);
		
		if(!SendMail($correos,$correos,utf8_decode($asunto),utf8_decode($bodyNuevo),"","","")){
			writeLog("Ocurrio un error al enviar el correo de pendientes de cancelación.");
		}
	}
}catch(Exception $e){
	writeLog($e->getMessage);
	$xml = simplexml_load_string(file_get_contents("enviaPendientesCancelar.xml"));
	if(!SendMail($xml->CorreosError,$xml->CorreosError,"Ocurrio una excepción en EnviaPendientesCancelar - RecibeCFD","Error: ".$e->getMessage,"","","")){
		writeLog("Ocurrio un error al notificar el error.");
	}
	writeLog("Ocurrio un error al enviar el correo de pendientes de cancelación.");
	
}
function encabezado($body,$receptor){
	global $datosbd;
	$arrI = explode("--INICIADETALLE--",$body);
	$arrF = explode("--TERMINADETALLE--",$body);
	$enc = $arrI[0];
	$fin = $arrF[1];
	debug("Consultando receptor $receptor en la base de datos de recibedoce",$xml->Debug);
	if($datosbd->getReceptor($receptor) === true){
		debug("Consulta ejecutada correctamente.",$xml->Debug);
		if($datosbd->cReceptor != null){
			$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHAENVIO;;");
			$arrVal = array($datosbd->cReceptor["nombre"],$receptor,date("Y-m-d H:i:s"));
		}else{
			$arrLbl = array(";;RAZONSOCIAL;;",";;RFC;;",";;FECHAENVIO;;");
			$arrVal = array("",$receptor,date("Y-m-d H:i:s"));
		}
		$enc = str_replace($arrLbl,$arrVal,$enc);
	}else{
		writeLog("Ocurrio un error al consultar el RFC Receptor $receptor. Error: ".$datosbd->mensajeerror);
		return false;
	}
	$enc.="<<DETALLE>>".$fin;
	return $enc;
}

function writeLog($mensaje){
	$date = date("Ymd");
	$dateFull = date("Y-m-d H:i:s");
	if(!is_dir("log")){
		mkdir("log",775);
	}
	$fp = fopen("log/enviaPendientesCancelar_$date.log","a+");
	fwrite($fp,$dateFull." -> ".$mensaje."\r\n");
	fclose($fp);
}
function debug($mensaje,$ban){
	if($ban=="1"){
		$date = date("Ymd");
		$dateFull = date("Y-m-d H:i:s");
		if(!is_dir("log")){
			mkdir("log",775);
		}
		$fp = fopen("log/enviaPendientesCancelar_$date.debug","a+");
		fwrite($fp,$dateFull." -> ".$mensaje."\r\n");
		fclose($fp);
	}
}

function insertarBD($uuid,$rfc){
	global $datosbd;
	$qI = "insert ignore into uuid_pendientes_cancelacion set uuid='$uuid',status='0',rfc='$rfc'";
	if(!mysqli_query($datosbd->CONEXION,$qI)){
		writeLog("Ocurrio un error al insertar el uuid en la base de datos");
		return false;
	}
	return true;
}

?>
