<?
session_name('portal_absa');
session_start();

set_time_limit(0);

require("../../excel/Spreadsheet/Excel/Classes/PHPExcel.php");
require "../../excel/Spreadsheet/Excel/Classes/PHPExcel/IOFactory.php";
require("../../conexion/conectar.php");
require("../../libs/funciones.php");
require("../../MandaCorreos/FuncionSendMail.php");

date_default_timezone_set('America/Mexico_City');

// if(!$TOLERANCIA_COMPENSADO_PAGADO = getINI("TOLERANCIA_COMPENSADO_PAGADO=","../../config.ini")){
	// $TOLERANCIA_COMPENSADO_PAGADO =.5;
// }

$MOD_NP_STATUS_0 = trim(getINI("MOD_NP_STATUS_0=","../../config.ini"));
if($MOD_NP_STATUS_0 == ""){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta MOD_NP_STATUS_0 no configurada", "");exit;
}
$MOD_NP_STATUS_3 = trim(getINI("MOD_NP_STATUS_3=","../../config.ini"));
if($MOD_NP_STATUS_3 == ""){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta MOD_NP_STATUS_3 no configurada", "");exit;
}
$MOD_NP_STATUS_11 = trim(getINI("MOD_NP_STATUS_11=","../../config.ini"));
if($MOD_NP_STATUS_11 == ""){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta MOD_NP_STATUS_11 no configurada", "");exit;
}

$RUTA_ALMACEN_XLS = trim(getINI("RUTA_ALMACEN_XLS=","../../config.ini"));
if($RUTA_ALMACEN_XLS == ""){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta RUTA_ALMACEN_XLS no configurada", "");exit;
}
if(!is_dir($RUTA_ALMACEN_XLS)){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "La ruta configurada RUTA_ALMACEN_XLS no existe.", "");exit;
}

eliminarAnteriores();

if(!$RFC_ACTIVOS_NOTIFICACION_PAGOS = getINI("RFC_ACTIVOS_NOTIFICACION_PAGOS=","../../config.ini")){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA COMPLEMENTOS FALTANTES", "Etiqueta RFC_ACTIVOS_NOTIFICACION_PAGOS Faltante", "No se encontro la etiqueta RFC_ACTIVOS_NOTIFICACION_PAGOS en el config.ini");exit;
}

$conexion = new CONDB();
$conexion->conectar();

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator("DIS")
							 ->setLastModifiedBy("DIS")
							 ->setTitle("Office 2007 XLSX")
							 ->setSubject("Office 2007 XLSX")
							 ->setDescription("Document for Office 2007 XLSX")
							 ->setKeywords("office 2007")
							 ->setCategory("Result file");
							 

$arrRFCReceptores = explode(",",$RFC_ACTIVOS_NOTIFICACION_PAGOS);


for($i=0; $i < count($arrRFCReceptores); $i++){
	//Extraigo Configuracion General de notificaciones
	$qConfig = "select rfc_receptor,notificar_dias,notificar_despuesde,notificar_repetirdias,notificar_correos,notificar_asunto,notificar_correos_cc,notificar_fecha_inicio,tolerancia_NPvsComplemento,tolerancia_NPvsFactura,tolerancia_FacturaPagada,tolerancia_CompensacionEgreso,tolerancia_tipoCambio, valida_fecha_pago,
date_format(fecha_valida_fecha_pago,'%Y%m%d%H%i%s') as formatFecha_valida_fecha_pago from configpagina where rfc_receptor='".$arrRFCReceptores[$i]."' limit 1";
	if(!$rConfig = mysqli_query($conexion->CONEXION,$qConfig)){
		setBitacora($conexion, "AUTOMATICO", $arrRFCReceptores[$i] , "NOTIFICACION AUTOMATICA COMPLEMENTOS FALTANTES", "Error en consulta de configuracion general.", $qConfig);exit;
	}
	if(mysqli_num_rows($rConfig) <= 0){
		setBitacora($conexion, "AUTOMATICO", $arrRFCReceptores[$i] , "NOTIFICACION AUTOMATICA COMPLEMENTOS FALTANTES", "No se encontro la configuracion del receptor.", $qConfig);continue;
	}
	$tConfig = mysqli_fetch_assoc($rConfig);
	
	$formatFecha_valida_fecha_pago = $tConfig["formatFecha_valida_fecha_pago"];
	$valida_fecha_pago = $tConfig["valida_fecha_pago"];
	$tConfig["tolerancia_NPvsComplemento"] = (float) $tConfig["tolerancia_NPvsComplemento"];
	$tConfig["tolerancia_NPvsFactura"] = (float) $tConfig["tolerancia_NPvsFactura"];
	$tConfig["tolerancia_FacturaPagada"] = (float) $tConfig["tolerancia_FacturaPagada"];
	$tConfig["tolerancia_CompensacionEgreso"] = (float) $tConfig["tolerancia_CompensacionEgreso"];
	$tConfig["tolerancia_tipoCambio"] = (float) $tConfig["tolerancia_tipoCambio"];
	
	//Valido la fecha
	$completaQueryValidacionFechaInicio = "";
	if($tConfig['notificar_fecha_inicio'] != ""){
		$completaQueryValidacionFechaInicio = "fecha >= '".$tConfig['notificar_fecha_inicio']."' and ";
	}

	$tConfig["tolerancia_NPvsComplemento"] = (trim($tConfig["tolerancia_NPvsComplemento"]) == "")? 0 : $tConfig["tolerancia_NPvsComplemento"];
	$tConfig["tolerancia_NPvsFactura"] = (trim($tConfig["tolerancia_NPvsFactura"]) == "")? 0 : $tConfig["tolerancia_NPvsFactura"];
	$tConfig["tolerancia_FacturaPagada"] = (trim($tConfig["tolerancia_FacturaPagada"]) == "")? 0 : $tConfig["tolerancia_FacturaPagada"];
	$tConfig["tolerancia_CompensacionEgreso"] = (trim($tConfig["tolerancia_CompensacionEgreso"]) == "")? 0 : $tConfig["tolerancia_CompensacionEgreso"];
	$tConfig["tolerancia_tipoCambio"] = (trim($tConfig["tolerancia_tipoCambio"]) == "")? 0 : $tConfig["tolerancia_tipoCambio"];

	//CONSULTO NOTIFICACION DE PAGO DEL RECEPTOR
	/*$qPagos = "select d.rfcreceptor,d.serie,d.folio,d.adicionalA as uuid,d.rfcemisor,d.moneda,d.tipocambio,d.nombrerec,d.total,
	dstatus.totalPPD as totalPorMetodoDePagoPPD,dstatus.totalPUE as totalPorMetodoDePagoPUE,
	d.con_complemento_correcto,d.adicionalB as formadepago, d.fechaPago, d.fecha, dstatus.status, date_format(d.fechaPago,'%Y%m%d%H%i%s') as formatFechaPago
	from doce d inner join recibecfd_doce_status dstatus 
	ON d.adicionalA=dstatus.uuid
	where $completaQueryValidacionFechaInicio d.tipodocto='NOTIFICACION DE PAGO' and dstatus.status in('0','3','11') and d.con_complemento_correcto='0' and d.status='1' and d.rfcemisor='".trim($arrRFCReceptores[$i])."'
	group by d.adicionalA
	order by rfcreceptor";*/
	
	$qPagos = "select d.rfcreceptor,d.serie,d.folio,d.adicionalA as uuid,d.rfcemisor,d.moneda,d.tipocambio,d.nombrerec,d.total,
	dstatus.totalPPD as totalPorMetodoDePagoPPD,dstatus.totalPUE as totalPorMetodoDePagoPUE,
	d.con_complemento_correcto,d.adicionalB as formadepago, d.fechaPago, d.fecha, dstatus.status, date_format(d.fechaPago,'%Y%m%d%H%i%s') as formatFechaPago
	from (select * from doce where $completaQueryValidacionFechaInicio tipodocto='NOTIFICACION DE PAGO' and con_complemento_correcto='0' and status='1' and rfcemisor='".trim($arrRFCReceptores[$i])."') d  inner join recibecfd_doce_status dstatus 
	ON d.adicionalA=dstatus.uuid
	where dstatus.status in('0','3','11') group by d.adicionalA
	order by d.rfcreceptor";
	 // echo $qPagos;exit;

	if(!$rPago = mysqli_query($conexion->CONEXION,$qPagos)){
		setBitacora($conexion, "AUTOMATICO", $arrRFCReceptores[$i], "NOTIFICACION AUTOMATICA COMPLEMENTOS FALTANTES", "Error en consulta de NOTIFICACIONES DE PAGO", $qPagos);exit;
	}
	if(mysqli_num_rows($rPago) <= 0){
		continue;
	}
	$objPHPExcel = new PHPExcel();
	$objPHPExcel->getProperties()->setCreator("DIS")
							 ->setLastModifiedBy("DIS")
							 ->setTitle("Office 2007 XLSX")
							 ->setSubject("Office 2007 XLSX")
							 ->setDescription("Document for Office 2007 XLSX")
							 ->setKeywords("office 2007")
							 ->setCategory("Result file");
	$num_row = 0;
	$col_name=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
	$header_name = array("Serie","Folio","Total PUE","Total PPD","Total","Moneda","Tipo Cambio","Forma de Pago","Proveedor","Status","Fecha de Pago");
	$detail_name = array("Serie","Folio","UUID","Parcialidad","Fecha de Pago","Moneda","T. Cambio","Monto","Metodo de Pago","Parcialidad","Fecha de Pago","Moneda","T. Cambio","Forma de Pago","Monto","Metodo de Pago","REP UUID","REP Serie","REP Folio");
	$entroNveces=0;
	//ITERO TODOS LOS PAGOS
	while($tPago = mysqli_fetch_array($rPago)){
		$validarTipoCambio = true;
		if($tPago["totalPorMetodoDePagoPPD"] == 0){
			continue;
		}
		
		$entroNveces++;
		
		$num_row++;
		//************************************
		// Titulo Pago
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[0].$num_row, "Pago");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[0].$num_row.":".$col_name[(count($header_name)-1)].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[0].$num_row.":".$col_name[(count($header_name)-1)].$num_row);
		//************************************
		
		//************************************
		// Titulos encabezado
		$num_row++;
		$col=0;
		for($row=0; $row < count($header_name); $row++){
			$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $header_name[$row]);
			$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
			$col++;
		}
		// doy formato a color a titulos del Pago
		headerStyle($col_name[0].$num_row.":".$col_name[(count($header_name)-1)].$num_row);
		//************************************
		
		//************************************
		// Datos del Pago
		$codigo = '$tPago["status"] = $MOD_NP_STATUS_'.$tPago["status"].';';
		eval($codigo);
		$datosEncabezado = array($tPago["serie"],$tPago["folio"],$tPago["totalPorMetodoDePagoPUE"],$tPago["totalPorMetodoDePagoPPD"],$tPago["total"],$tPago["moneda"],$tPago["tipocambio"],$tPago["formadepago"],$tPago["nombrerec"],$tPago["status"],$tPago["fechaPago"]);
		$num_row++;
		$col=0;
		for($row=0; $row < count($header_name); $row++){
			$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $datosEncabezado[$row]);
			$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
			$col++;
		}
		//************************************
		
		
		
		$qPagoRecibePago = "select pdr.uuidcfdirelacionado,
		r1.serie,r1.folio,
		pdr.monto as PDRmontoPago,pdr.numparcialidad as PDRnumparcialidad,pdr.tipocambio as PDRtipocambio,pdr.moneda as PDRmoneda, rpdr.tipocambiodr as RPDRtipocambio,r.total as totalCFDI,r1.MetodoDePago as MetodoDePagoDoc,pdr.MetodoDePago as PDRMetodoDePago,rpdr.MetodoDePago as RPDRMetodoDePago,
	rpdr.monedadr as RPDRmoneda,rpdr.imppagado as RPDRimpagado,rpdr.NumParcialidad as RPDRnumparcialidad, r.nombreemi, rdp.MonedaP as RDPmoneda,rdp.Monto as RDPmonto,rdp.recibedoce_UUID,
	rdp.TipoCambioP as RDPtipocambio,rdp.formadepago, rdp.FechaPago as RDPFechaPago, date_format(rdp.FechaPago,'%Y%m%d%H%i%s') as formatRDPFechaPago, rcomplemento.status as statusComplemento,rcomplemento.uuid as RepUUID,rcomplemento.serie as RepSerie,rcomplemento.folio as RepFolio, 
	rdt.totalPagoDocumentosRef, rdt.totalIngresoCompensado, rdt.ImpPagadoComplemento, rdt.FechaNP, rdt.numReferenciasPagoDocumentosRef,
	(select count(*) from pago_documentos_ref where uuidcfdirelacionado=pdr.uuidcfdirelacionado and numparcialidad=pdr.numparcialidad) as numParcialidadDuplicada,pdr.doce_uuid
	from pago_documentos_ref pdr 
	left join recibedoce r1 
	ON pdr.uuidcfdirelacionado = r1.uuid 
	left join recibedoce_pagos_docto_relacionado rpdr 
	ON pdr.doce_uuid = rpdr.doce_uuid and pdr.uuidcfdirelacionado = rpdr.uuidcfdirelacionado and 
	(pdr.numparcialidad = rpdr.numparcialidad or pdr.numparcialidad <> rpdr.numparcialidad) 
	left join recibedoce_pagos rdp 
	ON rpdr.recibedoce_pagos_id = rdp.recibedoce_pagos_id 
	left join recibedoce r 
	ON rpdr.uuidcfdirelacionado = r.uuid 
	left join recibedoce_totales rdt
	ON rdt.uuid=r.uuid
	left join recibedoce rcomplemento on rdp.recibedoce_UUID = rcomplemento.uuid 
	where pdr.doce_uuid='".$tPago["uuid"]."' and r1.MetodoDePago='PPD' and (rcomplemento.status IN ('A','S','W','WS') or rcomplemento.status is null) and length(trim(pdr.uuidcfdirelacionado)) > 1";
	// where pdr.doce_uuid='".$tPago["uuid"]."' and r1.MetodoDePago='PPD' and rcomplemento.status IN ('A','S','W','WS')";
	// echo $qPagoRecibePago."<br/><br/>";continue;
	/*if($tPago['uuid'] == "AA4C1A86-8728-4E42-9733-317935B47414"){
				echo $qPagoRecibePago;exit;
			}*/
			
			$qMoneda = "select moneda from pago_documentos_ref where doce_uuid = '".$tPago["uuid"]."' group by moneda";
			if(!$rMoneda = mysqli_query($conexion->CONEXION,$qMoneda)){
				?><script>$j_6.messager.alert("Error","Ocurrio un error al consultar las monedas de la NP <?php echo $tPago["serie"].$tPago["folio"];?>","error.");</script><?exit;
			}
			if(mysqli_num_rows($rMoneda) > 0){
				if(mysqli_num_rows($rMoneda) == 1){
					$qMoneda = "select moneda from pago_documentos_ref where doce_uuid = '".$tPago["uuid"]."' group by moneda limit 1";
					if(!$rMoneda = mysqli_query($conexion->CONEXION,$qMoneda)){
						?><script>$j_6.messager.alert("Error","Ocurrio un error al consultar la moneda detalle de la NP <?php echo $tPago["serie"].$tPago["folio"];?>","error.");</script><?exit;
					}
					$tMoneda = mysqli_fetch_assoc($rMoneda);
					if(trim(strtoupper($tMoneda["moneda"])) == trim(strtoupper($tPago["moneda"]))){
						$validarTipoCambio = false;
					}
				}
			}else{
				?><script>$j_6.messager.alert("Error","No se encontraron las monedas de pago de la NP <?php echo $tPago["serie"].$tPago["folio"];?>","error.");</script><?exit;
			}

		
		if(!$rPagoRecibePago = mysqli_query($conexion->CONEXION,$qPagoRecibePago)){
			setBitacora($conexion, "AUTOMATICO", "AUTOMATICO", "NOTIFICACION AUTOMATICA COMPLEMENTOS FALTANTES", "Ocurrio un error al consultar los documentos de referencia de pagos", $qPagoRecibePago);exit;
		}
		if(mysqli_num_rows($rPagoRecibePago) <= 0){
			/*$body.='
			<tr>
				<td colspan="10" style="padding: 20px 20px 20px 20px">
					<table width="98%" bgcolor="white" style="border: 2px #DDDDDD solid">
						<tr>
							<th style="background-color: #fcfbe5; text-align: center"></th>
						</tr>
					</table>
				</td>
			</tr>
			</table>';*/
			continue;
		}
		$con=0;
		
		$num_row++;
		//************************************
		// Titulo Pago / I CFDI 3.3
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[1].$num_row, "Pago / I CFDI 3.3");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[1].$num_row.":".$col_name[8].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[1].$num_row.":".$col_name[8].$num_row);
		//************************************
		
		//************************************
		// Titulo Complemento / I CFDI 3.3
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[9].$num_row, "Complemento / I CFDI 3.3");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[9].$num_row.":".$col_name[17].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[9].$num_row.":".$col_name[17].$num_row);
		//************************************
		
		//************************************
		// Titulos Detalle
		$num_row++;
		$col=1;
		for($row=0; $row < count($detail_name); $row++){
			$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $detail_name[$row]);
			$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
			$col++;
		}
		// doy formato a color a titulos del I CFDI
		headerStyle($col_name[1].$num_row.":".$col_name[8].$num_row,"7FB3D5");
		headerStyle($col_name[9].$num_row.":".$col_name[17].$num_row,"7DCEA0");
		//************************************
			
		
		
		/*
		************************************************************************
		************************************************************************
		************************************************************************
		************************************************************************
		************************************************************************
		************************************************************************
		empieza a iterar los cfdi pagados
		*/
		$totalMontosFacturasNP=0;
		$sumaMontoPago=0.00;
		$banIncorrecto=false;
		$totalPPD=0.00;
		$totalEncabezadoComplemento = 0.00;
		while($tPagoRecibePago = mysqli_fetch_array($rPagoRecibePago,MYSQLI_ASSOC)){
			//Si es una PUE la ignoro
			if(trim($tPagoRecibePago["MetodoDePagoDoc"]) == "PUE"){
				continue;
			}
			if($tPagoRecibePago["MetodoDePagoDoc"] == "PPD"){
				// $totalPPD = $totalPPD + $tPagoRecibePago["PDRmontoPago"];
				$totalPPD = $totalPPD + (((float) $tPagoRecibePago["PDRmontoPago"]) / (float) $tPagoRecibePago["PDRtipocambio"]);
			}
			$totalEncabezadoComplemento = $tPagoRecibePago["RDPmonto"];
			
			
			$tdEstiloMonto = "FFFFFF";
			$tdEstiloTipoCambio = "FFFFFF";
			$tdEstiloMoneda = "FFFFFF";
			$tdEstiloFechaPago = "FFFFFF";
			$tdEstiloParcialidad = "FFFFFF";
			$tdEstiloFormaDePago = "FFFFFF";
			$tdEstiloMetodoDePago = "FFFFFF";
			$tdEstiloParcialidadPago = "FFFFFF";
			
			//Valido el monto pagado al documento en NP vs Complemento
			if($tPagoRecibePago["PDRmontoPago"] != $tPagoRecibePago["RPDRimpagado"]){
				
				$diferencia = (float) $tPagoRecibePago["PDRmontoPago"] - (float) $tPagoRecibePago["RPDRimpagado"];
				if($diferencia < 0){
					$diferencia = $diferencia * -1;
				}
				
				if((float) $diferencia > (float) $tConfig["tolerancia_NPvsComplemento"]){
					// red pastel
					$tdEstiloMonto = "E74C3C";
					$banIncorrecto=true;
				}else{
					//orange pastel
					$tdEstiloMonto = "EB984E";
				}
				// $tdEstiloMonto = "style='background-color: red'";
				// $banIncorrecto=true;
			}
			//Valido el tipo de cambio del pago al documento en NP vs Complemento
			if($validarTipoCambio == true){
				if($tPagoRecibePago["PDRtipocambio"] != $tPagoRecibePago["RPDRtipocambio"]){
					$diferencia = (float) $tPagoRecibePago["PDRtipocambio"] - (float) $tPagoRecibePago["RPDRtipocambio"];
					if($diferencia < 0){
						$diferencia = $diferencia * -1;
					}
					
					if((float) $diferencia > (float) $tConfig["tolerancia_tipoCambio"]){
						// red pastel
						$tdEstiloTipoCambio = "E74C3C";
						$banIncorrecto=true;
					}else{
						// ornge pastel
						$tdEstiloTipoCambio = "EB984E";
					}
					// $tdEstiloTipoCambio = "style='background-color: red'";
					// $banIncorrecto=true;
				}
			}
			
			//Valido la moneda
			if($tPagoRecibePago["PDRmoneda"] != $tPagoRecibePago["RPDRmoneda"]){
				// red pastel
				$tdEstiloMoneda = "E74C3C";
				$banIncorrecto=true;
			}
			//Valido el numero de parcialidad
			if($tPagoRecibePago["PDRnumparcialidad"] != $tPagoRecibePago["RPDRnumparcialidad"]){
				// red pastel
				$tdEstiloParcialidad = "E74C3C";
				$tdEstiloParcialidadPago = "E74C3C";
				$banIncorrecto=true;
			}
			//Valido la forma de pago
			if(trim($tPagoRecibePago["formadepago"]) != trim($tPago["formadepago"])){
				// red pastel
				$tdEstiloFormaDePago = "E74C3C";
				$banIncorrecto=true;
			}
			
			//Valido la fecha de pago
			/*if($valida_fecha_pago == "1"){
				if(substr($tPago["formatFechaPago"],0,8) >= substr($formatFecha_valida_fecha_pago,0,8)){									
					if($tPago["formatFechaPago"] != $tPagoRecibePago["formatRDPFechaPago"]){
						$tdEstiloFechaPago = "E74C3C";
						$banIncorrecto = true;
					}
				}
			}*/
			if($valida_fecha_pago == "1"){
				if($tPago["formatFechaPago"] == ""){
					$tdEstiloFechaPago = "E74C3C";
					$banIncorrecto = true;
				}else if(substr($tPago["formatFechaPago"],0,8) >= substr($formatFecha_valida_fecha_pago,0,8)){
					if(substr($tPagoRecibePago["formatRDPFechaPago"],8,6) != "120000"){
						if($tPago["formatFechaPago"] != $tPagoRecibePago["formatRDPFechaPago"]){
							$tdEstiloFechaPago = "E74C3C";
							$banIncorrecto = true;
						}
					}
				}
			}
							
			if(trim($tPagoRecibePago["PDRMetodoDePago"]) != trim($tPagoRecibePago["RPDRMetodoDePago"])){
				// red pastel
				$tdEstiloMetodoDePago = "E74C3C";
				$banIncorrecto=true;
			}
			
			//Valido que si es PUE, el pago haya sido por completo al total del CFDI
			if(trim($tPago["RPDRMetodoDePago"]) == "PUE"){
				$totalCompensadoMasPagadoCom = $tPagoRecibePago["RPDRimpagado"]+$tPagoRecibePago["totalIngresoCompensado"];
				if($totalCompensadoMasPagadoCom != $tPagoRecibePago["totalCFDI"]){
					if($totalCompensadoMasPagadoCom > $tPagoRecibePago["totalCFDI"]){
						$diferencia = (float) $totalCompensadoMasPagadoCom - (float) $tPagoRecibePago["totalCFDI"];
					}
					if($totalCompensadoMasPagadoCom < $tPagoRecibePago["totalCFDI"]){
						$diferencia = (float) $tPagoRecibePago["totalCFDI"] - (float) $totalCompensadoMasPagadoCom;
					}
					if($diferencia < 0){
						$diferencia = $diferencia * -1;
					}
					if((float) $diferencia > (float) $tConfig["tolerancia_FacturaPagada"]){
						// red pastel
						$tdEstiloMonto = "E74C3C";
					}
				}
			}
			
			if($tPagoRecibePago["statusComplemento"] == "C" || $tPagoRecibePago["statusComplemento"] == "R" || trim($tPagoRecibePago["RPDRimpagado"]) == ""){
				// red pastel
				$tdEstiloMonto = "E74C3C";
				$tdEstiloTipoCambio = "E74C3C";
				$tdEstiloFechaPago = "E74C3C";
				$tdEstiloMoneda = "E74C3C";
				$tdEstiloParcialidad = "E74C3C";
				$tdEstiloParcialidadPago = "E74C3C";
				$tdEstiloFormaDePago = "E74C3C";
				$tdEstiloMetodoDePago = "E74C3C";
				$tPagoRecibePago["RPDRimpagado"] = "";
				$tPagoRecibePago["RPDRmoneda"]="";
				$tPagoRecibePago["RPDRtipocambio"]="";
				$tPagoRecibePago["formadepago"]="";
				$tPagoRecibePago["RPDRnumparcialidad"]="";
				$banIncorrecto=true;
			}
			if($tPagoRecibePago["numParcialidadDuplicada"] > 1){
				if($tdEstiloParcialidadPago != ""){
					$tdEstiloParcialidadPago = "class='tdParcialidadPago'";
				}else{
					// yellow pastel
					$tdEstiloParcialidadPago = "F4D03F";
				}
			}
			
			$datosDetalle = array($tPagoRecibePago["serie"],$tPagoRecibePago["folio"],$tPagoRecibePago["uuidcfdirelacionado"],$tPagoRecibePago["PDRnumparcialidad"],$tPago["fechaPago"],$tPagoRecibePago["PDRmoneda"],$tPagoRecibePago["PDRtipocambio"],$tPagoRecibePago["PDRmontoPago"],$tPagoRecibePago["PDRMetodoDePago"],$tPagoRecibePago["RPDRnumparcialidad"],$tPagoRecibePago["RDPFechaPago"],$tPagoRecibePago["RPDRmoneda"],$tPagoRecibePago["RPDRtipocambio"],$tPagoRecibePago["formadepago"],$tPagoRecibePago["RPDRimpagado"],$tPagoRecibePago["RPDRMetodoDePago"],$tPagoRecibePago["RepUUID"],$tPagoRecibePago["RepSerie"],$tPagoRecibePago["RepFolio"]);
			$datosColor = array("FFFFFF","FFFFFF","FFFFFF",$tdEstiloParcialidadPago,$tdEstiloFechaPago,$tdEstiloMoneda,$tdEstiloTipoCambio,$tdEstiloMonto,$tdEstiloMetodoDePago,$tdEstiloParcialidad,$tdEstiloFechaPago,$tdEstiloMoneda,$tdEstiloTipoCambio,$tdEstiloFormaDePago,$tdEstiloMonto,$tdEstiloMetodoDePago,"FFFFFF","FFFFFF","FFFFFF");
			
			$num_row++;
			$col=1;
			for($row=0; $row < count($detail_name); $row++){
				$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $datosDetalle[$row]);
				$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
				// formateo la celda segun las validaciones anteriores, indicando status de celdas
				$objPHPExcel->getActiveSheet()->getStyle($col_name[$col].$num_row)->applyFromArray(
					array(
						'fill' => array(
							'type' => PHPExcel_Style_Fill::FILL_SOLID,
							'color' => array('rgb' => $datosColor[$row])
						)
					)
				);

				$col++;
			}
			
				
			// $sumaMontoPago = $tPagoRecibePago["RDPmonto"];
			// $sumaMontoPago += (trim($tPagoRecibePago["RPDRimpagado"]) == "")? 0.00 : $tPagoRecibePago["RPDRimpagado"];
			
			$sumaMontoPago += (trim($tPagoRecibePago["RPDRimpagado"]) == "")? 0.00 : ((float) (trim($tPagoRecibePago["RPDRimpagado"]))) / (float) $tPagoRecibePago["RPDRtipocambio"];
			
			// $totalMontosFacturasNP = (float) $totalMontosFacturasNP + (float) $tPagoRecibePago["PDRmontoPago"];
			$totalMontosFacturasNP = (float) $totalMontosFacturasNP + (((float) $tPagoRecibePago["PDRmontoPago"]) / (float) $tPagoRecibePago["PDRtipocambio"]);
		}// Termina While Facturas y Complementos de la Notificacion de pago
		
		$tdEstiloPagoTotal="FFFFFF";
		$tdEstiloPagoTotalComplemento="FFFFFF";
		$tdEstiloTotalMontosFacturasNP="FFFFFF";
		//Valido el monto total de la Notificaci�n de Pago contra el monto total del complemento.
		//Multiplico por 1000000 para sacar la parte entera y poder comparar enteros, ya que con decimales hay problemas
		$totalEnPago1000000 = $tPago["totalPorMetodoDePagoPPD"] * 1000000;
		$sumaMontoPago1000000 = $sumaMontoPago * 1000000;
		$totalEncabezadoComplemento1000000 = $totalEncabezadoComplemento * 1000000;
		$arrTotalEnPago1000000 = explode(".",$totalEnPago1000000);
		$arrSumaMontoPago1000000 = explode(".",$sumaMontoPago1000000);
		$arrTotalEncabezadoComplemento1000000 = explode(".",$totalEncabezadoComplemento1000000);
		// if($tPago["totalPorMetodoDePagoPPD"] != $sumaMontoPago){
		if($arrTotalEnPago1000000[0] != $arrSumaMontoPago1000000[0]){
			$diferencia = (float) $tPago["totalPorMetodoDePagoPPD"] - (float) $sumaMontoPago;
			if($diferencia < 0){
				$diferencia = $diferencia * -1;
			}
			
			if((float) $diferencia > (float) $tConfig["tolerancia_NPvsComplemento"]){
				// red pastel
				$tdEstiloPagoTotal = "E74C3C";
				$banIncorrecto=true;
			}else{
				// orange pastel
				$tdEstiloPagoTotal = "EB984E";
			}
			// $tdEstiloPagoTotal="style='background-color: red'";
			// $banIncorrecto=true;
		}
		
		//Valido total encabezado complemento vs total en NP
		if($arrTotalEnPago1000000[0] != $arrTotalEncabezadoComplemento1000000[0]){
			$diferencia = (float) $tPago["totalPorMetodoDePagoPPD"] - (float) $totalEncabezadoComplemento;
			if($diferencia < 0){
				$diferencia = $diferencia * -1;
			}
			
			if((float) $diferencia > (float) $tConfig["tolerancia_NPvsComplemento"]){
				// red pastel
				$tdEstiloPagoTotalComplemento = "E74C3C";
				$banIncorrecto=true;
			}else{
				// orange pastel
				$tdEstiloPagoTotalComplemento = "EB984E";
			}
			// $tdEstiloPagoTotalComplemento="style='background-color: red'";
			// $banIncorrecto=true;
		}
		
		//Valido el monto total de la Notificaci�n de Pago contra el total de la suma de los montos de las facturas
		//Multiplico por 1000000 para sacar la parte entera y poder comparar enteros, ya que con decimales hay problemas
		$totalMontosFacturasNP1000000 = $totalMontosFacturasNP * 1000000;
		$arrTotalMontosFacturasNP1000000 = explode(".",$totalMontosFacturasNP1000000);
		// if($tPago["totalPorMetodoDePagoPPD"] != $totalMontosFacturasNP){
		if($arrTotalEnPago1000000[0] != $arrTotalMontosFacturasNP1000000[0]){
			$diferencia = (float) $tPago["totalPorMetodoDePagoPPD"] - (float) $totalMontosFacturasNP;
			if($diferencia < 0){
				$diferencia = $diferencia * -1;
			}
			if((float) $diferencia > (float) $tConfig["tolerancia_NPvsFactura"]){
				// red pastel
				$tdEstiloTotalMontosFacturasNP = "E74C3C";
				$banIncorrecto=true;
			}else{
				// orange pastel
				$tdEstiloTotalMontosFacturasNP = "EB984E";
			}
			// $tdEstiloTotalMontosFacturasNP="style='background-color: red'";
			// $banIncorrecto=true;
		}
		
		$num_row++;
		//************************************
		// Titulo Total pagado
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[1].$num_row, "Total Pago");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[1].$num_row.":".$col_name[7].$num_row);
		//************************************
		//************************************
		// Valor total pagado NP
		// $objPHPExcel->getActiveSheet()->setCellValue($col_name[8].$num_row, number_format($totalMontosFacturasNP,6,".",","));
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[8].$num_row, number_format(floor($totalMontosFacturasNP*1000000)/1000000, 6,".",","));
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[8].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloTotalMontosFacturasNP)
				)
			)
		);
		//************************************
		
		//************************************
		//
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[9].$num_row, "Total Suma Complemento");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[9].$num_row.":".$col_name[14].$num_row);
		//************************************
		//************************************
		//
		// $objPHPExcel->getActiveSheet()->setCellValue($col_name[15].$num_row, number_format($sumaMontoPago,6,".",","));
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[15].$num_row, number_format(floor($sumaMontoPago*1000000)/1000000, 6,".",","));
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[15].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoTotal)
				)
			)
		);
		//************************************
		
		$num_row++;
		//************************************
		//
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[9].$num_row, "Total Complemento");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[9].$num_row.":".$col_name[14].$num_row);
		//************************************
		//************************************
		//
		// $objPHPExcel->getActiveSheet()->setCellValue($col_name[15].$num_row, number_format($totalEncabezadoComplemento,6,".",","));
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[15].$num_row, number_format(floor($totalEncabezadoComplemento*1000000)/1000000, 6,".",","));
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[15].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoTotalComplemento)
				)
			)
		);
		//************************************
						
	
		
	}//Termina While Notificacion Pago
	if($entroNveces == 0){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA REPS FALTANTES-MASIVO", "Nada que enviar", "");exit;
	}
	$objPHPExcel->getActiveSheet()->setTitle("Complementos Faltantes de Pago");

	$objPHPExcel->setActiveSheetIndex(0);
	$nombreArchivo = date("YmdHis");
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

	$objWriter->save($RUTA_ALMACEN_XLS.$nombreArchivo.'.xlsx');

	enviaCorreo($nombreArchivo,$tConfig);
}//Termina FOR Receptores



function enviaCorreo($nombreArchivo,$tConfig){
	global $conexion;
	$correos = getINI($tConfig["rfc_receptor"]."_CORREOS_ENVIAR_REPS_FALTANTES=","../../config.ini");
	$asunto = getINI($tConfig["rfc_receptor"]."_ASUNTO_ENVIAR_REPS_FALTANTES=","../../config.ini");
	$cuerpo = getINI($tConfig["rfc_receptor"]."_CUERPO_ENVIAR_REPS_FALTANTES=","../../config.ini");
	if(trim($cuerpo) != ""){
		if(!file_exists($cuerpo)){
			setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA REPS FALTANTES-MASIVO", "Etiqueta ".$tConfig["rfc_receptor"]."_CUERPO_ENVIAR_REPS_FALTANTES", "El archivo no existe");exit;
		}else{
			$cuerpo = file_get_contents($cuerpo);
		}
	}else{
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA REPS FALTANTES-MASIVO", "Etiqueta ".$tConfig["rfc_receptor"]."_CUERPO_ENVIAR_REPS_FALTANTES", "No configurada");exit;
	}
	$DIAS_DISPONIBLE_REPORTES = getINI("DIAS_DISPONIBLE_REPORTES=","../../config.ini");
	$URL_DESCARGA_XLS = getINI("URL_DESCARGA_XLS=","../../config.ini");
	$arrLbl = array("<<DIAS_DISPONIBLE_REPORTES>>","<<URL_DESCARGA_XLS>>");
	$arrVal = array($DIAS_DISPONIBLE_REPORTES,$URL_DESCARGA_XLS.$nombreArchivo.".xlsx");
	$cuerpo = str_replace($arrLbl,$arrVal,$cuerpo);
	if(trim($correos) == ""){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta ".$tConfig["rfc_receptor"]."_CORREOS_ENVIAR_REPS_FALTANTES no configurada", "");exit;
	}
	
	
	if(!@SendMail($correos,$correos,utf8_decode($asunto),$cuerpo,"","","")){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Error al enviar el correo", "");exit;
	}
	
	
}

function eliminarAnteriores(){
	global $RUTA_ALMACEN_XLS;
	
	$DIAS_DISPONIBLE_REPORTES = getINI("DIAS_DISPONIBLE_REPORTES=","../../config.ini");

	$directorio = opendir($RUTA_ALMACEN_XLS);
	while ($archivo = readdir($directorio)){
		$arrNombre = pathinfo($archivo);
		$nameFile = $RUTA_ALMACEN_XLS.$arrNombre["filename"].".".$arrNombre["extension"];
		if(is_file($nameFile)){
			if(trim($DIAS_DISPONIBLE_REPORTES) == "" || trim($DIAS_DISPONIBLE_REPORTES) == "0"){
				$DIAS_DISPONIBLE_REPORTES = 5;
			}
			
			$fechaArchivo = substr($arrNombre["filename"],0,8);
			
			$nuevafecha = strtotime ( '+'.$DIAS_DISPONIBLE_REPORTES.' day' , strtotime ( $fechaArchivo ) ) ;
			$fecha = date("Ymd");
			$nuevafecha = date("Ymd",$nuevafecha);
			if((int)$fecha > (int)$nuevafecha){
				unlink($nameFile);
			}
		}
	}

}

function headerStyle($rango,$backgroundColor = "EEEEEE"){
	global $objPHPExcel;
	//header style
	$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray(
			array(
				'font'    => array(
					'bold'      => true
				),
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				),
				'borders' => array(
					'top'     => array(
						'style' => PHPExcel_Style_Border::BORDER_THIN
					)
				),
				'fill' => array(
					'type'       => PHPExcel_Style_Fill::FILL_SOLID,
					'rotation'   => 90,
					'startcolor' => array(
						'argb' => $backgroundColor
					),
					'endcolor'   => array(
						'argb' => 'FFFFFFFF'
					)
				)
			)
	);
}

function sumaDiasFecha($fecha,$dias){
	$fechaS = date("Y-m-d", strtotime("$fecha $dias days"));
	return $fechaS;
}

function getUltimoDiaMes($elAnio,$elMes) {
  return date("d",(mktime(0,0,0,$elMes+1,1,$elAnio)-1));
}

function date_diff2($date1, $date2) { 
    $current = $date1; 
    $datetime2 = date_create($date2); 
    $count = 0; 
    while(date_create($current) < $datetime2){ 
        $current = gmdate("Y-m-d", strtotime("+1 day", strtotime($current))); 
        $count++; 
    } 
    return $count; 
}

function dateDifference($date_1 , $date_2 , $differenceFormat = '%a' )
{
    $datetime1 = date_create($date_1);
    $datetime2 = date_create($date_2);
    
    $interval = date_diff($datetime1, $datetime2);
    
    return $interval->format($differenceFormat);
    
}

?>