<?
session_name('portal_absa');
session_start();

set_time_limit(0);

require("../../excel/Spreadsheet/Excel/Classes/PHPExcel.php");
require "../../excel/Spreadsheet/Excel/Classes/PHPExcel/IOFactory.php";
require("../../conexion/conectar.php");
require("../../libs/funciones.php");
require("../../MandaCorreos/FuncionSendMail.php");

$RUTA_ALMACEN_XLS = trim(getINI("RUTA_ALMACEN_XLS=","../../config.ini"));
if($RUTA_ALMACEN_XLS == ""){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta RUTA_ALMACEN_XLS no configurada", "");exit;
}
if(!is_dir($RUTA_ALMACEN_XLS)){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "La ruta configurada RUTA_ALMACEN_XLS no existe.", "");exit;
}

eliminarAnteriores();

if(!$RFC_ACTIVOS_NOTIFICACION_PAGOS = getINI("RFC_ACTIVOS_NOTIFICACION_PAGOS=","../../config.ini")){
	setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA COMPLEMENTOS FALTANTES", "Etiqueta RFC_ACTIVOS_NOTIFICACION_PAGOS Faltante", "No se encontro la etiqueta RFC_ACTIVOS_NOTIFICACION_PAGOS en el config.ini");exit;
}

$arrRFCReceptores = explode(",",$RFC_ACTIVOS_NOTIFICACION_PAGOS);

if(!$TOLERANCIA_COMPENSADO_PAGADO = getINI("../../config.ini","TOLERANCIA_COMPENSADO_PAGADO=")){
	$TOLERANCIA_COMPENSADO_PAGADO =.5;
}

$conexion = new CONDB();
$conexion->conectar();




for($i=0; $i < count($arrRFCReceptores); $i++){
	//Extraigo Configuracion General de notificaciones
	$notificar_fecha_inicio="";
	$qConfig = "select rfc_receptor,notificar_dias,notificar_despuesde,notificar_repetirdias,notificar_correos,notificar_asunto,notificar_correos_cc,notificar_fecha_inicio,tolerancia_NPvsComplemento,tolerancia_NPvsFactura,tolerancia_FacturaPagada,tolerancia_CompensacionEgreso,tolerancia_tipoCambio from configpagina where rfc_receptor='".$arrRFCReceptores[$i]."' limit 1";
	if($rConfig = mysqli_query($conexion->CONEXION,$qConfig)){
		if(mysqli_num_rows($rConfig) > 0){
			$tConfig = mysqli_fetch_assoc($rConfig);
			$notificar_fecha_inicio = $tConfig["notificar_fecha_inicio"];
			$tConfig["tolerancia_NPvsComplemento"] = ((float) $tConfig["tolerancia_NPvsComplemento"] == "")? 0.00 : (float) $tConfig["tolerancia_NPvsComplemento"];
			$tConfig["tolerancia_NPvsFactura"] = ((float) $tConfig["tolerancia_NPvsFactura"] == "")? 0.00 : (float) $tConfig["tolerancia_NPvsFactura"];
			$tConfig["tolerancia_FacturaPagada"] = ((float) $tConfig["tolerancia_FacturaPagada"] == "")? 0.00 : (float) $tConfig["tolerancia_FacturaPagada"];
			$tConfig["tolerancia_CompensacionEgreso"] = ((float) $tConfig["tolerancia_CompensacionEgreso"] == "")? 0.00 : (float) $tConfig["tolerancia_CompensacionEgreso"];
			$tConfig["tolerancia_tipoCambio"] = ((float) $tConfig["tolerancia_tipoCambio"] == "")? 0.00 : (float) $tConfig["tolerancia_tipoCambio"];
		}
	}

	$tConfig["tolerancia_NPvsComplemento"] = (trim($tConfig["tolerancia_NPvsComplemento"]) == "")? 0 : $tConfig["tolerancia_NPvsComplemento"];
	$tConfig["tolerancia_NPvsFactura"] = (trim($tConfig["tolerancia_NPvsFactura"]) == "")? 0 : $tConfig["tolerancia_NPvsFactura"];
	$tConfig["tolerancia_FacturaPagada"] = (trim($tConfig["tolerancia_FacturaPagada"]) == "")? 0 : $tConfig["tolerancia_FacturaPagada"];
	$tConfig["tolerancia_CompensacionEgreso"] = (trim($tConfig["tolerancia_CompensacionEgreso"]) == "")? 0 : $tConfig["tolerancia_CompensacionEgreso"];
	$tConfig["tolerancia_tipoCambio"] = (trim($tConfig["tolerancia_tipoCambio"]) == "")? 0 : $tConfig["tolerancia_tipoCambio"];

	$qFaltantesPago = "select * from view_recibecfd_docs_faltantes_pago where rfc_receptor='".$arrRFCReceptores[$i]."'";


	if(!$rRecibeDoce = mysqli_query($conexion->CONEXION,$qFaltantesPago)){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Error al ejecutar la query $qFaltantesPago", "Error-> ".mysqli_error($conexion->CONEXION));exit;
	}
	if(mysqli_num_rows($rRecibeDoce) <= 0){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "La consulta no regreso información.", "");exit;
	}
	
	$objPHPExcel = new PHPExcel();
	$objPHPExcel->getProperties()->setCreator("DIS")
							 ->setLastModifiedBy("DIS")
							 ->setTitle("Office 2007 XLSX")
							 ->setSubject("Office 2007 XLSX")
							 ->setDescription("Document for Office 2007 XLSX")
							 ->setKeywords("office 2007")
							 ->setCategory("Result file");
	$num_row = 0;
	$col_name=array("A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
	$header_name = array("Proveedor","Serie","Folio","UUID","Total","Moneda","Tipo Cambio");
	$detail_name = array("Serie","Folio","Forma de pago","Parcialidad","Tipo Cambio","Moneda","Monto","Forma de pago","Parcialidad","Tipo Cambio","Moneda","Monto","REP UUID","REP Serie","REP Folio");

	while($tRecibeDoce = mysqli_fetch_array($rRecibeDoce,MYSQLI_ASSOC)){
		
		
		$montoTotalCompensado = $tRecibeDoce["totalIngresoCompensado"];
		$sumaPagadoEnPago=0.00;
		$sumaPagadoEnComplemento=0.00;
		$totalAPagarEnPago=0.00;
		$totalAPagarEnComplemento=0.00;
		$num_row++;
		//************************************
		// Titulo ICFDI
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[0].$num_row, "I CFDI");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[0].$num_row.":".$col_name[(count($header_name)-1)].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[0].$num_row.":".$col_name[(count($header_name)-1)].$num_row);
		//************************************
		
		//************************************
		// Titulos encabezado
		$num_row++;
		$col=0;
		for($row=0; $row < count($header_name); $row++){
			$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $header_name[$row]);
			$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
			$col++;
		}
		// doy formato a color a titulos del I CFDI
		headerStyle($col_name[0].$num_row.":".$col_name[(count($header_name)-1)].$num_row);
		//************************************
		
		//************************************
		// Datos del I CFDI
		$datosEncabezado = array($tRecibeDoce["nombreemi"],$tRecibeDoce["serie"],$tRecibeDoce["folio"],$tRecibeDoce["uuid"],$tRecibeDoce["total"],$tRecibeDoce["tipoMoneda"],$tRecibeDoce["TipoCambio"]);
		$num_row++;
		$col=0;
		for($row=0; $row < count($header_name); $row++){
			$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $datosEncabezado[$row]);
			$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
			$col++;
		}
		//************************************

		$qMontosAplicados = "select pdr.serie as Dserie,pdr.folio as Dfolio,pdr.adicionalA as Duuid,pdr.total as Dtotal,pdr.adicionalB as Dformadepago,pdr.uuidcfdirelacionado,pdr.monto as PDRmontoPago,pdr.numparcialidad as PDRnumparcialidad,pdr.tipocambio as PDRtipocambio,pdr.moneda as PDRmoneda,
		tmp.TipoCambioDR as RPDRtipocambio,tmp.MonedaDR as RPDRmoneda,tmp.ImpPagado as RPDRimpagado,tmp.NumParcialidad as RPDRnumparcialidad,
		r.nombreemi,r.serie,r.folio,r.MetodoDePago,
		tmp.MonedaP as RDPmoneda,tmp.Monto as RDPmonto,tmp.recibedoce_UUID,tmp.TipoCambioP as RDPtipocambio,tmp.FormaDePago as RDPformadepago,
		tmp.serie as RepSerie,tmp.folio as RepFolio,tmp.uuid as RepUUID,tmp.recibedoce_pagos_id as recibedoce_pagos_id
		from 
		
		(select d.serie,d.folio,d.adicionalA,d.total,d.adicionalB,pdr.uuidcfdirelacionado,pdr.monto,pdr.numparcialidad,pdr.tipocambio,pdr.moneda,pdr.MetodoDePago,pdr.doce_uuid from doce d inner join
		pago_documentos_ref pdr ON d.adicionalA=pdr.doce_uuid where d.status = 1) as pdr			
		
		left join 
		
		(select rpdr.recibedoce_pagos_ID, rpdr.uuidCFDIRelacionado, rpdr.doce_UUID, rpdr.MonedaDR, rpdr.TipoCambioDR, rpdr.NumParcialidad, rpdr.ImpPagado, rpdr.MetodoDePago, rdp.recibedoce_UUID, rdp.FechaPago, rdp.TipoCambioP, rdp.MonedaP, rdp.Monto, rdp.RfcEmisorCtaOrd, rdp.RfcEmisorCtaBen, rdp.FormaDePago,rcomplemento.serie,rcomplemento.folio,rcomplemento.uuid  from 
		recibedoce_pagos_docto_relacionado rpdr 
		left join recibedoce_pagos rdp ON rpdr.recibedoce_pagos_id = rdp.recibedoce_pagos_id 
		left join recibedoce rcomplemento ON rdp.recibedoce_UUID=rcomplemento.uuid where rpdr.uuidCFDIRelacionado = '".$tRecibeDoce["uuid"]."' and rcomplemento.status not in('R','C'))as tmp
		
		ON pdr.doce_uuid = tmp.doce_UUID and pdr.uuidcfdirelacionado = tmp.uuidCFDIRelacionado and (pdr.numparcialidad = tmp.NumParcialidad or pdr.numparcialidad <> tmp.NumParcialidad)
		left join recibedoce r on tmp.uuidCFDIRelacionado = r.uuid where pdr.uuidCFDIRelacionado='".$tRecibeDoce["uuid"]."'
		
		UNION ALL
		
		select pdr.serie as Dserie,pdr.folio as Dfolio,pdr.adicionalA as Duuid,pdr.total as Dtotal,pdr.adicionalB as Dformadepago,pdr.uuidcfdirelacionado,pdr.monto as PDRmontoPago,pdr.numparcialidad as PDRnumparcialidad,pdr.tipocambio as PDRtipocambio,pdr.moneda as PDRmoneda,
		tmp.TipoCambioDR as RPDRtipocambio,tmp.MonedaDR as RPDRmoneda,tmp.ImpPagado as RPDRimpagado,tmp.NumParcialidad as RPDRnumparcialidad,
		r.nombreemi,r.serie,r.folio,r.MetodoDePago,
		tmp.MonedaP as RDPmoneda,tmp.Monto as RDPmonto,tmp.recibedoce_UUID,tmp.TipoCambioP as RDPtipocambio,tmp.FormaDePago as RDPformadepago,
		tmp.serie as RepSerie,tmp.folio as RepFolio,tmp.uuid as RepUUID,tmp.recibedoce_pagos_id as recibedoce_pagos_id
		from 
		
		(select d.serie,d.folio,d.adicionalA,d.total,d.adicionalB,pdr.uuidcfdirelacionado,pdr.monto,pdr.numparcialidad,pdr.tipocambio,pdr.moneda,pdr.MetodoDePago,pdr.doce_uuid from doce d inner join
		pago_documentos_ref pdr ON d.adicionalA=pdr.doce_uuid where d.status = 1) as pdr
		
		
		right join 
		
		(select rpdr.recibedoce_pagos_ID, rpdr.uuidCFDIRelacionado, rpdr.doce_UUID, rpdr.MonedaDR, rpdr.TipoCambioDR, rpdr.NumParcialidad, rpdr.ImpPagado, rpdr.MetodoDePago, rdp.recibedoce_UUID, rdp.FechaPago, rdp.TipoCambioP, rdp.MonedaP, rdp.Monto, rdp.RfcEmisorCtaOrd, rdp.RfcEmisorCtaBen, rdp.FormaDePago,rcomplemento.serie,rcomplemento.folio,rcomplemento.uuid,rcomplemento.status  from 
		recibedoce_pagos_docto_relacionado rpdr 
		left join recibedoce_pagos rdp ON rpdr.recibedoce_pagos_id = rdp.recibedoce_pagos_id 
		left join recibedoce rcomplemento ON rdp.recibedoce_UUID=rcomplemento.uuid where rpdr.uuidCFDIRelacionado = '".$tRecibeDoce["uuid"]."' and 
		rcomplemento.status not in('R','C'))as tmp
		
		ON pdr.doce_uuid = tmp.doce_UUID and pdr.uuidcfdirelacionado = tmp.uuidCFDIRelacionado and (pdr.numparcialidad = tmp.NumParcialidad or pdr.numparcialidad <> tmp.NumParcialidad)
		left join recibedoce r on tmp.uuidCFDIRelacionado = r.uuid where pdr.doce_uuid is null";
				
		if(!$rMontosAplicados = mysqli_query($conexion->CONEXION,$qMontosAplicados)){
			
			setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Error al ejecutar la consulta de montos aplicados", "Error->".mysqli_error($conexion->CONEXION));exit;
		}
		if(mysqli_num_rows($rMontosAplicados) <= 0){
			continue;
		}
		$num_row++;
		//************************************
		// Titulo PAGOS AL DOCUMENTO
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[1].$num_row, "PAGOS AL DOCUMENTO");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[1].$num_row.":".$col_name[(count($detail_name)+1)].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[1].$num_row.":".$col_name[(count($detail_name)+1)].$num_row);
		//************************************
		
		$num_row++;
		//************************************
		// Titulo Pago / I CFDI 3.3
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[1].$num_row, "Pago / I CFDI 3.3");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[1].$num_row.":".$col_name[7].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[1].$num_row.":".$col_name[7].$num_row);
		//************************************
		
		//************************************
		// Titulo Complemento / I CFDI 3.3
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[8].$num_row, "Complemento / I CFDI 3.3");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[8].$num_row.":".$col_name[16].$num_row);
		// doy formato a color a celdas combinadas
		headerStyle($col_name[8].$num_row.":".$col_name[16].$num_row);
		//************************************
		
		//************************************
		// Titulos Detalle
		$num_row++;
		$col=1;
		for($row=0; $row < count($detail_name); $row++){
			$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $detail_name[$row]);
			$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
			$col++;
		}
		// doy formato a color a titulos del I CFDI
		headerStyle($col_name[1].$num_row.":".$col_name[7].$num_row,"7FB3D5");
		headerStyle($col_name[8].$num_row.":".$col_name[16].$num_row,"7DCEA0");
		//************************************
			
		$con=0;
		$tdEstiloPagoTotalNP="";
		$tdEstiloPagoTotalREP="";
		$tdEstiloPagoNPvsComplemento="";
		$banIncorrecto=false;
		$sumaPagadoEnComplemento=0.00;
		$sumaPagadoEnPago=0.00;
		while($tMontosAplicados = mysqli_fetch_array($rMontosAplicados,MYSQLI_ASSOC)){

			$sumaPagadoEnComplemento+=$tMontosAplicados["RPDRimpagado"];
			$sumaPagadoEnPago+=$tMontosAplicados["PDRmontoPago"];
			$con++;
			
			$tdEstiloMonto = "FFFFFF";
			$tdEstiloTipoCambio = "FFFFFF";
			$tdEstiloMoneda = "FFFFFF";
			$tdEstiloParcialidad = "FFFFFF";
			$tdEstiloFormaDePago = "FFFFFF";
			$tdEstiloREPAplicado = "FFFFFF";
			if((float) $tMontosAplicados["PDRmontoPago"] != (float) $tMontosAplicados["RPDRimpagado"]){
				$diferencia = (float) $tMontosAplicados["PDRmontoPago"] - (float) $tMontosAplicados["RPDRimpagado"];
				if($diferencia < 0){
					$diferencia = $diferencia * -1;
				}
				
				if((float) $diferencia > (float) $tConfig["tolerancia_NPvsComplemento"]){
					// Red Pastel
					$tdEstiloMonto = "E74C3C";
					$banIncorrecto=true;
				}else{
					// Orange pastel
					$tdEstiloMonto = "EB984E";
				}
				// $tdEstiloMonto="style='background-color: red'";
				// $banIncorrecto=true;
			}
			if((float) $tMontosAplicados["PDRtipocambio"] != (float) $tMontosAplicados["RPDRtipocambio"]){
				$diferencia = (float) $tMontosAplicados["PDRtipocambio"] - (float) $tMontosAplicados["RPDRtipocambio"];
				if($diferencia < 0){
					$diferencia = $diferencia * -1;
				}
				
				if((float) $diferencia > (float) $tConfig["tolerancia_tipoCambio"]){
					// red pastel
					$tdEstiloTipoCambio = "E74C3C";
					$banIncorrecto=true;
				}else{
					// orange pastel
					$tdEstiloTipoCambio = "EB984E";
				}
				// $tdEstiloTipoCambio="style='background-color: red'";
				// $banIncorrecto=true;
				
			}
			if($tMontosAplicados["PDRmoneda"] != $tMontosAplicados["RPDRmoneda"]){
				// red pastel
				$tdEstiloMoneda="E74C3C";
				$banIncorrecto=true;
				
			}
			if($tMontosAplicados["PDRnumparcialidad"] != $tMontosAplicados["RPDRnumparcialidad"]){
				// red pastel
				$tdEstiloParcialidad="E74C3C";
				$banIncorrecto=true;
			}
			if($tMontosAplicados["Dformadepago"] != $tMontosAplicados["RDPformadepago"]){
				// red pastel
				$tdEstiloFormaDePago="E74C3C";
				$banIncorrecto=true;
			}
			
			if($tRecibeDoce["MetodoDePago"] == "PUE"){
				if($tMontosAplicados["RPDRimpagado"] != "" && $tMontosAplicados["RPDRimpagado"] != 0){
					// yellow pastel
					$tdEstiloFormaDePago="F4D03F";
					$tdEstiloParcialidad="F4D03F";
					$tdEstiloMoneda="F4D03F";
					$tdEstiloTipoCambio = "F4D03F";
					$tdEstiloMonto = "F4D03F";
					$tdEstiloREPAplicado = "F4D03F";
					$banIncorrecto=true;
				}else{
					$tdEstiloFormaDePago="FFFFFF";
					$tdEstiloParcialidad="FFFFFF";
					$tdEstiloMoneda="FFFFFF";
					$tdEstiloTipoCambio = "FFFFFF";
					$tdEstiloMonto = "FFFFFF";
					$tdEstiloREPAplicado = "FFFFFF";
					$banIncorrecto=false;
				}
			}
			$datosDetalle = array($tMontosAplicados["Dserie"],$tMontosAplicados["Dfolio"],$tMontosAplicados["Dformadepago"],$tMontosAplicados["PDRnumparcialidad"],$tMontosAplicados["PDRtipocambio"],$tMontosAplicados["PDRmoneda"],$tMontosAplicados["PDRmontoPago"],$tMontosAplicados["RDPformadepago"],$tMontosAplicados["RPDRnumparcialidad"],$tMontosAplicados["RPDRtipocambio"],$tMontosAplicados["RPDRmoneda"],$tMontosAplicados["RPDRimpagado"],$tMontosAplicados["RepUUID"],$tMontosAplicados["RepSerie"],$tMontosAplicados["RepFolio"]);
			$datosColor = array($tdEstiloREPAplicado,$tdEstiloREPAplicado,$tdEstiloFormaDePago,$tdEstiloParcialidad,$tdEstiloTipoCambio,$tdEstiloMoneda,$tdEstiloMonto,$tdEstiloFormaDePago,$tdEstiloParcialidad,$tdEstiloTipoCambio,$tdEstiloMoneda,$tdEstiloMonto,$tdEstiloREPAplicado,$tdEstiloREPAplicado,$tdEstiloREPAplicado);
			
			$num_row++;
			$col=1;
			for($row=0; $row < count($detail_name); $row++){
				$objPHPExcel->getActiveSheet()->setCellValue($col_name[$col].$num_row, $datosDetalle[$row]);
				$objPHPExcel->getActiveSheet()->getColumnDimension($col_name[$col])->setAutoSize(true);
				// formateo la celda segun las validaciones anteriores, indicando status de celdas
				$objPHPExcel->getActiveSheet()->getStyle($col_name[$col].$num_row)->applyFromArray(
					array(
						'fill' => array(
							'type' => PHPExcel_Style_Fill::FILL_SOLID,
							'color' => array('rgb' => $datosColor[$row])
						)
					)
				);

				$col++;
			}
			
			
		}  // while detalle 
		
		//Multiplico por 1000000 para sacar la parte entera y poder comparar enteros, ya que con decimales hay problemas
		$sumaPagadoEnPago1000000 = $sumaPagadoEnPago * 1000000;
		$sumaPagadoEnComplemento1000000 = $sumaPagadoEnComplemento * 1000000;
		$arrSumaPagadoEnPago1000000 = explode(".",$sumaPagadoEnPago1000000);
		$arrSumaPagadoEnComplemento1000000 = explode(".",$sumaPagadoEnComplemento1000000);
		
		$tdEstiloPagoNPvsComplemento = "FFFFFF";
		$tdEstiloPagoTotalNP = "FFFFFF";
		$tdEstiloPagoTotalREP = "FFFFFF";
		
		if($tRecibeDoce["MetodoDePago"] != "PUE"){
			// if($sumaPagadoEnPago != $sumaPagadoEnComplemento){
			if($arrSumaPagadoEnPago1000000[0] != $arrSumaPagadoEnComplemento1000000[0]){
				$diferencia = (float) $sumaPagadoEnPago - (float) $sumaPagadoEnComplemento;
				if($diferencia < 0){
					$diferencia = $diferencia * -1;
				}
				
				if((float) $diferencia > (float) $tConfig["tolerancia_NPvsComplemento"]){
					// red pastel
					$tdEstiloPagoNPvsComplemento = "E74C3C";
					$banIncorrecto=true;
				}else{
					// orange pastel
					$tdEstiloPagoNPvsComplemento = "EB984E";
				}
				// $tdEstiloPagoTotalNP="style='background-color: red'";
				// $banIncorrecto=true;
			}
			//echo $tRecibeDoce["total"]." - ".$sumaPagadoEnPago." - ".$montoTotalCompensado;
			$totalAPagarEnPago = $tRecibeDoce["total"] - ($sumaPagadoEnPago + $montoTotalCompensado);
			$totalAPagarEnComplemento = $tRecibeDoce["total"] - ($sumaPagadoEnComplemento + $montoTotalCompensado);
		}else{
			if($tRecibeDoce["ImpPagadoComplemento"] != 0){
				// yellow pastel
				$tdEstiloPagoNPvsComplemento = "F4D03F";
				$banIncorrecto=true;
			}
		}

		if($totalAPagarEnPago != 0){
			
			$totalAPagarEnPagoNoNegativo = $totalAPagarEnPago;
			if($totalAPagarEnPagoNoNegativo < 0){$totalAPagarEnPagoNoNegativo = $totalAPagarEnPagoNoNegativo*-1;}
			
			$tolerancia_FacturaPagada1000000 = explode(".",$tConfig["tolerancia_FacturaPagada"] * 1000000);
			$totalAPagarEnPagoNoNegativo1000000 = explode(".",$totalAPagarEnPagoNoNegativo * 1000000);
			
			if((float) $totalAPagarEnPagoNoNegativo1000000[0] > (float) $tolerancia_FacturaPagada1000000[0]){
				// red pastel
				$tdEstiloPagoTotalNP = "E74C3C";
				$banIncorrecto=true;
			}else{
				// orange pastel
				$tdEstiloPagoTotalNP = "EB984E";
			}
			// $tdEstiloPagoTotalNP="style='background-color: red'";
			// $banIncorrecto=true;
		}
		if($totalAPagarEnComplemento != 0){
			$totalAPagarEnComplementoNoNegativo = $totalAPagarEnComplemento;
			if($totalAPagarEnComplementoNoNegativo < 0){$totalAPagarEnComplementoNoNegativo = $totalAPagarEnComplementoNoNegativo*-1;}
			
			$tolerancia_FacturaPagada1000000 = explode(".",$tConfig["tolerancia_FacturaPagada"] * 1000000);
			$totalAPagarEnComplementoNoNegativo1000000 = explode(".",$totalAPagarEnComplementoNoNegativo * 1000000);
			
			if((float) $totalAPagarEnComplementoNoNegativo1000000[0] > (float) $tolerancia_FacturaPagada1000000[0]){
				// red pastel
				$tdEstiloPagoTotalREP = "E74C3C";
				$banIncorrecto=true;
			}else{
				// orange pastel
				$tdEstiloPagoTotalREP = "EB984E";
			}
			// $tdEstiloPagoTotalREP="style='background-color: red'";
			// $banIncorrecto=true;
		}
		
		$num_row++;
		//************************************
		// Titulo Total pagado
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[0].$num_row, "Total Pagado");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[0].$num_row.":".$col_name[6].$num_row);
		//************************************
		//************************************
		// Valor total pagado NP
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[7].$num_row, $tRecibeDoce["totalPagoDocumentosRef"]);
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[7].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoNPvsComplemento)
				)
			)
		);
		//************************************
		
		//************************************
		// Titulo Total pagado
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[8].$num_row, "Total Pagado");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[8].$num_row.":".$col_name[11].$num_row);
		//************************************
		//************************************
		// Valor total pagado REP
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[12].$num_row, $tRecibeDoce["ImpPagadoComplemento"]);
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[12].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoNPvsComplemento)
				)
			)
		);
		//************************************
		
		$num_row++;
		//************************************
		// Titulo Total Compensado
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[0].$num_row, "Total Compensado");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[0].$num_row.":".$col_name[6].$num_row);
		//************************************
		//************************************
		// Valor total pagado NP
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[7].$num_row, $tRecibeDoce["totalIngresoCompensado"]);
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[7].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoNPvsComplemento)
				)
			)
		);
		//************************************
		
		$num_row++;
		//************************************
		// Titulo Total a Pagar
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[0].$num_row, "Total a Pagar");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[0].$num_row.":".$col_name[6].$num_row);
		//************************************
		//************************************
		// Valor total a Pagar NP
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[7].$num_row, number_format($totalAPagarEnPago,2,".",""));
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[7].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoTotalNP)
				)
			)
		);
		//************************************
		
		//************************************
		// Titulo Total a Pagar
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[8].$num_row, "Total a Pagar");
		// combino celdas
		$objPHPExcel->getActiveSheet()->mergeCells($col_name[8].$num_row.":".$col_name[11].$num_row);
		//************************************
		//************************************
		// Valor total a Pagar REP
		$objPHPExcel->getActiveSheet()->setCellValue($col_name[12].$num_row, number_format($totalAPagarEnComplemento,2,".",""));
		// formateo la celda segun las validaciones anteriores, indicando status de celdas
		$objPHPExcel->getActiveSheet()->getStyle($col_name[12].$num_row)->applyFromArray(
			array(
				'fill' => array(
					'type' => PHPExcel_Style_Fill::FILL_SOLID,
					'color' => array('rgb' => $tdEstiloPagoTotalREP)
				)
			)
		);
		//************************************
		
	}// while encabezado
	$objPHPExcel->getActiveSheet()->setTitle("Documentos Faltantes de Pago");

	$objPHPExcel->setActiveSheetIndex(0);
	$nombreArchivo = date("YmdHis");
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

	$objWriter->save($RUTA_ALMACEN_XLS.$nombreArchivo.'.xlsx');

	enviaCorreo($nombreArchivo,$tConfig);
}// for receptores

function enviaCorreo($nombreArchivo,$tConfig){
	global $conexion;
	$correos = getINI($tConfig["rfc_receptor"]."_CORREOS_ENVIAR_DOCS_FALTANTES_PAGO=","../../config.ini");
	$asunto = getINI($tConfig["rfc_receptor"]."_ASUNTO_ENVIAR_DOCS_FALTANTES_PAGO=","../../config.ini");
	$cuerpo = getINI($tConfig["rfc_receptor"]."_CUERPO_ENVIAR_DOCS_FALTANTES_PAGO=","../../config.ini");
	if(trim($cuerpo) != ""){
		if(!file_exists($cuerpo)){
			setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta ".$tConfig["rfc_receptor"]."_CUERPO_ENVIAR_DOCS_FALTANTES_PAGO", "El archivo no existe");exit;
		}else{
			$cuerpo = file_get_contents($cuerpo);
		}
	}else{
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta ".$tConfig["rfc_receptor"]."_CUERPO_ENVIAR_DOCS_FALTANTES_PAGO", "No configurada");exit;
	}
	$DIAS_DISPONIBLE_REPORTES = getINI("DIAS_DISPONIBLE_REPORTES=","../../config.ini");
	$URL_DESCARGA_XLS = getINI("URL_DESCARGA_XLS=","../../config.ini");
	$arrLbl = array("<<DIAS_DISPONIBLE_REPORTES>>","<<URL_DESCARGA_XLS>>");
	$arrVal = array($DIAS_DISPONIBLE_REPORTES,$URL_DESCARGA_XLS.$nombreArchivo.".xlsx");
	$cuerpo = str_replace($arrLbl,$arrVal,$cuerpo);
	if(trim($correos) == ""){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Etiqueta ".$tConfig["rfc_receptor"]."_CORREOS_ENVIAR_DOCS_FALTANTES_PAGO no configurada", "");exit;
	}
	
	
	if(!@SendMail($correos,$correos,utf8_decode($asunto),$cuerpo,"","","")){
		setBitacora($conexion, "AUTOMATICO", "" , "NOTIFICACION AUTOMATICA FALTANTES DE PAGO-TODOS", "Error al enviar el correo","");exit;
	}
	
	
}

function eliminarAnteriores(){
	global $RUTA_ALMACEN_XLS;
	
	$DIAS_DISPONIBLE_REPORTES = getINI("DIAS_DISPONIBLE_REPORTES=","../../config.ini");

	$directorio = opendir($RUTA_ALMACEN_XLS);
	while ($archivo = readdir($directorio)){
		$arrNombre = pathinfo($archivo);
		$nameFile = $RUTA_ALMACEN_XLS.$arrNombre["filename"].".".$arrNombre["extension"];
		if(is_file($nameFile)){
			if(trim($DIAS_DISPONIBLE_REPORTES) == "" || trim($DIAS_DISPONIBLE_REPORTES) == "0"){
				$DIAS_DISPONIBLE_REPORTES = 5;
			}
			
			$fechaArchivo = substr($arrNombre["filename"],0,8);
			
			$nuevafecha = strtotime ( '+'.$DIAS_DISPONIBLE_REPORTES.' day' , strtotime ( $fechaArchivo ) ) ;
			$fecha = date("Ymd");
			$nuevafecha = date("Ymd",$nuevafecha);
			if((int)$fecha > (int)$nuevafecha){
				unlink($nameFile);
			}
		}
	}

}

function headerStyle($rango,$backgroundColor = "EEEEEE"){
	global $objPHPExcel;
	//header style
	$objPHPExcel->getActiveSheet()->getStyle($rango)->applyFromArray(
			array(
				'font'    => array(
					'bold'      => true
				),
				'alignment' => array(
					'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				),
				'borders' => array(
					'top'     => array(
						'style' => PHPExcel_Style_Border::BORDER_THIN
					)
				),
				'fill' => array(
					'type'       => PHPExcel_Style_Fill::FILL_SOLID,
					'rotation'   => 90,
					'startcolor' => array(
						'argb' => $backgroundColor
					),
					'endcolor'   => array(
						'argb' => 'FFFFFFFF'
					)
				)
			)
	);
}
?>