<?
/*
Autor: Lic. Carlos Alberto Vaca Coronado
Version: 3.4.0
Cambio: archivo nuevo para verificar los CFDI en el SAT
*/

//require_once('../WS//lib/nusoap.php');
//error_reporting(E_ALL);
set_time_limit(0);
session_name('portal_absa');
session_start();

require_once('../../WS/lib/nusoap/src/nusoap.php');
require_once('../../WS/ws_SAT.php');
require_once('../../conexion/conectar.php');

define("DEBUG",1);

$conexion = new CONDB();
$conexion->conectar();

$qUUIDS = "select rfcemisor,rfc_receptor,total,uuid,tipodocto,serie,folio from recibedoce where fecharecibido >='2016-01-01T00:00:00' and verificacionSAT in ('?', 'P')";

if(!$rUUIDS = mysqli_query($conexion->CONEXION,$qUUIDS)){
	writeLog("verificaCFDIMasivo","Error: ".mysqli_error($conexion->CONEXION),1,DEBUG);
	exit;
}

if(mysqli_num_rows($rUUIDS) <= 0){
	writeLog("verificaCFDIMasivo","No se encontraron registros.",1,DEBUG);
	exit;
}
writeLog("verificaCFDIMasivo","Iniciando con las verificaciones.",0,DEBUG);
while($tmp = mysqli_fetch_array($rUUIDS,MYSQLI_ASSOC)){
	$rr = $tmp["rfc_receptor"];
	$tt = $tmp["total"];
	$re = $tmp["rfcemisor"];
	$tipodocto = $tmp["tipodocto"];
	$serie = $tmp["serie"];
	$folio = $tmp["folio"];
	$uuid = $tmp["uuid"];


	$ws = new WSSAT();

	$ws->expresionImpresa="?re=$re&rr=$rr&tt=$tt&id=".$uuid;
	writeLog("verificaCFDIMasivo","Verificando UUID $uuid",0,DEBUG);
	$ws->verificaCFDI();


	$requestWSDL = $ws->request;
	$responseWSDL = $ws->response;

	/*echo htmlspecialchars($requestWSDL,ENT_QUOTES)."<br/><br/><br/>";
	echo htmlspecialchars($responseWSDL,ENT_QUOTES);*/
	// exit;
	
	if($ws->codigoStatus == "S"){
		if(trim($ws->estadoCFDI)=="Cancelado"){
			$Estatus='C';
		}else{
			$Estatus='V';
		}
	}else{
		writeLog("verificaCFDIMasivo","Request:",1,DEBUG);
		writeLog("verificaCFDIMasivo",$ws->request,1,DEBUG);
		writeLog("verificaCFDIMasivo","Response:",1,DEBUG);
		writeLog("verificaCFDIMasivo",$ws->response,1,DEBUG);
		$Estatus='?';
	}
	
	writeLog("verificaCFDIMasivo","Status: $Estatus",0,DEBUG);
	
	$mensajeCompleto=$ws->mensajeCompleto."\n".$ws->estadoCFDI."\n";

	$query="update recibedoce set verificacionSAT='$Estatus' where uuid='$uuid'";
	writeLog("verificaCFDIMasivo","Actualizando status de UUID $uuid",0,DEBUG);
	if(mysqli_query($conexion->CONEXION,$query)){
		writeLog("verificaCFDIMasivo","Insertando en detalle de recibedoce el evento de verificación",0,DEBUG);
		$query="insert into detallerecibedoce set rfcemisor='$re',tipodocto='$tipodocto',serie='$serie',folio='$folio',
		uuid='$uuid',fechaEvento=NOW(),evento='Verificacion de CFDI', status='$Estatus',fecharecibido=current_timestamp(),xml='',pdf='',comentario='".mysqli_real_escape_string($conexion->CONEXION,str_replace("-"," ",limpiar_caracteres_especiales($mensajeCompleto)))."<<SAT>>',request='".mysqli_real_escape_string($conexion->CONEXION,$requestWSDL)."',response='".mysqli_real_escape_string($conexion->CONEXION,$responseWSDL)."'";
		
		if(!mysqli_query($conexion->CONEXION,$query)){
			writeLog("verificaCFDIMasivo","Error al insertar en detale de recibedoce el evento de verificación. Error: ".mysqli_error($conexion->CONEXION),1,DEBUG);
		}
		
	}else{
		writeLog("verificaCFDIMasivo","Error al actualizar status",1,DEBUG);
		echo mysqli_error($conexion->CONEXION);
	}

}
writeLog("verificaCFDIMasivo","Finalización del proceso.",1,DEBUG);
function limpiar_caracteres_especiales($s) {
	$s = preg_replace("[áàâãª]","a",$s);
	$s = preg_replace("[ÁÀÂÃ]","A",$s);
	$s = preg_replace("[éèê]","e",$s);
	$s = preg_replace("[ÉÈÊ]","E",$s);
	$s = preg_replace("[íìî]","i",$s);
	$s = preg_replace("[ÍÌÎ]","I",$s);
	$s = preg_replace("[óòôõº]","o",$s);
	$s = preg_replace("[ÓÒÔÕ]","O",$s);
	$s = preg_replace("[úùû]","u",$s);
	$s = preg_replace("[ÚÙÛ]","U",$s);
	$s = str_replace(" ","-",$s);
	$s = str_replace("ñ","n",$s);
	$s = str_replace("Ñ","N",$s);
	//para ampliar los caracteres a reemplazar agregar lineas de este tipo:
	//$s = str_replace("caracter-que-queremos-cambiar","caracter-por-el-cual-lo-vamos-a-cambiar",$s);
	return $s;
}
function writeLog($nombreArchivo, $mensaje, $log, $debug){
	$logArchivo = $nombreArchivo."_".date("Ymd").".log";
	$debugArchivo = $nombreArchivo."_".date("Ymd").".debug";
	if($log == 1){
		if(file_exists($logArchivo)){$fp = fopen($logArchivo,"a+");}else{$fp = fopen($logArchivo,"w+");}
		$fecha = date("Y-m-d-TH:i:s");
		fwrite($fp,"\r\n".$fecha." -> ".$mensaje);
		fclose($fp);
	}
	if($debug == 1){
		if(file_exists($debugArchivo)){$fp = fopen($debugArchivo,"a+");}else{$fp = fopen($debugArchivo,"w+");}
		$fecha = date("Y-m-d-TH:i:s");
		fwrite($fp,"\r\n".$fecha." -> ".$mensaje);
		fclose($fp);
	}
}
?>